/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.multi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.gtreimagined.gt5r.machine.caps.ParallelRecipeHandler;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityMultiMachine;
import org.gtreimagined.gtlib.capability.item.ITrackedHandler;
import org.gtreimagined.gtlib.capability.item.MultiTrackedItemHandler;
import org.gtreimagined.gtlib.capability.machine.MachineItemHandler;
import org.gtreimagined.gtlib.capability.machine.MultiMachineItemHandler;
import org.gtreimagined.gtlib.machine.types.Machine;

public class BlockEntityLargeSifter
extends BlockEntityMultiMachine<BlockEntityLargeSifter> {
    public Set<Integer> HATCH_LAYERS = new HashSet<Integer>();

    public BlockEntityLargeSifter(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.recipeHandler.set(() -> new ParallelRecipeHandler<BlockEntityLargeSifter>(this, 64){

            @Override
            protected boolean addSingleItemOutput() {
                List outputs = BlockEntityLargeSifter.this.itemHandler.map(i -> ((LargeSifterMultiMachineItemHandler)i).outputList).orElse(List.of());
                if (outputs.isEmpty()) {
                    return false;
                }
                ItemStack[] stacks = this.activeRecipe.getOutputItems(false);
                if (BlockEntityLargeSifter.this.itemHandler.map(i -> !i.canOutputsFit(stacks)).orElse(false).booleanValue()) {
                    return false;
                }
                int sucessful = 0;
                boolean chance = this.activeRecipe.hasOutputChances();
                for (int i2 = 0; i2 < outputs.size() && stacks.length != i2; ++i2) {
                    ItemStack stack = stacks[i2];
                    if (chance && Ref.RNG.nextInt(10000) >= this.activeRecipe.getOutputChances()[i2]) {
                        ++sucessful;
                        continue;
                    }
                    BlockEntityLargeSifter.insertItem((ITrackedHandler)outputs.get(i2), stack, false);
                    ++sucessful;
                }
                return sucessful == stacks.length;
            }
        });
        this.itemHandler.set(() -> new LargeSifterMultiMachineItemHandler(this));
    }

    public boolean checkStructure() {
        this.HATCH_LAYERS.clear();
        return super.checkStructure();
    }

    public static ItemStack insertItem(ITrackedHandler to, ItemStack stack, boolean simulate) {
        if (to == null || stack.m_41619_()) {
            return stack;
        }
        for (int i = 0; i < to.getSlots(); ++i) {
            if (!(stack = to.insertOutputItem(i, stack, simulate)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }

    private static class LargeSifterMultiMachineItemHandler
    extends MultiMachineItemHandler<BlockEntityLargeSifter> {
        List<ITrackedHandler> outputList = new ArrayList<ITrackedHandler>();

        public LargeSifterMultiMachineItemHandler(BlockEntityLargeSifter sifter) {
            super((BlockEntityMultiMachine)sifter);
        }

        public void invalidate() {
            super.invalidate();
            this.outputList.clear();
        }

        protected int compareOutputBuses(MachineItemHandler<?> a, MachineItemHandler<?> b) {
            return a.getTile().m_58899_().m_123342_() < b.getTile().m_58899_().m_123342_() ? 1 : -1;
        }

        protected ITrackedHandler calculateOutputs() {
            this.outputList = ((BlockEntityLargeSifter)this.tile).getComponentsByHandlerId(this.outputComponentString()).stream().filter(t -> t.getItemHandler().isPresent()).map(t -> (MachineItemHandler)t.getItemHandler().get()).sorted(this::compareOutputBuses).map(MachineItemHandler::getOutputHandler).collect(Collectors.toList());
            return new MultiTrackedItemHandler(this.outputList.toArray(new IItemHandlerModifiable[0]));
        }
    }
}

