/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.multi;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.gtreimagined.gt5r.GT5Reimagined;
import org.gtreimagined.gt5r.block.BlockCasing;
import org.gtreimagined.gt5r.data.GT5RBlocks;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gtcore.item.ItemSelectorTag;
import org.gtreimagined.gtlib.block.BlockBasic;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityMultiMachine;
import org.gtreimagined.gtlib.capability.machine.MachineRecipeHandler;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.ICanSyncData;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.gui.widget.InfoRenderWidget;
import org.gtreimagined.gtlib.gui.widget.WidgetSupplier;
import org.gtreimagined.gtlib.integration.xei.renderer.IInfoRenderer;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.gtreimagined.gtlib.machine.event.MachineEvent;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.texture.Texture;

public class BlockEntityLargeBoiler
extends BlockEntityMultiMachine<BlockEntityLargeBoiler> {
    private int euPerTick = 0;
    private int efficiency = 0;

    public BlockEntityLargeBoiler(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.recipeHandler.set(() -> new MachineRecipeHandler<BlockEntityLargeBoiler>(this){
            private int efficiencyIncrease;
            private int integratedCircuitConfig;
            private int excessFuel;
            private int excessProjectedEU;
            boolean explode;
            {
                this.integratedCircuitConfig = 0;
                this.excessFuel = 0;
                this.excessProjectedEU = 0;
                this.explode = false;
            }

            public boolean consumePower(boolean simulate) {
                if (this.processingBlocked) {
                    return false;
                }
                int tGeneratedEU = (int)((long)BlockEntityLargeBoiler.this.euPerTick * 2L * (long)BlockEntityLargeBoiler.this.efficiency / 10000L);
                if (tGeneratedEU > 0 && !simulate) {
                    int amount = (tGeneratedEU + 160) / 160;
                    BlockEntityLargeBoiler.this.fluidHandler.ifPresent(f -> {
                        if (f.drainInput(Materials.Water.getLiquid(amount), IFluidHandler.FluidAction.EXECUTE).getAmount() == amount || f.drainInput(Materials.DistilledWater.getLiquid(amount), IFluidHandler.FluidAction.EXECUTE).getAmount() == amount) {
                            f.addOutputs(new FluidStack[]{Materials.Steam.getGas(tGeneratedEU)});
                            ((BlockEntityLargeBoiler)this.tile).onMachineEvent((IMachineEvent)MachineEvent.FLUIDS_OUTPUTTED, new Object[0]);
                        } else {
                            this.explode = true;
                        }
                    });
                }
                return true;
            }

            public void checkRecipe() {
                super.checkRecipe();
                BlockEntityLargeBoiler.this.itemHandler.ifPresent(i -> {
                    ItemStack circuit = i.getHandler(SlotType.STORAGE).getStackInSlot(0);
                    Item patt3788$temp = circuit.m_41720_();
                    if (patt3788$temp instanceof ItemSelectorTag) {
                        ItemSelectorTag intCircuit = (ItemSelectorTag)patt3788$temp;
                        if (intCircuit.circuitId > 0 && intCircuit.circuitId <= 24) {
                            this.integratedCircuitConfig = intCircuit.circuitId;
                        }
                    } else if (this.integratedCircuitConfig != 0) {
                        this.integratedCircuitConfig = 0;
                    }
                });
            }

            public void onServerUpdate() {
                if (this.explode) {
                    BlockEntityLargeBoiler.this.explodeMultiblock();
                    return;
                }
                super.onServerUpdate();
                if (((BlockEntityLargeBoiler)this.tile).machineState == MachineState.ACTIVE && BlockEntityLargeBoiler.this.efficiency < 10000) {
                    BlockEntityLargeBoiler.this.efficiency += this.efficiencyIncrease;
                    if (BlockEntityLargeBoiler.this.efficiency > 10000) {
                        BlockEntityLargeBoiler.this.efficiency = 10000;
                    }
                } else if (((BlockEntityLargeBoiler)this.tile).machineState != MachineState.ACTIVE && BlockEntityLargeBoiler.this.efficiency > 0) {
                    BlockEntityLargeBoiler.this.efficiency -= Math.min(BlockEntityLargeBoiler.this.efficiency, 1000);
                }
            }

            protected void calculateDurations() {
                this.maxProgress = this.activeRecipe.getDuration();
                if (this.activeRecipe.hasInputItems()) {
                    this.excessFuel += (int)this.activeRecipe.getPower();
                    this.maxProgress += this.excessFuel / 80;
                    this.excessFuel %= 80;
                }
                this.maxProgress = this.adjustBurnTimeForConfig(BlockEntityLargeBoiler.this.runtimeBoost(this.maxProgress));
                BlockEntityLargeBoiler.this.euPerTick = this.adjustEUtForConfig(BlockEntityLargeBoiler.this.getEUt());
                this.efficiencyIncrease = BlockEntityLargeBoiler.this.getEfficiencyIncrease() * Math.max(this.activeRecipe.getSpecialValue(), 1);
            }

            public void resetRecipe() {
                super.resetRecipe();
                BlockEntityLargeBoiler.this.euPerTick = 0;
                this.efficiencyIncrease = 0;
            }

            private int adjustEUtForConfig(int rawEUt) {
                int adjustedSteamOutput = rawEUt - 25 * this.integratedCircuitConfig;
                return Math.max(adjustedSteamOutput, 25);
            }

            private int adjustBurnTimeForConfig(int rawBurnTime) {
                if (BlockEntityLargeBoiler.this.efficiency < 10000) {
                    return rawBurnTime;
                }
                int adjustedEUt = Math.max(25, BlockEntityLargeBoiler.this.getEUt() - 25 * this.integratedCircuitConfig);
                int adjustedBurnTime = rawBurnTime * BlockEntityLargeBoiler.this.getEUt() / adjustedEUt;
                this.excessProjectedEU += BlockEntityLargeBoiler.this.getEUt() * rawBurnTime - adjustedEUt * adjustedBurnTime;
                this.excessProjectedEU %= adjustedEUt;
                return adjustedBurnTime += this.excessProjectedEU / adjustedEUt;
            }

            public void onMachineEvent(IMachineEvent event, Object ... data) {
                super.onMachineEvent(event, data);
                if (event == SlotType.STORAGE) {
                    this.checkRecipe();
                }
            }

            public CompoundTag serialize() {
                CompoundTag tag = super.serialize();
                tag.m_128405_("excessProjectedEu", this.excessProjectedEU);
                tag.m_128405_("excessFuel", this.excessFuel);
                tag.m_128405_("efficiency", BlockEntityLargeBoiler.this.efficiency);
                return tag;
            }

            public void deserialize(CompoundTag nbt) {
                super.deserialize(nbt);
                this.excessProjectedEU = nbt.m_128451_("excessProjectedEu");
                this.excessFuel = nbt.m_128451_("excessFuel");
                BlockEntityLargeBoiler.this.efficiency = nbt.m_128451_("efficiency");
            }
        });
    }

    public BlockBasic getCasing() {
        if (this.tier == Tier.LV) {
            return GT5RBlocks.BRONZE_PLATED_BRICK_CASING;
        }
        if (this.tier == Tier.MV) {
            return GT5RBlocks.SOLID_STEEL_CASING;
        }
        if (this.tier == Tier.HV) {
            return GT5RBlocks.TITANIUM_CASING;
        }
        return GT5RBlocks.TUNGSTENSTEEL_CASING;
    }

    public int getEUt() {
        if (this.tier == Tier.LV) {
            return 400;
        }
        if (this.tier == Tier.MV) {
            return 600;
        }
        if (this.tier == Tier.HV) {
            return 800;
        }
        return 1000;
    }

    public int getEfficiencyIncrease() {
        if (this.tier == Tier.LV) {
            return 16;
        }
        if (this.tier == Tier.MV) {
            return 12;
        }
        if (this.tier == Tier.HV) {
            return 8;
        }
        return 4;
    }

    int runtimeBoost(int time) {
        if (this.tier == Tier.LV) {
            return time * 2;
        }
        int dividend = this.tier == Tier.MV ? 150 : (this.tier == Tier.HV ? 130 : 120);
        return time * dividend / 100;
    }

    public Block getFireboxCasing() {
        if (this.tier == Tier.LV) {
            return GT5RBlocks.BRONZE_FIREBOX_CASING;
        }
        if (this.tier == Tier.MV) {
            return GT5RBlocks.STEEL_FIREBOX_CASING;
        }
        if (this.tier == Tier.HV) {
            return GT5RBlocks.TITANIUM_FIREBOX_CASING;
        }
        return GT5RBlocks.TUNGSTENSTEEL_FIREBOX_CASING;
    }

    public Block getPipeCasing() {
        if (this.tier == Tier.LV) {
            return GT5RBlocks.BRONZE_PIPE_CASING;
        }
        if (this.tier == Tier.MV) {
            return GT5RBlocks.STEEL_PIPE_CASING;
        }
        if (this.tier == Tier.HV) {
            return GT5RBlocks.TITANIUM_PIPE_CASING;
        }
        return GT5RBlocks.TUNGSTENSTEEL_PIPE_CASING;
    }

    public Texture getTextureForHatches(Direction dir, BlockPos hatchPos) {
        if (hatchPos.m_123342_() != this.m_58899_().m_123342_()) {
            return super.getTextureForHatches(dir, hatchPos);
        }
        String prefix = this.tier == Tier.LV ? "bronze" : (this.tier == Tier.MV ? "steel" : (this.tier == Tier.HV ? "titanium" : "tungstensteel"));
        return new Texture("gt5r", "block/casing/" + prefix + "_firebox");
    }

    public BlockBasic getHatchBlock(BlockPos hatchPos) {
        if (hatchPos.m_123342_() != this.m_58899_().m_123342_()) {
            return this.getCasing();
        }
        String prefix = this.tier == Tier.LV ? "bronze" : (this.tier == Tier.MV ? "steel" : (this.tier == Tier.HV ? "titanium" : "tungstensteel"));
        return (BlockBasic)GT5Reimagined.get(BlockCasing.class, prefix + "_firebox_casing");
    }

    public int drawInfo(InfoRenderWidget.MultiRenderWidget instance, PoseStack stack, Font renderer, int left, int top) {
        renderer.m_92883_(stack, this.m_5446_().getString(), (float)left, (float)top, 0xFAFAFF);
        if (!(instance instanceof LargeBoilerInforWidget)) {
            return 8;
        }
        LargeBoilerInforWidget w = (LargeBoilerInforWidget)instance;
        if (this.getMachineState() != MachineState.ACTIVE) {
            renderer.m_92883_(stack, "Inactive.", (float)left, (float)(top + 8), 0xFAFAFF);
            return 16;
        }
        if (instance.drawActiveInfo()) {
            int tGeneratedSteam = (int)(instance.euT * 2L * (long)w.efficiency / 10000L);
            renderer.m_92883_(stack, "Progress: " + instance.currentProgress + "/" + instance.maxProgress, (float)left, (float)(top + 8), 0xFAFAFF);
            renderer.m_92883_(stack, "Overclock: " + instance.overclock, (float)left, (float)(top + 16), 0xFAFAFF);
            renderer.m_92883_(stack, "Steam/t: " + tGeneratedSteam, (float)left, (float)(top + 24), 0xFAFAFF);
            return 32;
        }
        return 8;
    }

    public WidgetSupplier getInfoWidget() {
        return LargeBoilerInforWidget.build().setPos(10, 10);
    }

    private static class LargeBoilerInforWidget
    extends InfoRenderWidget.MultiRenderWidget {
        int efficiency;

        protected LargeBoilerInforWidget(GuiInstance gui, IGuiElement parent, IInfoRenderer<InfoRenderWidget.MultiRenderWidget> renderer) {
            super(gui, parent, renderer);
        }

        public void init() {
            super.init();
            BlockEntityMultiMachine m = (BlockEntityMultiMachine)this.gui.handler;
            this.gui.syncInt(() -> m.recipeHandler.map(MachineRecipeHandler::getCurrentProgress).orElse(0), i -> {
                this.currentProgress = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            this.gui.syncInt(() -> m.recipeHandler.map(MachineRecipeHandler::getMaxProgress).orElse(0), i -> {
                this.maxProgress = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            this.gui.syncInt(() -> m.recipeHandler.map(MachineRecipeHandler::getOverclock).orElse(0), i -> {
                this.overclock = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            if (m instanceof BlockEntityLargeBoiler) {
                BlockEntityLargeBoiler b = (BlockEntityLargeBoiler)m;
                this.gui.syncInt(() -> b.euPerTick, i -> {
                    this.euT = i.intValue();
                }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
                this.gui.syncInt(() -> b.efficiency, i -> {
                    this.efficiency = i;
                }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            }
        }

        public static WidgetSupplier build() {
            return LargeBoilerInforWidget.builder((a, b) -> new LargeBoilerInforWidget((GuiInstance)a, (IGuiElement)b, (IInfoRenderer<InfoRenderWidget.MultiRenderWidget>)((IInfoRenderer)a.handler)));
        }
    }
}

