/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.multi;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gt5r.block.BlockCoil;
import org.gtreimagined.gt5r.machine.caps.ParallelRecipeHandler;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityMultiMachine;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.ICanSyncData;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.widget.InfoRenderWidget;
import org.gtreimagined.gtlib.gui.widget.WidgetSupplier;
import org.gtreimagined.gtlib.integration.xei.renderer.IInfoRenderer;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.types.Machine;

public class BlockEntityLargeAutoclave
extends BlockEntityMultiMachine<BlockEntityLargeAutoclave> {
    private BlockCoil.CoilData coilData;

    public BlockEntityLargeAutoclave(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.recipeHandler.set(() -> new ParallelRecipeHandler<BlockEntityLargeAutoclave>(this, 16){

            protected void calculateDurations() {
                super.calculateDurations();
                float percentage = 1.0f + 0.1f * (float)BlockEntityLargeAutoclave.this.coilData.autoclaveBoosts();
                this.maxProgress = (int)((float)this.maxProgress / percentage);
            }
        });
    }

    public BlockCoil.CoilData getCoilData() {
        return this.coilData;
    }

    public void setCoilData(BlockCoil.CoilData coilData) {
        this.coilData = coilData;
    }

    public WidgetSupplier getInfoWidget() {
        return MultiSmelterInfoWidget.build().setPos(10, 10);
    }

    public int drawInfo(InfoRenderWidget.MultiRenderWidget instance, PoseStack stack, Font renderer, int left, int top) {
        int superDraw = super.drawInfo(instance, stack, renderer, left, top);
        if (this.getMachineState() == MachineState.ACTIVE && instance.drawActiveInfo()) {
            renderer.m_92883_(stack, "Concurrent Recipes: " + ((MultiSmelterInfoWidget)instance).concurrentRecipes, (float)left, (float)(top + 32), 0xFAFAFF);
            return superDraw + 8;
        }
        return superDraw;
    }

    public static class MultiSmelterInfoWidget
    extends InfoRenderWidget.MultiRenderWidget {
        int concurrentRecipes;

        protected MultiSmelterInfoWidget(GuiInstance gui, IGuiElement parent, IInfoRenderer<InfoRenderWidget.MultiRenderWidget> renderer) {
            super(gui, parent, renderer);
        }

        public void init() {
            super.init();
            BlockEntityLargeAutoclave m = (BlockEntityLargeAutoclave)this.gui.handler;
            this.gui.syncInt(() -> m.recipeHandler.map(r -> ((ParallelRecipeHandler)r).concurrentRecipes).orElse(0), i -> {
                this.concurrentRecipes = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        }

        public static WidgetSupplier build() {
            return MultiSmelterInfoWidget.builder((a, b) -> new MultiSmelterInfoWidget((GuiInstance)a, (IGuiElement)b, (IInfoRenderer<InfoRenderWidget.MultiRenderWidget>)((IInfoRenderer)a.handler)));
        }
    }
}

