/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.multi;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gt5r.blockentity.multi.IMiningPipeTile;
import org.gtreimagined.gt5r.blockentity.multi.MiningPipeStructureCache;
import org.gtreimagined.gt5r.data.GT5RBlocks;
import org.gtreimagined.gt5r.gui.ButtonOverlays;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityMultiMachine;
import org.gtreimagined.gtlib.capability.IFilterableHandler;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.gui.event.GuiEvents;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.util.Utils;
import org.gtreimagined.gtlib.util.int3;

public abstract class BlockEntityDrillingRigBase<T extends BlockEntityDrillingRigBase<T>>
extends BlockEntityMultiMachine<T>
implements IMiningPipeTile,
IFilterableHandler {
    protected boolean foundBottom = false;
    protected boolean stopped = false;
    protected boolean pullingUp;
    protected BlockPos miningPos;
    protected int euPerTick;
    protected int cycle = 160;
    protected int inactiveTicks = 0;

    public BlockEntityDrillingRigBase(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.miningPos = new int3(pos, this.getFacing(state)).back(1).m_7949_().m_7495_();
    }

    public void onFirstTickServer(Level level, BlockPos pos, BlockState state) {
        super.onFirstTickServer(level, pos, state);
        if (this.foundBottom) {
            LongArrayList positions = new LongArrayList();
            for (int y = this.miningPos.m_123342_(); y < this.m_58899_().m_123342_(); ++y) {
                positions.add(BlockPos.m_121882_((int)this.miningPos.m_123341_(), (int)y, (int)this.miningPos.m_123343_()));
            }
            MiningPipeStructureCache.add(this.f_58857_, this.m_58899_(), (LongList)positions);
        }
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (this.inactiveTicks > 2 && this.getMachineState() == MachineState.ACTIVE) {
            this.setMachineState(MachineState.IDLE);
        }
        boolean wasStopped = false;
        if (this.stopped && level.m_46467_() % 200L == 0L) {
            wasStopped = true;
            this.stopped = false;
        }
        if (!this.validStructure || this.stopped) {
            return;
        }
        ItemStack stack = this.itemHandler.map(i -> i.getHandler(SlotType.STORAGE).getStackInSlot(0)).orElse(ItemStack.f_41583_);
        if ((stack.m_41720_() == GT5RBlocks.MINING_PIPE_THIN.m_5456_() || this.foundBottom || this.pullingUp) && this.energyHandler.map(e -> e.getEnergy() >= (long)this.euPerTick).orElse(false).booleanValue()) {
            if (this.pullingUp) {
                if (level.m_46467_() % 5L != 0L) {
                    return;
                }
                BlockState block = level.m_8055_(this.miningPos.m_7494_());
                if (block.m_60734_() == GT5RBlocks.MINING_PIPE) {
                    boolean success = false;
                    if (this.itemHandler.map(i -> i.canOutputsFit(new ItemStack[]{new ItemStack((ItemLike)GT5RBlocks.MINING_PIPE_THIN)})).orElse(false).booleanValue()) {
                        this.itemHandler.ifPresent(i -> i.addOutputs(new ItemStack[]{new ItemStack((ItemLike)GT5RBlocks.MINING_PIPE_THIN)}));
                        success = true;
                    } else if (this.itemHandler.map(i -> i.getHandler(SlotType.STORAGE).getStackInSlot(0).m_41613_() + 1 < i.getHandler(SlotType.STORAGE).getSlotLimit(0)).orElse(false).booleanValue()) {
                        this.itemHandler.ifPresent(i -> i.getHandler(SlotType.STORAGE).insertItem(0, new ItemStack((ItemLike)GT5RBlocks.MINING_PIPE_THIN), false));
                        success = true;
                    }
                    if (success) {
                        if (this.foundBottom) {
                            this.foundBottom = false;
                            MiningPipeStructureCache.remove(level, this.m_58899_());
                        }
                        this.miningPos = this.miningPos.m_7494_();
                        level.m_7731_(this.miningPos, Blocks.f_50016_.m_49966_(), 3);
                        if (this.miningPos.m_123342_() + 1 < this.m_58899_().m_123342_()) {
                            level.m_7731_(this.miningPos.m_7494_(), GT5RBlocks.MINING_PIPE.m_49966_(), 3);
                        }
                        this.setActive();
                        this.energyHandler.ifPresent(e -> e.extractEu((long)this.euPerTick, false));
                    } else {
                        ++this.inactiveTicks;
                    }
                } else {
                    ++this.inactiveTicks;
                }
            } else if (!this.foundBottom) {
                if (level.m_46467_() % 20L != 0L) {
                    return;
                }
                MineResult breakResult = this.mineBelowBlock(level, this.miningPos, true, this.getMiningPickaxe());
                if (breakResult == MineResult.PIPE_BROKEN) {
                    return;
                }
                this.setActive();
                this.energyHandler.ifPresent(e -> e.extractEu((long)this.euPerTick, false));
                if (breakResult == MineResult.FOUND_BOTTOM || breakResult == MineResult.FOUND_BOTTOM_MINING_PIPE) {
                    this.foundBottom = true;
                    LongArrayList positions = new LongArrayList();
                    for (int y = this.miningPos.m_123342_(); y < this.m_58899_().m_123342_(); ++y) {
                        positions.add(BlockPos.m_121882_((int)this.miningPos.m_123341_(), (int)y, (int)this.miningPos.m_123343_()));
                    }
                    MiningPipeStructureCache.add(this.f_58857_, this.m_58899_(), (LongList)positions);
                }
                if (!wasStopped) {
                    this.miningPos = this.miningPos.m_7495_();
                }
                if (breakResult == MineResult.FOUND_OBSTRUCTION) {
                    this.stopped = true;
                    return;
                }
                if (breakResult == MineResult.FOUND_MINEABLE || breakResult == MineResult.FOUND_BOTTOM) {
                    stack.m_41774_(1);
                }
            } else {
                this.run(level, pos, state);
            }
        }
    }

    protected void setActive() {
        this.inactiveTicks = 0;
        if (this.getMachineState() == MachineState.IDLE) {
            this.setMachineState(MachineState.ACTIVE);
        }
    }

    protected abstract MineResult mineBelowBlock(Level var1, BlockPos var2, boolean var3, ItemStack var4);

    protected abstract void run(Level var1, BlockPos var2, BlockState var3);

    protected boolean mineBlock(Level level, BlockPos pos, boolean dropBlock, ItemStack item) {
        BlockEntity blockentity;
        BlockState state = level.m_8055_(pos);
        if (state.m_60795_()) {
            return true;
        }
        BlockEntity blockEntity = blockentity = state.m_155947_() ? level.m_7702_(pos) : null;
        if (dropBlock && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            List drops = Block.m_49874_((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)blockentity, null, (ItemStack)item);
            if (this.itemHandler.map(i -> i.canOutputsFit((ItemStack[])drops.toArray(ItemStack[]::new))).orElse(false).booleanValue()) {
                this.itemHandler.ifPresent(i -> i.addOutputs((ItemStack[])drops.toArray(ItemStack[]::new)));
            } else {
                drops.forEach(i -> Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)i));
            }
            state.m_60612_(serverLevel, pos, ItemStack.f_41583_);
        }
        return level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
    }

    protected ItemStack getMiningPickaxe() {
        return Items.f_42395_.m_7968_();
    }

    public void onRemove() {
        super.onRemove();
        MiningPipeStructureCache.remove(this.f_58857_, this.m_58899_());
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("foundBottom", this.foundBottom);
        tag.m_128379_("pullingUp", this.pullingUp);
        tag.m_128356_("miningPos", this.miningPos.m_121878_());
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.foundBottom = nbt.m_128471_("foundBottom");
        this.pullingUp = nbt.m_128471_("pullingUp");
        this.miningPos = BlockPos.m_122022_((long)nbt.m_128454_("miningPos"));
    }

    public void onGuiEvent(IGuiEvent event, Player playerEntity) {
        int[] data;
        if (event.getFactory() == GuiEvents.EXTRA_BUTTON && (data = ((GuiEvents.GuiEvent)event).data)[1] == 0) {
            this.pullingUp = !this.pullingUp;
            playerEntity.m_6352_((Component)Utils.literal((String)(this.pullingUp ? "Currently pulling up mining pipes" : "No longer pulling up mining pipes")), playerEntity.m_142081_());
        }
    }

    public void addWidgets(GuiInstance instance, IGuiElement parent) {
        super.addWidgets(instance, parent);
        instance.addSwitchButton(152, 23, 18, 18, ButtonOverlays.PULL_UP_OFF, ButtonOverlays.PULL_UP_ON, h -> ((BlockEntityDrillingRigBase)h).pullingUp, false);
    }

    public boolean test(SlotType<?> slotType, int slot, ItemStack stack) {
        return slotType != SlotType.STORAGE || stack.m_41720_() == GT5RBlocks.MINING_PIPE_THIN.m_5456_();
    }

    @Override
    public void onMiningPipeUpdate(BlockPos miningPipePos) {
        BlockState pipe = this.f_58857_.m_8055_(miningPipePos);
        if (pipe.m_60734_() != GT5RBlocks.MINING_PIPE && pipe.m_60734_() != GT5RBlocks.MINING_PIPE_THIN && !this.pullingUp) {
            this.resetMiningPos();
        }
    }

    protected void resetMiningPos() {
        BlockState state;
        this.foundBottom = false;
        BlockPos centerPos = this.miningPos.m_175288_(this.m_58899_().m_123342_()).m_7495_();
        while ((state = this.f_58857_.m_8055_(centerPos)).m_60734_() == GT5RBlocks.MINING_PIPE || state.m_60734_() == GT5RBlocks.MINING_PIPE_THIN) {
            centerPos = centerPos.m_7495_();
        }
        this.miningPos = centerPos;
        MiningPipeStructureCache.remove(this.f_58857_, this.m_58899_());
    }

    public static enum MineResult {
        FOUND_BOTTOM,
        FOUND_OBSTRUCTION,
        FOUND_MINING_PIPE,
        FOUND_BOTTOM_MINING_PIPE,
        FOUND_MINEABLE,
        PIPE_BROKEN;

    }
}

