/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.networking.minecraft;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.networking.ICarbonPacket;
import carbonconfiglib.networking.carbon.ConfigAnswerPacket;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.server.ServerLifecycleHooks;

public class RequestGameRulesPacket
implements ICarbonPacket {
    UUID requestId;

    public RequestGameRulesPacket() {
    }

    public RequestGameRulesPacket(UUID requestId) {
        this.requestId = requestId;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.requestId);
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        this.requestId = buffer.m_130259_();
    }

    @Override
    public void process(Player player) {
        if (!CarbonConfig.hasPermission(player, 4)) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130079_(server.m_129900_().m_46163_());
        byte[] data = new byte[buf.writerIndex()];
        buf.readBytes(data);
        CarbonConfig.NETWORK.sendToPlayer(new ConfigAnswerPacket(this.requestId, data), player);
    }
}

