/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.special;

import com.google.gson.JsonObject;
import com.mojang.util.UUIDTypeAdapter;
import dev.architectury.core.AbstractRecipeSerializer;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.recipe.KubeJSRecipeEventHandler;
import dev.latvian.mods.kubejs.recipe.ModifyRecipeCraftingGrid;
import dev.latvian.mods.kubejs.recipe.ModifyRecipeResultCallback;
import dev.latvian.mods.kubejs.recipe.RecipeEventJS;
import dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientAction;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class ShapelessKubeJSRecipe
extends ShapelessRecipe {
    private final List<IngredientAction> ingredientActions;
    private final ModifyRecipeResultCallback modifyResult;

    public ShapelessKubeJSRecipe(ShapelessRecipe original, List<IngredientAction> ingredientActions, @Nullable ModifyRecipeResultCallback modifyResult) {
        super(original.m_6423_(), original.m_6076_(), original.m_8043_(), original.m_7527_());
        this.ingredientActions = ingredientActions;
        this.modifyResult = modifyResult;
    }

    public RecipeSerializer<?> m_7707_() {
        return KubeJSRecipeEventHandler.SHAPELESS.get();
    }

    public ItemStack m_5874_(CraftingContainer container) {
        if (this.modifyResult != null) {
            return this.modifyResult.modify(new ModifyRecipeCraftingGrid(container), ItemStackJS.of(this.m_8043_().m_41777_())).getItemStack();
        }
        return this.m_8043_().m_41777_();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        NonNullList list = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, (Object)IngredientAction.getRemaining(container, i, this.ingredientActions));
        }
        return list;
    }

    public static class SerializerKJS
    extends AbstractRecipeSerializer<ShapelessKubeJSRecipe> {
        private static final RecipeSerializer<ShapelessRecipe> SHAPELESS = (RecipeSerializer)UtilsJS.cast(KubeJSRegistries.recipeSerializers().get(new ResourceLocation("crafting_shapeless")));

        public ShapelessKubeJSRecipe fromJson(ResourceLocation id, JsonObject json) {
            ShapelessRecipe shapelessRecipe = (ShapelessRecipe)SHAPELESS.m_6729_(id, json);
            List<IngredientAction> ingredientActions = IngredientAction.parseList(json.get("kubejs_actions"));
            ModifyRecipeResultCallback modifyResult = null;
            if (json.has("kubejs_modify_result")) {
                modifyResult = RecipeEventJS.modifyResultCallbackMap.get(UUIDTypeAdapter.fromString((String)json.get("kubejs_modify_result").getAsString()));
            }
            return new ShapelessKubeJSRecipe(shapelessRecipe, ingredientActions, modifyResult);
        }

        public ShapelessKubeJSRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            ShapelessRecipe shapelessRecipe = (ShapelessRecipe)SHAPELESS.m_8005_(id, buf);
            List<IngredientAction> ingredientActions = IngredientAction.readList(buf);
            return new ShapelessKubeJSRecipe(shapelessRecipe, ingredientActions, null);
        }

        public void toNetwork(FriendlyByteBuf buf, ShapelessKubeJSRecipe r) {
            SHAPELESS.m_6178_(buf, (Recipe)r);
            IngredientAction.writeList(buf, r.ingredientActions);
        }
    }
}

