/*
 * Decompiled with CFR 0.152.
 */
package org.labellum.mc.waterflasks.setup;

import java.util.function.Supplier;
import net.dries007.tfc.common.TFCItemGroup;
import net.dries007.tfc.common.recipes.DelegateRecipe;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.labellum.mc.waterflasks.ConfigFlasks;
import org.labellum.mc.waterflasks.item.FlaskItem;
import org.labellum.mc.waterflasks.setup.AddItemChanceModifier;
import org.labellum.mc.waterflasks.setup.HealFlaskRecipe;

public class Registration {
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"waterflasks");
    private static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"waterflasks");
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"waterflasks");
    private static final DeferredRegister<GlobalLootModifierSerializer<?>> MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.LOOT_MODIFIER_SERIALIZERS, (String)"waterflasks");
    public static final TagKey<Item> FLASKS = TagKey.m_203882_((ResourceKey)ForgeRegistries.Keys.ITEMS, (ResourceLocation)new ResourceLocation("waterflasks", "flasks"));
    public static final RegistryObject<AddItemChanceModifier.Serializer> ADD_ITEM = Registration.glmSerializer("add_item", AddItemChanceModifier.Serializer::new);
    public static final RegistryObject<Item> LEATHER_SIDE = Registration.register("leather_side", TFCItemGroup.MISC);
    public static final RegistryObject<Item> BLADDER = Registration.register("bladder", TFCItemGroup.MISC);
    public static final RegistryObject<Item> BROKEN_LEATHER_FLASK = Registration.register("broken_leather_flask", TFCItemGroup.MISC);
    public static final RegistryObject<Item> LEATHER_FLASK = Registration.register("leather_flask", () -> new FlaskItem(Registration.leatherProperties(), (Supplier<Integer>)ConfigFlasks.LEATHER_CAPACITY, 100, (Supplier<? extends Item>)BROKEN_LEATHER_FLASK));
    public static final RegistryObject<Item> UNFINISHED_FLASK = Registration.register("unfinished_iron_flask", TFCItemGroup.METAL);
    public static final RegistryObject<Item> BROKEN_IRON_FLASK = Registration.register("broken_iron_flask", TFCItemGroup.METAL);
    public static final RegistryObject<Item> IRON_FLASK = Registration.register("iron_flask", () -> new FlaskItem(Registration.ironProperties(), (Supplier<Integer>)ConfigFlasks.IRON_CAPACITY, 100, (Supplier<? extends Item>)BROKEN_IRON_FLASK));
    public static final RegistryObject<SoundEvent> FLASK_BREAK = SOUNDS.register("item.flaskbreak", () -> new SoundEvent(new ResourceLocation("waterflasks", "item.flaskbreak")));
    public static final RegistryObject<RecipeSerializer<?>> HEAL_FLASK_SERIALIZER = Registration.registerSerializer("heal_flask", () -> DelegateRecipe.Serializer.shaped(HealFlaskRecipe::new));

    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(bus);
        SOUNDS.register(bus);
        MODIFIER_SERIALIZERS.register(bus);
        RECIPE_SERIALIZERS.register(bus);
    }

    private static Item.Properties leatherProperties() {
        return new Item.Properties().m_41491_(TFCItemGroup.MISC).m_41503_((Integer)ConfigFlasks.DAMAGE_FACTOR.get() == 0 ? Integer.MAX_VALUE : (Integer)ConfigFlasks.LEATHER_CAPACITY.get() / (Integer)ConfigFlasks.DAMAGE_FACTOR.get());
    }

    private static Item.Properties ironProperties() {
        return new Item.Properties().m_41491_(TFCItemGroup.METAL).m_41503_((Integer)ConfigFlasks.DAMAGE_FACTOR.get() == 0 ? Integer.MAX_VALUE : (Integer)ConfigFlasks.IRON_CAPACITY.get() / (Integer)ConfigFlasks.DAMAGE_FACTOR.get());
    }

    private static RegistryObject<Item> register(String name, CreativeModeTab tab) {
        return ITEMS.register(name, () -> new Item(new Item.Properties().m_41491_(tab)));
    }

    private static <T extends Item> RegistryObject<T> register(String name, Supplier<T> supplier) {
        return ITEMS.register(name, supplier);
    }

    private static <T extends GlobalLootModifierSerializer<? extends IGlobalLootModifier>> RegistryObject<T> glmSerializer(String id, Supplier<T> modifier) {
        return MODIFIER_SERIALIZERS.register(id, modifier);
    }

    private static <S extends RecipeSerializer<?>> RegistryObject<S> registerSerializer(String name, Supplier<S> factory) {
        return RECIPE_SERIALIZERS.register(name, factory);
    }
}

