/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.thresholdSwitch;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.redstone.DirectedDirectionalBlock;
import com.simibubi.create.content.redstone.thresholdSwitch.ThresholdSwitchBlockEntity;
import com.simibubi.create.content.redstone.thresholdSwitch.ThresholdSwitchScreen;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.gui.ScreenOpener;
import java.util.Random;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.items.CapabilityItemHandler;

public class ThresholdSwitchBlock
extends DirectedDirectionalBlock
implements IBE<ThresholdSwitchBlockEntity> {
    public static final IntegerProperty LEVEL = IntegerProperty.m_61631_((String)"level", (int)0, (int)5);

    public ThresholdSwitchBlock(BlockBehaviour.Properties p_i48377_1_) {
        super(p_i48377_1_);
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.updateObservedInventory(state, (LevelReader)worldIn, pos);
    }

    private void updateObservedInventory(BlockState state, LevelReader world, BlockPos pos) {
        this.withBlockEntityDo((BlockGetter)world, pos, ThresholdSwitchBlockEntity::updateCurrentLevel);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return side != null && side.m_122424_() != ThresholdSwitchBlock.getTargetDirection(state);
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (side == ThresholdSwitchBlock.getTargetDirection(blockState).m_122424_()) {
            return 0;
        }
        return this.getBlockEntityOptional(blockAccess, pos).filter(ThresholdSwitchBlockEntity::isPowered).map($ -> 15).orElse(0);
    }

    public void m_7458_(BlockState blockState, ServerLevel world, BlockPos pos, Random random) {
        this.getBlockEntityOptional((BlockGetter)world, pos).ifPresent(ThresholdSwitchBlockEntity::updatePowerAfterDelay);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{LEVEL}));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player != null && AllItems.WRENCH.isIn(player.m_21120_(handIn))) {
            return InteractionResult.PASS;
        }
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> this.displayScreen((ThresholdSwitchBlockEntity)be, player)));
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void displayScreen(ThresholdSwitchBlockEntity be, Player player) {
        if (player instanceof LocalPlayer) {
            ScreenOpener.open(new ThresholdSwitchScreen(be));
        }
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        Capability itemCap = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        Capability fluidCap = CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
        Direction preferredFacing = null;
        for (Direction face : context.m_6232_()) {
            BlockEntity be = context.m_43725_().m_7702_(context.m_8083_().m_142300_(face));
            if (be == null || !be.getCapability(itemCap).isPresent() && !be.getCapability(fluidCap).isPresent()) continue;
            preferredFacing = face;
            break;
        }
        if (preferredFacing == null) {
            Direction facing = context.m_7820_();
            Direction direction = preferredFacing = context.m_43723_() != null && context.m_43723_().m_6144_() ? facing : facing.m_122424_();
        }
        if (preferredFacing.m_122434_() == Direction.Axis.Y) {
            state = (BlockState)state.m_61124_((Property)TARGET, (Comparable)(preferredFacing == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR));
            preferredFacing = context.m_8125_();
        }
        return (BlockState)state.m_61124_((Property)f_54117_, preferredFacing);
    }

    @Override
    public Class<ThresholdSwitchBlockEntity> getBlockEntityClass() {
        return ThresholdSwitchBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends ThresholdSwitchBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.THRESHOLD_SWITCH.get();
    }
}

