/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.config;

import com.eerussianguy.firmalife.common.items.FLFoodTraits;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraftforge.common.ForgeConfigSpec;

public class FLServerConfig {
    public final ForgeConfigSpec.IntValue cheeseAgedDays;
    public final ForgeConfigSpec.IntValue cheeseVintageDays;
    public final ForgeConfigSpec.IntValue dryingTicks;
    public final ForgeConfigSpec.IntValue solarDryingTicks;
    public final ForgeConfigSpec.IntValue smokingTicks;
    public final ForgeConfigSpec.IntValue smokingFirepitRange;
    public final ForgeConfigSpec.IntValue ironComposterTicks;
    public final ForgeConfigSpec.IntValue ovenCureTicks;
    public final ForgeConfigSpec.IntValue ovenCureTemperature;
    public final ForgeConfigSpec.DoubleValue ovenAshChance;
    public final ForgeConfigSpec.BooleanValue ovenRequirePeel;
    public final ForgeConfigSpec.BooleanValue enableSeedBalls;
    public final ForgeConfigSpec.BooleanValue enableBeeSwarm;
    public final ForgeConfigSpec.IntValue hollowShellCapacity;
    public final ForgeConfigSpec.DoubleValue cellarLevel2Temperature;
    public final ForgeConfigSpec.DoubleValue cellarLevel3Temperature;
    public final ForgeConfigSpec.DoubleValue greenhouseGrowthDays;
    public final ForgeConfigSpec.DoubleValue greenhouseWaterDays;
    public final ForgeConfigSpec.DoubleValue greenhouseNutrientDays;
    public final Map<FLFoodTraits.Default, ForgeConfigSpec.DoubleValue> foodTraits;

    FLServerConfig(ForgeConfigSpec.Builder innerBuilder) {
        Function<String, ForgeConfigSpec.Builder> builder = name -> innerBuilder.translation("firmalife.config.server." + name);
        innerBuilder.push("general");
        this.cheeseAgedDays = builder.apply("cheeseAgedDays").comment("Days in a cellar to make cheese Aged.").defineInRange("cheeseAgedDays", 28, 1, Integer.MAX_VALUE);
        this.cheeseVintageDays = builder.apply("cheeseVintageDays").comment("Days in a cellar to make cheese Vintage.").defineInRange("cheeseVintageDays", 112, 1, Integer.MAX_VALUE);
        this.dryingTicks = builder.apply("dryingTicks").comment("Ticks to dry something on a drying mat (24000 ticks = 1 day)").defineInRange("dryingTicks", 12000, 1, Integer.MAX_VALUE);
        this.solarDryingTicks = builder.apply("solarDryingTicks").comment("Ticks to dry something on a solar drier (24000 ticks = 1 day)").defineInRange("solarDryingTicks", 1000, 1, Integer.MAX_VALUE);
        this.smokingTicks = builder.apply("smokingTicks").comment("Ticks to smoke something on a string (24000 ticks = 1 day)").defineInRange("smokingTicks", 8000, 1, Integer.MAX_VALUE);
        this.smokingFirepitRange = builder.apply("smokingFirepitRange").comment("Number of blocks below the firepit that wool string will search for valid smoking firepits.").defineInRange("smokingFirepitRange", 6, 1, Integer.MAX_VALUE);
        this.ironComposterTicks = builder.apply("ironComposterTicks").comment("Ticks for an iron composter to finish (24000 ticks = 1 day)").defineInRange("ironComposterTicks", 96000, 1, Integer.MAX_VALUE);
        this.ovenCureTicks = builder.apply("ovenCureTicks").comment("Ticks for an oven to cure (24000 ticks = 1 day)").defineInRange("ovenCureTicks", 2000, 1, Integer.MAX_VALUE);
        this.ovenCureTemperature = builder.apply("ovenCureTemperature").comment("Minimum temperature for an oven to start the curing process (24000 ticks = 1 day)").defineInRange("ovenCureTemperature", 600, 1, Integer.MAX_VALUE);
        this.ovenRequirePeel = builder.apply("ovenRequirePeel").comment("If true, ovens will hurt the player if they touch it without a peel in hand.").define("ovenRequirePeel", true);
        this.ovenAshChance = builder.apply("ovenAshChance").comment("The chance for fuel burning in an oven to drop an ash block into an ashtray.").defineInRange("ovenAshChance", 0.5, 0.0, 1.0);
        this.enableSeedBalls = builder.apply("enableSeedBalls").comment("If true, players can throw seed balls.").define("enableSeedBalls", true);
        this.enableBeeSwarm = builder.apply("enableBeeSwarm").comment("If true, bees can swarm and hurt the player if provoked.").define("enableBeeSwarm", true);
        this.hollowShellCapacity = builder.apply("hollowShellCapacity").comment("The capacity in mB of the hollow shell. Default 100").defineInRange("hollowShellCapacity", 100, 1, Integer.MAX_VALUE);
        this.cellarLevel2Temperature = builder.apply("cellarLevel2Temperature").comment("The average temperature below which stronger decay modifiers apply to cellar blocks.").defineInRange("cellarLevel2Temperature", 0.0, -1.7976931348623157E308, Double.MAX_VALUE);
        this.cellarLevel3Temperature = builder.apply("cellarLevel3Temperature").comment("The average temperature below which even stronger decay modifiers apply to cellar blocks.").defineInRange("cellarLevel3Temperature", -12.0, -1.7976931348623157E308, Double.MAX_VALUE);
        this.greenhouseGrowthDays = builder.apply("greenhouseGrowthDays").comment("The average amount of days for a crop in a greenhouse to grow. For normal crops, this is 24 days.").defineInRange("greenhouseGrowthDays", 20.0, Double.MIN_VALUE, Double.MAX_VALUE);
        this.greenhouseWaterDays = builder.apply("greenhouseWaterDays").comment("The average amount of days for a crop in a greenhouse to consume all its water.").defineInRange("greenhouseWaterDays", 12.0, 0.0, Double.MAX_VALUE);
        this.greenhouseNutrientDays = builder.apply("greenhouseNutrientDays").comment("The average amount of days for a crop to consume all of a nutrient. You should probably not configure this value unless you know what it does in the code. For regular crops this value is 12.").defineInRange("greenhouseNutrientDays", 8.0, 0.0, Double.MAX_VALUE);
        innerBuilder.pop().push("foodTraits");
        this.foodTraits = new HashMap<FLFoodTraits.Default, ForgeConfigSpec.DoubleValue>();
        Arrays.stream(FLFoodTraits.Default.values()).forEach(trait -> this.foodTraits.put((FLFoodTraits.Default)((Object)trait), ((ForgeConfigSpec.Builder)builder.apply("trait" + trait.getCapitalizedName() + "Modifier")).comment("The modifier for the '" + trait.getCapitalizedName() + "' food trait. Values less than 1 extend food lifetime, values greater than one decrease it. A value of zero stops decay.").defineInRange("trait" + trait.getCapitalizedName() + "Modifier", (double)trait.getMod(), 0.0, Double.MAX_VALUE)));
        innerBuilder.pop();
    }
}

