/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.compat.tooltip;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.DryingMatBlockEntity;
import com.eerussianguy.firmalife.common.blockentities.FoodShelfBlockEntity;
import com.eerussianguy.firmalife.common.blockentities.JarbnetBlockEntity;
import com.eerussianguy.firmalife.common.blockentities.OvenLike;
import com.eerussianguy.firmalife.common.blockentities.OvenTopBlockEntity;
import com.eerussianguy.firmalife.common.blockentities.StringBlockEntity;
import com.eerussianguy.firmalife.common.blockentities.VatBlockEntity;
import com.eerussianguy.firmalife.common.blocks.AbstractOvenBlock;
import com.eerussianguy.firmalife.common.blocks.CheeseWheelBlock;
import com.eerussianguy.firmalife.common.blocks.DryingMatBlock;
import com.eerussianguy.firmalife.common.blocks.FoodShelfBlock;
import com.eerussianguy.firmalife.common.blocks.HangerBlock;
import com.eerussianguy.firmalife.common.blocks.ICure;
import com.eerussianguy.firmalife.common.blocks.JarbnetBlock;
import com.eerussianguy.firmalife.common.blocks.OvenBottomBlock;
import com.eerussianguy.firmalife.common.blocks.OvenTopBlock;
import com.eerussianguy.firmalife.common.blocks.SolarDrierBlock;
import com.eerussianguy.firmalife.common.blocks.StringBlock;
import com.eerussianguy.firmalife.common.blocks.VatBlock;
import com.eerussianguy.firmalife.common.blocks.plant.FLFruitTreeSaplingBlock;
import com.eerussianguy.firmalife.common.items.FLFoodTraits;
import com.eerussianguy.firmalife.config.FLConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.common.blocks.plant.fruit.FruitTreeSaplingBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.IFood;
import net.dries007.tfc.compat.jade.common.BlockEntityTooltip;
import net.dries007.tfc.compat.jade.common.BlockEntityTooltips;
import net.dries007.tfc.compat.jade.common.EntityTooltip;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;

public final class FLTooltips {
    private static MutableComponent delta(Level level, long ticks) {
        return Calendars.get((LevelReader)level).getTimeDelta(ticks);
    }

    public static final class Entities {
        public static void register(BiConsumer<EntityTooltip, Class<? extends Entity>> r) {
        }
    }

    public static final class BlockEntities {
        public static final BlockEntityTooltip VAT = (level, state, pos, entity, tooltip) -> {
            if (entity instanceof VatBlockEntity) {
                VatBlockEntity vat = (VatBlockEntity)entity;
                if (vat.isBoiling()) {
                    tooltip.accept(Helpers.translatable((String)"firmalife.jade.boiling"));
                }
                BlockEntityTooltips.heat((Consumer)tooltip, (float)vat.getTemperature());
            }
        };
        public static final BlockEntityTooltip DRYING_MAT = (level, state, pos, entity, tooltip) -> {
            Block patt2915$temp = state.m_60734_();
            if (patt2915$temp instanceof DryingMatBlock) {
                DryingMatBlockEntity mat;
                DryingMatBlock block = (DryingMatBlock)patt2915$temp;
                if (entity instanceof DryingMatBlockEntity && !(mat = (DryingMatBlockEntity)entity).viewStack().m_41619_() && mat.getCachedRecipe() != null && mat.getTicksLeft() > 0L) {
                    tooltip.accept(Helpers.translatable((String)"tfc.jade.time_left", (Object[])new Object[]{FLTooltips.delta(level, mat.getTicksLeft())}));
                }
            }
        };
        public static final BlockEntityTooltip STRING = (level, state, pos, entity, tooltip) -> {
            Block patt3422$temp = state.m_60734_();
            if (patt3422$temp instanceof StringBlock) {
                StringBlock block = (StringBlock)patt3422$temp;
                if (entity instanceof StringBlockEntity) {
                    StringBlockEntity mat = (StringBlockEntity)entity;
                    tooltip.accept(Helpers.translatable((String)("firmalife.jade." + (StringBlock.findFirepit(level, pos) != null ? "has_firepit" : "no_firepit"))));
                    ItemStack item = mat.viewStack();
                    if (!item.m_41619_()) {
                        List traits;
                        IFood food = item.getCapability(FoodCapability.CAPABILITY).resolve().orElse(null);
                        List list = traits = food == null ? null : food.getTraits();
                        if (mat.getCachedRecipe() != null) {
                            tooltip.accept(Helpers.translatable((String)"tfc.jade.time_left", (Object[])new Object[]{FLTooltips.delta(level, mat.getTicksLeft())}));
                        } else if (traits != null) {
                            ArrayList text = new ArrayList();
                            if (traits.contains(FLFoodTraits.SMOKED)) {
                                FLFoodTraits.SMOKED.addTooltipInfo(item, text);
                            }
                            if (traits.contains(FLFoodTraits.RANCID_SMOKED)) {
                                FLFoodTraits.RANCID_SMOKED.addTooltipInfo(item, text);
                            }
                            if (!text.isEmpty()) {
                                text.forEach(tooltip);
                            }
                        }
                    }
                }
            }
        };
        public static final BlockEntityTooltip CHEESE = (level, state, pos, entity, tooltip) -> {
            Block patt5076$temp = state.m_60734_();
            if (patt5076$temp instanceof CheeseWheelBlock) {
                CheeseWheelBlock block = (CheeseWheelBlock)patt5076$temp;
                if (((Boolean)state.m_61143_((Property)CheeseWheelBlock.AGING)).booleanValue()) {
                    tooltip.accept(Helpers.translatable((String)"firmalife.jade.aging"));
                } else {
                    tooltip.accept(Helpers.translatable((String)"firmalife.jade.not_aging"));
                }
                tooltip.accept(Helpers.translatable((String)"firmalife.jade.slices", (Object[])new Object[]{state.m_61143_((Property)CheeseWheelBlock.COUNT)}));
                tooltip.accept(Helpers.translatable((String)"firmalife.jade.food_age", (Object[])new Object[]{FLHelpers.translateEnum((Enum)((Object)state.m_61143_(CheeseWheelBlock.AGE)))}));
            }
        };
        public static final BlockEntityTooltip SHELF_OR_HANGER = (level, state, pos, entity, tooltip) -> {
            BlockEntity patt5884$temp = level.m_7702_(pos);
            if (patt5884$temp instanceof FoodShelfBlockEntity) {
                FoodShelfBlockEntity shelf = (FoodShelfBlockEntity)patt5884$temp;
                if (shelf.isClimateValid()) {
                    tooltip.accept(Helpers.translatable((String)"firmalife.cellar.valid_block"));
                } else {
                    tooltip.accept(Helpers.translatable((String)"firmalife.cellar.invalid_block"));
                }
                shelf.getCapability(Capabilities.ITEM).ifPresent(inv -> {
                    ItemStack stack = inv.getStackInSlot(0);
                    stack.getCapability(FoodCapability.CAPABILITY).ifPresent(food -> {
                        ArrayList foodTooltip = new ArrayList();
                        food.addTooltipInfo(stack, foodTooltip);
                        foodTooltip.forEach(tooltip);
                    });
                });
            }
        };
        public static final BlockEntityTooltip OVEN = (level, state, pos, entity, tooltip) -> {
            AbstractOvenBlock block;
            Block patt8429$temp;
            if (entity instanceof OvenLike) {
                ICure cure;
                Block patt7220$temp;
                OvenLike oven = (OvenLike)entity;
                BlockEntityTooltips.heat((Consumer)tooltip, (float)oven.getTemperature());
                if (oven.getTemperature() > 100.0f && oven instanceof OvenTopBlockEntity) {
                    tooltip.accept(Helpers.translatable((String)"firmalife.jade.needs_peel"));
                }
                if ((patt7220$temp = state.m_60734_()) instanceof ICure && !(cure = (ICure)patt7220$temp).isCured()) {
                    if (oven.getTemperature() < (float)((Integer)FLConfig.SERVER.ovenCureTemperature.get()).intValue()) {
                        tooltip.accept(Helpers.translatable((String)"firmalife.jade.cannot_cure"));
                    } else {
                        tooltip.accept(Helpers.translatable((String)"firmalife.jade.cure_time_left", (Object[])new Object[]{FLTooltips.delta(level, (Integer)FLConfig.SERVER.ovenCureTicks.get() - oven.getCureTicks())}));
                    }
                }
                if (entity instanceof OvenTopBlockEntity) {
                    OvenTopBlockEntity top = (OvenTopBlockEntity)entity;
                    entity.getCapability(Capabilities.ITEM).ifPresent(inv -> {
                        for (int i = 0; i < inv.getSlots(); ++i) {
                            int ticksLeft = top.getTicksLeft(i);
                            if (ticksLeft <= 0) continue;
                            tooltip.accept(Helpers.translatable((String)"firmalife.jade.cook_left", (Object[])new Object[]{FLTooltips.delta(level, ticksLeft)}));
                        }
                    });
                }
            }
            if ((patt8429$temp = state.m_60734_()) instanceof AbstractOvenBlock && !(block = (AbstractOvenBlock)patt8429$temp).isInsulated((LevelAccessor)level, pos, state)) {
                tooltip.accept(Helpers.translatable((String)"firmalife.jade.not_insulated"));
            }
            if (!((Boolean)state.m_61143_((Property)AbstractOvenBlock.HAS_CHIMNEY)).booleanValue()) {
                tooltip.accept(Helpers.translatable((String)"firmalife.jade.no_chimney"));
            }
        };
        public static final BlockEntityTooltip FRUIT_TREE_SAPLING = (level, state, pos, entity, tooltip) -> {
            if (entity instanceof TickCounterBlockEntity) {
                TickCounterBlockEntity counter = (TickCounterBlockEntity)entity;
                Block patt9002$temp = state.m_60734_();
                if (patt9002$temp instanceof FruitTreeSaplingBlock) {
                    FruitTreeSaplingBlock sapling = (FruitTreeSaplingBlock)patt9002$temp;
                    BlockEntityTooltips.timeLeft((Level)level, (Consumer)tooltip, (long)((long)((double)(sapling.getTreeGrowthDays() * 24000) * (Double)TFCConfig.SERVER.globalFruitSaplingGrowthModifier.get()) - counter.getTicksSinceUpdate()), (Component)Helpers.translatable((String)"tfc.jade.ready_to_grow"));
                }
            }
        };
        public static final BlockEntityTooltip JARBNET = (level, state, pos, entity, tooltip) -> {
            if (entity instanceof JarbnetBlockEntity) {
                JarbnetBlockEntity counter = (JarbnetBlockEntity)entity;
                if (((Boolean)state.m_61143_((Property)JarbnetBlock.LIT)).booleanValue()) {
                    BlockEntityTooltips.timeLeft((Level)level, (Consumer)tooltip, (long)((long)((Integer)TFCConfig.SERVER.candleTicks.get()).intValue() - counter.getTicksSinceUpdate()));
                }
            }
        };

        public static void register(BiConsumer<BlockEntityTooltip, Class<? extends Block>> r) {
            r.accept(DRYING_MAT, DryingMatBlock.class);
            r.accept(DRYING_MAT, SolarDrierBlock.class);
            r.accept(STRING, StringBlock.class);
            r.accept(CHEESE, CheeseWheelBlock.class);
            r.accept(OVEN, OvenBottomBlock.class);
            r.accept(OVEN, OvenTopBlock.class);
            r.accept(SHELF_OR_HANGER, FoodShelfBlock.class);
            r.accept(SHELF_OR_HANGER, HangerBlock.class);
            r.accept(VAT, VatBlock.class);
            r.accept(FRUIT_TREE_SAPLING, FLFruitTreeSaplingBlock.class);
            r.accept(JARBNET, JarbnetBlock.class);
        }
    }
}

