/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.FLTags;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blocks.MixingBowlBlock;
import com.eerussianguy.firmalife.common.recipes.FLRecipeTypes;
import com.eerussianguy.firmalife.common.recipes.MixingBowlRecipe;
import java.util.Random;
import java.util.function.Predicate;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.DelegateFluidHandler;
import net.dries007.tfc.common.capabilities.DelegateItemHandler;
import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.capabilities.SidedHandler;
import net.dries007.tfc.common.recipes.inventory.EmptyInventory;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MixingBowlBlockEntity
extends TickableInventoryBlockEntity<MixingBowlInventory> {
    public static final int SLOTS = 5;
    private static final int DEFAULT_COLOR = -4207;
    private final SidedHandler.Builder<IFluidHandler> sidedFluidInventory;
    private int rotationTimer = -1;

    public static void serverTick(Level level, BlockPos pos, BlockState state, MixingBowlBlockEntity bowl) {
        bowl.checkForLastTickSync();
        if (bowl.rotationTimer > 0) {
            ServerLevel serverLevel = (ServerLevel)level;
            int slotParticle = level.f_46441_.nextInt(5);
            ItemStack particleStack = ((MixingBowlInventory)bowl.inventory).getStackInSlot(slotParticle);
            if (!particleStack.m_41619_()) {
                MixingBowlBlockEntity.sendParticle(serverLevel, pos, particleStack, 1);
            }
            if (level.m_46467_() % 5L == 0L) {
                Helpers.playSound((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.f_12470_);
            }
            --bowl.rotationTimer;
            if (bowl.rotationTimer == 0) {
                bowl.finishMixing();
                Helpers.playSound((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.f_11682_);
            }
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, MixingBowlBlockEntity bowl) {
        if (bowl.rotationTimer > 0) {
            --bowl.rotationTimer;
        }
    }

    private static void sendParticle(ServerLevel level, BlockPos pos, ItemStack item, int count) {
        level.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, item), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.13, (double)pos.m_123343_() + 0.5, count, (double)Helpers.triangle((Random)level.f_46441_) / 2.0, level.f_46441_.nextDouble() / 4.0, (double)Helpers.triangle((Random)level.f_46441_) / 2.0, (double)0.15f);
    }

    public MixingBowlBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FLBlockEntities.MIXING_BOWL.get(), pos, state, MixingBowlInventory::new, FLHelpers.blockEntityName("mixing_bowl"));
        this.sidedInventory.on((Object)new PartialItemHandler(this.inventory).extract(new int[]{0, 1, 2, 3, 4}), (Predicate)Direction.Plane.HORIZONTAL).on((Object)new PartialItemHandler(this.inventory).insert(new int[]{0, 1, 2, 3, 4}), new Direction[]{Direction.UP});
        this.sidedFluidInventory = new SidedHandler.Builder((Object)((IFluidHandler)this.inventory)).on((Object)((IFluidHandler)this.inventory), (Predicate)Direction.Plane.HORIZONTAL);
    }

    public void loadAdditional(CompoundTag nbt) {
        super.loadAdditional(nbt);
        this.rotationTimer = nbt.m_128451_("rotationTimer");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("rotationTimer", this.rotationTimer);
    }

    public int getSlotStackLimit(int slot) {
        return 1;
    }

    public boolean isMixing() {
        return this.rotationTimer > 0;
    }

    public int getRotationTimer() {
        return this.rotationTimer;
    }

    public boolean startMixing(Player player) {
        assert (this.f_58857_ != null);
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if (state.m_60734_() instanceof MixingBowlBlock && !((Boolean)state.m_61143_((Property)MixingBowlBlock.SPOON)).booleanValue()) {
            return this.complain(player, "spoon");
        }
        if (this.isMixing()) {
            return this.complain(player, "mixing");
        }
        MixingBowlRecipe recipe = this.getRecipe();
        if (recipe == null) {
            return this.complain(player, "no_recipe");
        }
        if (!recipe.matches((MixingBowlInventory)this.inventory, this.f_58857_)) {
            return this.complain(player, "matching_recipe");
        }
        this.rotationTimer = 120;
        this.markForSync();
        return true;
    }

    private boolean complain(Player player, String name) {
        player.m_5661_((Component)Helpers.translatable((String)("firmalife.bowl." + name)), true);
        return false;
    }

    private void finishMixing() {
        assert (this.f_58857_ != null);
        MixingBowlRecipe recipe = this.getRecipe();
        if (recipe != null && recipe.matches((MixingBowlInventory)this.inventory, this.f_58857_)) {
            int i;
            ItemStack outputStack = recipe.m_5874_((Container)((MixingBowlInventory)this.inventory));
            int count = outputStack.m_41613_();
            for (i = 0; i < 5; ++i) {
                ((MixingBowlInventory)this.inventory).setStackInSlot(i, ItemStack.f_41583_);
            }
            for (i = 0; i < 5 && count > 0; --count, ++i) {
                ((MixingBowlInventory)this.inventory).setStackInSlot(i, Helpers.copyWithSize((ItemStack)outputStack, (int)1));
            }
            ((MixingBowlInventory)this.inventory).drain(1000, IFluidHandler.FluidAction.EXECUTE);
            ((MixingBowlInventory)this.inventory).fill(recipe.getResultFluid(), IFluidHandler.FluidAction.EXECUTE);
        }
        this.markForSync();
    }

    @Nullable
    public MixingBowlRecipe getRecipe() {
        assert (this.f_58857_ != null);
        return this.f_58857_.m_7465_().m_44015_((RecipeType)FLRecipeTypes.MIXING_BOWL.get(), (Container)((MixingBowlInventory)this.inventory), this.f_58857_).orElse(null);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == Capabilities.FLUID) {
            return this.sidedFluidInventory.getSidedHandler(side).cast();
        }
        return super.getCapability(cap, side);
    }

    public static class MixingBowlInventory
    implements EmptyInventory,
    DelegateItemHandler,
    DelegateFluidHandler,
    INBTSerializable<CompoundTag> {
        private final MixingBowlBlockEntity bowl;
        private final ItemStackHandler inventory;
        private final FluidTank tank;

        public MixingBowlInventory(InventoryBlockEntity<MixingBowlInventory> entity) {
            this.bowl = (MixingBowlBlockEntity)entity;
            this.inventory = new InventoryItemHandler(entity, 5);
            this.tank = new FluidTank(1000, fluid -> Helpers.isFluid((Fluid)fluid.getFluid(), FLTags.Fluids.USABLE_IN_MIXING_BOWL));
        }

        public FluidStack readFluid() {
            return this.tank.getFluidInTank(0);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.inventory.extractItem(slot, amount, simulate);
        }

        public IFluidHandler getFluidHandler() {
            return this.tank;
        }

        public IItemHandlerModifiable getItemHandler() {
            return this.inventory;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
            nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
            this.tank.readFromNBT(nbt.m_128469_("tank"));
        }
    }
}

