/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.plugin.crafttweaker;

import com.blamejared.crafttweaker.api.plugin.IRecipeHandlerRegistrationHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.api.util.InstantiationUtil;
import com.blamejared.crafttweaker.platform.Services;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.world.item.crafting.Recipe;

final class RecipeHandlerGatherer {
    RecipeHandlerGatherer() {
    }

    void gatherAndRegisterHandlers(IRecipeHandlerRegistrationHandler handler) {
        Stream.concat(this.findWithAnnotation(IRecipeHandler.For.class), this.findWithAnnotation(IRecipeHandler.For.Container.class)).distinct().forEach(it -> this.tryRegister((Class<?>)it, handler));
    }

    private Stream<? extends Class<?>> findWithAnnotation(Class<? extends Annotation> annotation) {
        return Services.PLATFORM.findClassesWithAnnotation(annotation);
    }

    private void tryRegister(Class<?> clazz, IRecipeHandlerRegistrationHandler handler) {
        if (!IRecipeHandler.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " does not implement IRecipeHandler");
        }
        if (clazz.isInterface()) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is an interface and cannot be annotated with @IRecipeHandler.For");
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is an abstract class and cannot be annotated with @IRecipeHandler.For");
        }
        Arrays.stream((IRecipeHandler.For[])clazz.getAnnotationsByType(IRecipeHandler.For.class)).map(IRecipeHandler.For::value).map(it -> it).filter(it -> it != Recipe.class).forEach(it -> handler.registerRecipeHandler((Class)GenericUtil.uncheck(it), (IRecipeHandler)InstantiationUtil.getOrCreateInstance(clazz)));
    }
}

