/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.integration.jei.category;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityBasicMultiMachine;
import org.gtreimagined.gtlib.client.RenderHelper;
import org.gtreimagined.gtlib.client.event.ClientEvents;
import org.gtreimagined.gtlib.client.scene.ImmediateWorldSceneRenderer;
import org.gtreimagined.gtlib.client.scene.TrackedDummyWorld;
import org.gtreimagined.gtlib.client.scene.WorldSceneRenderer;
import org.gtreimagined.gtlib.machine.types.BasicMultiMachine;
import org.gtreimagined.gtlib.structure.BlockInfo;
import org.gtreimagined.gtlib.structure.Pattern;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;

public class MultiMachineInfoPage {
    private final BasicMultiMachine<?> machine;
    private int layerIndex = -1;
    private int currentRendererPage = 0;
    private int lastMouseX;
    private int lastMouseY;
    private Vector3f center;
    private float rotationYaw;
    private float rotationPitch;
    private float zoom;
    private static final int WIDTH = 176;
    private static final int HEIGHT = 150;
    private static final int ICON_SIZE = 20;
    private static final int RIGHT_PADDING = 5;
    private final Button buttonPreviousPattern;
    private final Button buttonNextPattern;
    private final Button buttonNextLayer;
    private final WorldSceneRenderer[] renderers;
    private final Component[] descriptions;
    private final BlockEntityBasicMultiMachine<?>[] controllers;
    private static MultiMachineInfoPage LAST_PAGE;

    public MultiMachineInfoPage(BasicMultiMachine<?> machine, List<Pattern> patterns) {
        this.machine = machine;
        this.renderers = new WorldSceneRenderer[patterns.size()];
        this.controllers = new BlockEntityBasicMultiMachine[patterns.size()];
        this.descriptions = new Component[patterns.size()];
        this.buttonNextLayer = new Button(151, 65, 20, 20, (Component)Utils.literal("A"), b -> this.toggleNextLayer());
        this.buttonPreviousPattern = new Button(130, 90, 20, 20, (Component)Utils.literal("<"), b -> this.switchRenderPage(-1));
        this.buttonNextPattern = new Button(151, 90, 20, 20, (Component)Utils.literal(">"), b -> this.switchRenderPage(1));
        for (int i = 0; i < patterns.size(); ++i) {
            this.descriptions[i] = patterns.get(i).getDescription();
            HashMap<BlockPos, BlockInfo> blockMap = new HashMap<BlockPos, BlockInfo>();
            BlockInfo[][][] blocks = patterns.get(i).getBlockInfos();
            BlockEntityBasicMultiMachine controllers = null;
            for (int z = 0; z < blocks.length; ++z) {
                BlockInfo[][] aisle = blocks[z];
                for (int y = 0; y < aisle.length; ++y) {
                    BlockInfo[] column = aisle[y];
                    for (int x = 0; x < column.length; ++x) {
                        BlockPos blockPos = new BlockPos(y, z, x);
                        BlockInfo blockInfo = column[x];
                        blockMap.put(blockPos, blockInfo);
                        if (!(blockInfo.getTileEntity() instanceof BlockEntityBasicMultiMachine)) continue;
                        this.controllers[i] = controllers = (BlockEntityBasicMultiMachine)blockInfo.getTileEntity();
                    }
                }
            }
            TrackedDummyWorld world = new TrackedDummyWorld();
            ImmediateWorldSceneRenderer worldSceneRenderer = new ImmediateWorldSceneRenderer((BlockAndTintGetter)world);
            worldSceneRenderer.setClearColor(0xC6C6C6);
            world.addBlocks(blockMap);
            if (controllers == null || !controllers.checkStructure()) {
                this.descriptions[i] = Utils.translatable("InValid Structure", new Object[0]);
            }
            Vector3f size = world.getSize();
            Vector3f minPos = world.getMinPos();
            this.center = new Vector3f(minPos.m_122239_() + size.m_122239_() / 2.0f, minPos.m_122260_() + size.m_122260_() / 2.0f, minPos.m_122269_() + size.m_122269_() / 2.0f);
            worldSceneRenderer.addRenderedBlocks(world.getRenderedBlocks().keySet(), null);
            worldSceneRenderer.setOnLookingAt(this::renderBlockOverLay);
            world.setRenderFilter(pos -> worldSceneRenderer.renderedBlocksMap.keySet().stream().anyMatch(c -> c.contains(pos)));
            this.renderers[i] = worldSceneRenderer;
        }
    }

    public void setRecipeLayout(IRecipeLayout layout, IGuiHelper guiHelper) {
        if (ClientEvents.lastDelta == 0.0 || LAST_PAGE != this) {
            LAST_PAGE = this;
            this.zoom = 8.0f;
            this.rotationYaw = 20.0f;
            this.rotationPitch = 135.0f;
            this.currentRendererPage = 0;
            this.setNextLayer(-1);
        } else {
            this.zoom = (float)Mth.m_14008_((double)((double)this.zoom + (ClientEvents.lastDelta < 0.0 ? 0.5 : -0.5)), (double)3.0, (double)999.0);
            this.setNextLayer(this.getLayerIndex());
        }
        if (this.getCurrentRenderer() != null) {
            TrackedDummyWorld world = (TrackedDummyWorld)this.getCurrentRenderer().world;
            this.resetCenter(world);
        }
    }

    public int getLayerIndex() {
        return this.layerIndex;
    }

    private void toggleNextLayer() {
        WorldSceneRenderer renderer = this.getCurrentRenderer();
        int height = (int)((TrackedDummyWorld)renderer.world).getSize().m_122260_() - 1;
        if (++this.layerIndex > height) {
            this.layerIndex = -1;
        }
        this.setNextLayer(this.layerIndex);
    }

    private void switchRenderPage(int i) {
        int maxIndex = this.renderers.length - 1;
        int newIndex = Math.max(0, Math.min(this.currentRendererPage + i, maxIndex));
        if (this.currentRendererPage != newIndex) {
            this.currentRendererPage = newIndex;
            this.buttonNextPattern.f_93623_ = newIndex < maxIndex;
            this.buttonPreviousPattern.f_93623_ = newIndex > 0;
            this.setNextLayer(-1);
            this.getCurrentRenderer().setCameraLookAt(this.center, this.zoom, Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
        }
    }

    private void setNextLayer(int newLayer) {
        this.layerIndex = newLayer;
        this.buttonNextLayer.m_93666_((Component)Utils.literal(this.layerIndex == -1 ? "A" : Integer.toString(this.layerIndex + 1)));
        WorldSceneRenderer renderer = this.getCurrentRenderer();
        if (renderer != null) {
            TrackedDummyWorld world = (TrackedDummyWorld)renderer.world;
            this.resetCenter(world);
            renderer.renderedBlocksMap.clear();
            int minY = (int)world.getMinPos().m_122260_();
            Collection<Object> renderBlocks = newLayer == -1 ? world.getRenderedBlocks().keySet() : (Collection)world.getRenderedBlocks().keySet().stream().filter(pos -> pos.m_123342_() - minY == newLayer).collect(Collectors.toSet());
            renderer.addRenderedBlocks(renderBlocks, null);
        }
    }

    public WorldSceneRenderer getCurrentRenderer() {
        return this.renderers[this.currentRendererPage];
    }

    private void resetCenter(TrackedDummyWorld world) {
        Vector3f size = world.getSize();
        Vector3f minPos = world.getMinPos();
        this.center = new Vector3f(minPos.m_122239_() + size.m_122239_() / 2.0f, minPos.m_122260_() + size.m_122260_() / 2.0f, minPos.m_122269_() + size.m_122269_() / 2.0f);
        this.getCurrentRenderer().setCameraLookAt(this.center, this.zoom, Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
    }

    public void drawInfo(@NotNull PoseStack matrixStack, int mouseX, int mouseY) {
        boolean insideView;
        WorldSceneRenderer renderer = this.getCurrentRenderer();
        Vector4f transform = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        transform.m_123607_(matrixStack.m_85850_().m_85861_());
        renderer.render(transform.m_123601_(), transform.m_123615_(), 176.0f, 150.0f, mouseX + (int)transform.m_123601_(), mouseY + (int)transform.m_123615_());
        this.buttonNextPattern.m_6305_(matrixStack, mouseX, mouseY, 0.0f);
        this.buttonPreviousPattern.m_6305_(matrixStack, mouseX, mouseY, 0.0f);
        this.buttonNextLayer.m_6305_(matrixStack, mouseX, mouseY, 0.0f);
        AbstractWidget.m_93215_((PoseStack)matrixStack, (Font)Minecraft.m_91087_().f_91062_, (Component)this.descriptions[this.currentRendererPage], (int)88, (int)15, (int)-1);
        boolean bl = insideView = mouseX >= 0 && mouseY >= 0 && mouseX < 176 && mouseY < 150;
        if (insideView) {
            int mouseDeltaY;
            if (ClientEvents.leftDown) {
                this.rotationPitch += (float)(mouseX - this.lastMouseX + 360);
                this.rotationPitch %= 360.0f;
                this.rotationYaw = (float)Mth.m_14008_((double)(this.rotationYaw + (float)(mouseY - this.lastMouseY)), (double)-89.9, (double)89.9);
            } else if (ClientEvents.rightDown && Math.abs(mouseDeltaY = mouseY - this.lastMouseY) > 1) {
                this.zoom = (float)Mth.m_14008_((double)((double)this.zoom + (mouseDeltaY > 0 ? 0.5 : -0.5)), (double)3.0, (double)999.0);
            }
            renderer.setCameraLookAt(this.center, this.zoom, Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
        }
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    private void renderBlockOverLay(BlockHitResult rayTraceResult) {
        BlockPos pos = rayTraceResult.m_82425_();
        this.doOverlay(pos, 1.0f, 1.0f, 1.0f, 0.7f);
    }

    private void doOverlay(BlockPos pos, float r, float g, float b, float alpha) {
        RenderSystem.m_69478_();
        RenderSystem.m_69405_((int)770, (int)1);
        Tesselator tessellator = Tesselator.m_85913_();
        RenderSystem.m_69472_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderHelper.renderCubeFace((VertexConsumer)buffer, -0.5, -0.5, -0.5, 0.5, 0.5, 0.5, r, g, b, alpha);
        tessellator.m_85914_();
        RenderSystem.m_69493_();
        RenderSystem.m_69405_((int)770, (int)771);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean handleClick(double mouseX, double mouseY, int mouseButton) {
        return this.buttonPreviousPattern.m_6375_(mouseX, mouseY, mouseButton) || this.buttonNextPattern.m_6375_(mouseX, mouseY, mouseButton) || this.buttonNextLayer.m_6375_(mouseX, mouseY, mouseButton);
    }

    public void setIngredients(IIngredients ingredients) {
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.machine.getItem(this.machine.getFirstTier()).m_7968_());
    }

    public List<Component> getTooltipStrings(double mouseX, double mouseY) {
        WorldSceneRenderer renderer;
        BlockHitResult rayTraceResult;
        if (!(this.getCurrentRenderer() == null || ClientEvents.leftDown || ClientEvents.rightDown || ClientEvents.middleDown || (rayTraceResult = (renderer = this.getCurrentRenderer()).getLastTraceResult()) == null)) {
            Minecraft minecraft = Minecraft.m_91087_();
            BlockState blockState = renderer.world.m_8055_(rayTraceResult.m_82425_());
            ItemStack itemStack = blockState.m_60734_().m_7397_((BlockGetter)renderer.world, rayTraceResult.m_82425_(), blockState);
            if (itemStack != null && !itemStack.m_41619_()) {
                TooltipFlag.Default flag = minecraft.f_91066_.f_92125_ ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
                List list = itemStack.m_41651_((Player)minecraft.f_91074_, (TooltipFlag)flag);
                return list;
            }
        }
        return Collections.emptyList();
    }
}

