/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.gui.widget;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.Widget;

public class WidgetSupplier {
    private final BiFunction<GuiInstance, IGuiElement, Widget> builder;
    private boolean clientOnly = false;
    private Consumer<Widget> root = a -> {};
    private Predicate<GuiInstance> validator = a -> true;

    public WidgetSupplier(BiFunction<GuiInstance, IGuiElement, Widget> source) {
        this.builder = source;
    }

    public static WidgetSupplier build(BiFunction<GuiInstance, IGuiElement, Widget> b) {
        return new WidgetSupplier(b);
    }

    public WidgetSupplier setPos(int x, int y) {
        this.root = this.root.andThen(a -> {
            a.setX(x);
            a.setY(y);
        });
        return this;
    }

    public WidgetSupplier clientSide() {
        this.clientOnly = true;
        return this;
    }

    public WidgetSupplier onlyIf(Predicate<GuiInstance> predicate) {
        this.validator = this.validator.and(predicate);
        return this;
    }

    public WidgetSupplier setSize(int x, int y, int width, int height) {
        return this.setPos(x, y).setWH(width, height);
    }

    public WidgetSupplier setWH(int w, int h) {
        this.root = this.root.andThen(a -> {
            a.setW(w);
            a.setH(h);
        });
        return this;
    }

    public boolean shouldAdd(GuiInstance instance) {
        if (!this.validator.test(instance)) {
            return false;
        }
        if (instance.isRemote) {
            return true;
        }
        return !this.clientOnly;
    }

    public Widget buildAndAdd(GuiInstance instance, IGuiElement parent) {
        Widget wid = this.build().apply(instance, parent);
        instance.addWidget(wid);
        return wid;
    }

    public Widget build(GuiInstance instance, IGuiElement parent) {
        return this.build().apply(instance, parent);
    }

    private BiFunction<GuiInstance, IGuiElement, Widget> build() {
        return (a, b) -> {
            Widget w = this.builder.apply((GuiInstance)a, (IGuiElement)b);
            this.root.accept(w);
            return w;
        };
    }
}

