/*
 * Decompiled with CFR 0.152.
 */
package rikka.lanserverproperties;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.TooltipAccessor;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.ShareToLanScreen;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import rikka.lanserverproperties.IPUtils;
import rikka.lanserverproperties.IShareToLanScreenParamAccessor;
import rikka.lanserverproperties.IntegerEditBox;
import rikka.lanserverproperties.OnlineMode;
import rikka.lanserverproperties.Preferences;
import rikka.lanserverproperties.UUIDFixer;

public class OpenToLanScreenEx {
    private static final TranslatableComponent preferenceEnabledLabel = new TranslatableComponent("lanserverproperties.options.preference_enabled");
    private static final TranslatableComponent preferenceEnabledTooltip = new TranslatableComponent("lanserverproperties.options.preference_enabled.message");
    private static final TranslatableComponent preferenceLoadLabel = new TranslatableComponent("lanserverproperties.button.preference_load");
    private static final TranslatableComponent preferenceSaveLabel = new TranslatableComponent("lanserverproperties.button.preference_save");
    private static final TranslatableComponent pvpAllowedLabel = new TranslatableComponent("lanserverproperties.gui.pvp_allowed");
    private static final TranslatableComponent portDescLabel = new TranslatableComponent("lanserverproperties.gui.port");
    private static final TranslatableComponent portListeningLabel = new TranslatableComponent("lanserverproperties.gui.port_listening");
    private static final TranslatableComponent maxPlayerDescLabel = new TranslatableComponent("lanserverproperties.gui.max_player");
    private static final Function<String, Boolean> portValidator = IntegerEditBox.makeValidator(0, 65535);
    private static final Function<String, Boolean> maxPlayerValidator = IntegerEditBox.makeValidator(0, 16);
    private final ShareToLanScreen screen;
    private final IShareToLanScreenParamAccessor stlParamAccessor;
    private Supplier<Boolean> validateFields = null;
    private Consumer<Boolean> enableOkButton = null;
    private Preferences preferences;
    private boolean pvpAllowed;
    private OnlineMode onlineMode;
    private int port;
    private int maxPlayer;

    public OpenToLanScreenEx(ShareToLanScreen screen, IShareToLanScreenParamAccessor stlParamAccessor) {
        this.screen = screen;
        this.stlParamAccessor = stlParamAccessor;
        IntegratedServer server = Minecraft.m_91087_().m_91092_();
        if (server.m_6992_()) {
            this.preferences = Preferences.read();
            stlParamAccessor.setDefault(server.m_142359_(), server.m_6846_().m_11316_());
            this.onlineMode = OnlineMode.of(server.m_129797_(), UUIDFixer.try_online_first);
            this.pvpAllowed = server.m_129799_();
            this.port = server.m_7010_();
            this.maxPlayer = server.m_7418_();
        } else {
            this.readFromPreference(false);
        }
    }

    private void readFromPreference(boolean forceLoad) {
        this.preferences = Preferences.read();
        if (!forceLoad && !this.preferences.enablePreference) {
            this.preferences = new Preferences();
        }
        this.stlParamAccessor.setDefault(this.preferences.gameMode, this.preferences.allowCheat);
        this.onlineMode = OnlineMode.of(this.preferences.onlineMode, this.preferences.fixUUID);
        this.pvpAllowed = this.preferences.allowPVP;
        this.port = this.preferences.defaultPort;
        this.maxPlayer = this.preferences.maxPlayer;
    }

    private void copyToPreference() {
        this.preferences.gameMode = this.stlParamAccessor.getGameType();
        this.preferences.allowCheat = this.stlParamAccessor.isCommandEnabled();
        this.preferences.onlineMode = this.onlineMode.onlineModeEnabled;
        this.preferences.fixUUID = this.onlineMode.tryOnlineUUIDFirst;
        this.preferences.allowPVP = this.pvpAllowed;
        this.preferences.defaultPort = this.port;
        this.preferences.maxPlayer = this.maxPlayer;
    }

    private void applyServerConfig(IntegratedServer server, boolean setVanillaOptions) {
        if (setVanillaOptions) {
            server.m_7835_(this.stlParamAccessor.getGameType());
            server.m_6846_().m_11284_(this.stlParamAccessor.isCommandEnabled());
        }
        server.m_129985_(this.onlineMode.onlineModeEnabled);
        server.m_129997_(this.pvpAllowed);
        UUIDFixer.try_online_first = this.onlineMode.tryOnlineUUIDFirst;
        this.stlParamAccessor.setMaxPlayer(this.maxPlayer);
    }

    private static Button findButton(List<? extends GuiEventListener> list, String vanillaLangKey) {
        for (GuiEventListener guiEventListener : list) {
            Button button;
            Component component;
            if (!(guiEventListener instanceof Button) || !((component = (button = (Button)guiEventListener).m_6035_()) instanceof TranslatableComponent) || !((TranslatableComponent)component).m_131328_().equals(vanillaLangKey)) continue;
            return button;
        }
        return null;
    }

    public void postInitShareToLanScreen(Font textRenderer, List<? extends GuiEventListener> list, Consumer<GuiEventListener> widgetAdder, Consumer<GuiEventListener> widgetRemover) {
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.m_91091_()) {
            return;
        }
        IntegratedServer server = mc.m_91092_();
        Button openToLanButton = OpenToLanScreenEx.findButton(list, "lanServer.start");
        if (server.m_6992_()) {
            if (openToLanButton != null) {
                widgetRemover.accept((GuiEventListener)openToLanButton);
            }
            Button doneButton = new Button(this.screen.f_96543_ / 2 - 155, this.screen.f_96544_ - 28, 150, 20, CommonComponents.f_130655_, btn -> {
                this.applyServerConfig(server, true);
                Minecraft.m_91087_().m_91152_(this.stlParamAccessor.getLastScreen());
            });
            widgetAdder.accept((GuiEventListener)doneButton);
            this.enableOkButton = enabled -> {
                doneButton.f_93623_ = enabled;
            };
        } else {
            this.enableOkButton = enabled -> {
                openToLanButton.f_93623_ = enabled;
            };
        }
        widgetAdder.accept((GuiEventListener)new ImageButton(this.screen.f_96543_ / 2 - 180, 16, 20, 20, 0, 0, 20, new ResourceLocation("textures/gui/accessibility.png"), 32, 64, btn -> {
            this.readFromPreference(true);
            this.screen.m_6575_(mc, this.screen.f_96543_, this.screen.f_96544_);
        }, (btn, poseStack, x, y) -> this.screen.m_96617_(poseStack, textRenderer.m_92923_((FormattedText)preferenceLoadLabel, 200), x, y), (Component)preferenceLoadLabel));
        Button preferenceButton = new Button(this.screen.f_96543_ / 2 - 155, 16, 150, 20, (Component)preferenceSaveLabel, btn -> {
            this.copyToPreference();
            this.preferences.save();
        });
        widgetAdder.accept((GuiEventListener)preferenceButton);
        widgetAdder.accept((GuiEventListener)CycleButton.m_168916_((boolean)this.preferences.enablePreference).m_168943_(curState -> textRenderer.m_92923_((FormattedText)preferenceEnabledTooltip, 200)).m_168936_(this.screen.f_96543_ / 2 + 5, 16, 150, 20, (Component)preferenceEnabledLabel, (dummyButton, newVal) -> {
            this.preferences.enablePreference = newVal;
        }));
        widgetAdder.accept((GuiEventListener)new CycleButton.Builder(state -> state.stateName).m_168961_((Object[])OnlineMode.values()).m_168948_((Object)this.onlineMode).m_168943_(curState -> textRenderer.m_92923_((FormattedText)curState.tooltip, 200)).m_168929_().m_168936_(this.screen.f_96543_ / 2 - 155, 124, 150, 20, (Component)OnlineMode.translation, (dummyButton, newVal) -> {
            this.onlineMode = newVal;
        }));
        widgetAdder.accept((GuiEventListener)CycleButton.m_168916_((boolean)this.pvpAllowed).m_168936_(this.screen.f_96543_ / 2 + 5, 124, 150, 20, (Component)pvpAllowedLabel, (dummyButton, newVal) -> {
            this.pvpAllowed = newVal;
        }));
        IntegerEditBox portEditBox = new IntegerEditBox(textRenderer, this.screen.f_96543_ / 2 - 154, this.screen.f_96544_ - 54, 147, 20, (Component)portDescLabel, this.port, ieb -> {
            boolean enableButtons;
            preferenceButton.f_93623_ = enableButtons = this.validateFields.get().booleanValue();
            this.enableOkButton.accept(enableButtons);
            if (ieb.isContentValid()) {
                this.port = ieb.getValueAsInt();
            }
        }, portValidator, ieb -> server.m_6992_() ? textRenderer.m_92923_((FormattedText)new TextComponent(IPUtils.getIPs()), 250) : null);
        widgetAdder.accept((GuiEventListener)portEditBox);
        if (server.m_6992_()) {
            portEditBox.m_94186_(false);
        }
        IntegerEditBox portMaxPlayer = new IntegerEditBox(textRenderer, this.screen.f_96543_ / 2 + 5, this.screen.f_96544_ - 54, 147, 20, (Component)maxPlayerDescLabel, this.maxPlayer, ieb -> {
            boolean enableButtons;
            preferenceButton.f_93623_ = enableButtons = this.validateFields.get().booleanValue();
            this.enableOkButton.accept(enableButtons);
            if (ieb.isContentValid()) {
                this.maxPlayer = ieb.getValueAsInt();
            }
        }, maxPlayerValidator, null);
        widgetAdder.accept((GuiEventListener)portMaxPlayer);
        this.validateFields = () -> portEditBox.isContentValid() && portMaxPlayer.isContentValid();
    }

    public static void initPauseScreen(Screen gui, List<? extends GuiEventListener> list) {
        Button shareToLanButton = OpenToLanScreenEx.findButton(list, "menu.shareToLan");
        if (shareToLanButton != null) {
            shareToLanButton.f_93623_ = Minecraft.m_91087_().m_91091_();
        }
    }

    public static void postDraw(Screen gui, Font textRenderer, PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Optional mouserOverControl;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91091_()) {
            IntegratedServer server = mc.m_91092_();
            if (server.m_6992_()) {
                Screen.m_93243_((PoseStack)matrixStack, (Font)textRenderer, (Component)portListeningLabel, (int)(gui.f_96543_ / 2 - 155), (int)(gui.f_96544_ - 66), (int)0xA0A0A0);
            } else {
                Screen.m_93243_((PoseStack)matrixStack, (Font)textRenderer, (Component)portDescLabel, (int)(gui.f_96543_ / 2 - 155), (int)(gui.f_96544_ - 66), (int)0xA0A0A0);
            }
            Screen.m_93243_((PoseStack)matrixStack, (Font)textRenderer, (Component)maxPlayerDescLabel, (int)(gui.f_96543_ / 2 + 5), (int)(gui.f_96544_ - 66), (int)0xA0A0A0);
        }
        if ((mouserOverControl = gui.m_94729_((double)mouseX, (double)mouseY)).isPresent() && mouserOverControl.get() instanceof TooltipAccessor) {
            List tooltips = ((TooltipAccessor)mouserOverControl.get()).m_141932_();
            gui.m_96617_(matrixStack, tooltips, mouseX, mouseY);
        }
    }

    public int getServerPort() {
        return this.port;
    }

    public void onOpenToLanClosed() {
        IntegratedServer server = Minecraft.m_91087_().m_91092_();
        this.applyServerConfig(server, false);
    }
}

