/*
 * Decompiled with CFR 0.152.
 */
package io.github.bumblesoftware.fastload.api.event.core;

import io.github.bumblesoftware.fastload.api.event.core.EventArgs;
import io.github.bumblesoftware.fastload.api.event.core.EventHolder;
import io.github.bumblesoftware.fastload.api.event.core.StableEventArgs;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.ArrayList;
import java.util.List;

public interface AbstractEvent<Context> {
    public static final String GENERIC_LOCATION = "generic";
    public static final List<String> GENERIC_LOCATION_LIST = List.of("generic");

    default public boolean isNotEmpty() {
        for (String location : this.getLocationList()) {
            if (!this.isNotEmpty(location)) continue;
            return true;
        }
        return false;
    }

    default public boolean isNotEmpty(String ... locations) {
        for (String location : locations) {
            EventHolder eventHolder = (EventHolder)this.getStorage().get((Object)location);
            if (eventHolder == null) continue;
            for (Long priority : eventHolder.priorityHolder()) {
                if (((List)eventHolder.argsHolder().get(priority.longValue())).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public void clean();

    default public EventHolder<Context> getNewHolder() {
        return new EventHolder(new Long2ObjectLinkedOpenHashMap(), new ArrayList<Long>());
    }

    public Object2ObjectMap<String, EventHolder<Context>> getStorage();

    public List<String> getLocationList();

    public void removeDynamic(long var1, List<String> var3, EventArgs<Context> var4);

    default public void removeDynamic(long priority, EventArgs<Context> eventArgs) {
        this.removeDynamic(priority, GENERIC_LOCATION_LIST, eventArgs);
    }

    public void removeStatic(long var1, List<String> var3, EventArgs<Context> var4);

    default public void removeStatic(long priority, EventArgs<Context> eventArgs) {
        this.removeStatic(priority, GENERIC_LOCATION_LIST, eventArgs);
    }

    public void registerDynamic(long var1, List<String> var3, EventArgs<Context> var4);

    default public void registerDynamic(long priority, List<String> locations, StableEventArgs<Context> eventArgs) {
        this.registerDynamic(priority, locations, eventArgs.upcast());
    }

    default public void registerDynamic(long priority, EventArgs<Context> eventArgs) {
        this.registerDynamic(priority, GENERIC_LOCATION_LIST, eventArgs);
    }

    default public void registerDynamic(long priority, StableEventArgs<Context> eventArgs) {
        this.registerDynamic(priority, GENERIC_LOCATION_LIST, eventArgs.upcast());
    }

    public void registerStatic(long var1, List<String> var3, EventArgs<Context> var4);

    default public void registerStatic(long priority, List<String> locations, StableEventArgs<Context> eventArgs) {
        this.registerStatic(priority, locations, eventArgs.upcast());
    }

    default public void registerStatic(long priority, EventArgs<Context> eventArgs) {
        this.registerStatic(priority, GENERIC_LOCATION_LIST, eventArgs);
    }

    default public void registerStatic(long priority, StableEventArgs<Context> eventArgs) {
        this.registerStatic(priority, GENERIC_LOCATION_LIST, eventArgs.upcast());
    }

    public void execute(List<String> var1, boolean var2, Context var3);

    default public void execute(List<String> locations, Context eventContext) {
        this.execute(locations, false, eventContext);
    }

    default public void execute(boolean orderFlipped, Context eventContext) {
        this.execute(GENERIC_LOCATION_LIST, orderFlipped, eventContext);
    }

    default public void execute(Context eventContext) {
        this.execute(GENERIC_LOCATION_LIST, false, eventContext);
    }
}

