/*
 * Decompiled with CFR 0.152.
 */
package com.hyperdash.firmaciv.entity.FirmacivBoatRenderer;

import com.google.common.collect.ImmutableMap;
import com.hyperdash.firmaciv.entity.custom.CanoeEntity;
import com.hyperdash.firmaciv.entity.custom.entitymodel.CanoeEntityModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class FirmacivCanoeRenderer
extends EntityRenderer<CanoeEntity> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<CanoeEntity.Type, Pair<ResourceLocation, CanoeEntityModel>> canoeResources;
    private static final ResourceLocation DOUGLAS_FIR = new ResourceLocation("firmaciv", "textures/entity/watercraft/dugout_canoe/douglas_fir.png");
    private static final ResourceLocation PINE = new ResourceLocation("firmaciv", "textures/entity/watercraft/dugout_canoe/pine.png");
    private static final ResourceLocation CHESTNUT = new ResourceLocation("firmaciv", "textures/entity/watercraft/dugout_canoe/chestnut.png");
    private static final ResourceLocation SPRUCE = new ResourceLocation("firmaciv", "textures/entity/watercraft/dugout_canoe/spruce.png");
    private static final ResourceLocation ASPEN = new ResourceLocation("firmaciv", "textures/entity/watercraft/dugout_canoe/aspen.png");
    private static final ResourceLocation KAPOK = new ResourceLocation("firmaciv", "textures/entity/watercraft/dugout_canoe/kapok.png");
    private static final ResourceLocation ROSEWOOD = new ResourceLocation("firmaciv", "textures/entity/watercraft/dugout_canoe/rosewood.png");
    private static final ResourceLocation WHITE_CEDAR = new ResourceLocation("firmaciv", "textures/entity/watercraft/dugout_canoe/white_cedar.png");
    private static final ResourceLocation WILLOW = new ResourceLocation("firmaciv", "textures/entity/watercraft/dugout_canoe/douglas_fir.png");

    public FirmacivCanoeRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.f_114477_ = 0.7f;
        this.canoeResources = (Map)Stream.of(CanoeEntity.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)new ResourceLocation("firmaciv", "textures/entity/watercraft/dugout_canoe/" + type.getName() + ".png"), new CanoeEntityModel())));
    }

    public void render(CanoeEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        float f2;
        pMatrixStack.m_85836_();
        pMatrixStack.m_85837_(0.0, 0.4375, 0.0);
        pMatrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - pEntityYaw));
        float f = (float)pEntity.getHurtTime() - pPartialTicks;
        float f1 = pEntity.getDamage() - pPartialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            pMatrixStack.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14031_((float)f) * f * f1 / 10.0f * (float)pEntity.getHurtDir()));
        }
        if (!Mth.m_14033_((float)(f2 = pEntity.getBubbleAngle(pPartialTicks)), (float)0.0f)) {
            pMatrixStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 1.0f), pEntity.getBubbleAngle(pPartialTicks), true));
        }
        Pair<ResourceLocation, CanoeEntityModel> pair = this.getModelWithLocation(pEntity);
        ResourceLocation resourcelocation = (ResourceLocation)pair.getFirst();
        CanoeEntityModel canoeModel = (CanoeEntityModel)((Object)pair.getSecond());
        pMatrixStack.m_85837_(0.0, 1.0625, 0.0);
        pMatrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
        pMatrixStack.m_85845_(Vector3f.f_122225_.m_122240_(0.0f));
        canoeModel.setupAnim(pEntity, pPartialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = pBuffer.m_6299_(canoeModel.m_103119_(this.getTextureLocation(pEntity)));
        canoeModel.m_7695_(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!pEntity.m_5842_()) {
            VertexConsumer vertexconsumer1 = pBuffer.m_6299_(RenderType.m_110478_());
            canoeModel.getWaterocclusion().m_104301_(pMatrixStack, vertexconsumer1, pPackedLight, OverlayTexture.f_118083_);
        }
        pMatrixStack.m_85849_();
        super.m_7392_((Entity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    @Deprecated
    public ResourceLocation getTextureLocation(CanoeEntity pEntity) {
        int id = pEntity.m_142049_();
        ResourceLocation resloc = pEntity.getTextureLocation();
        resloc = new ResourceLocation("firmaciv", "textures/entity/watercraft/dugout_canoe/" + pEntity.getCanoeType() + ".png");
        return new ResourceLocation("firmaciv", "textures/entity/watercraft/dugout_canoe/" + pEntity.getCanoeType() + ".png");
    }

    public Pair<ResourceLocation, CanoeEntityModel> getModelWithLocation(CanoeEntity canoe) {
        return this.canoeResources.get((Object)canoe.getCanoeType());
    }
}

