/*
 * Decompiled with CFR 0.152.
 */
package com.hyperdash.firmaciv.client;

import com.hyperdash.firmaciv.entity.FirmacivBoatRenderer.FirmacivCanoeRenderer;
import com.hyperdash.firmaciv.entity.FirmacivEntities;
import com.hyperdash.firmaciv.entity.custom.CanoeEntity;
import com.hyperdash.firmaciv.item.FirmacivItems;
import com.hyperdash.firmaciv.item.custom.AbstractNavItem;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class FirmacivClientEvents {
    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(FirmacivClientEvents::clientSetup);
    }

    private static void clientSetup(FMLClientSetupEvent event) {
        for (CanoeEntity.Type type : CanoeEntity.Type.values()) {
            EntityRenderers.m_174036_((EntityType)((EntityType)FirmacivEntities.CANOES.get((Object)type).get()), FirmacivCanoeRenderer::new);
        }
        ItemProperties.register((Item)((Item)FirmacivItems.BAROMETER.get()), (ResourceLocation)new ResourceLocation("firmaciv", "altitude"), (ItemPropertyFunction)new ClampedItemPropertyFunction(){
            private double rotation;
            private double rota;
            private long lastUpdateTick;

            public float m_142187_(ItemStack pStack, @Nullable ClientLevel pLevel, @Nullable LivingEntity livingEntity, int p_174668_) {
                double height;
                LivingEntity entity;
                Object object = entity = livingEntity != null ? livingEntity : pStack.m_41609_();
                if (entity == null) {
                    return 0.0f;
                }
                if (pLevel == null && entity.f_19853_ instanceof ClientLevel) {
                    pLevel = (ClientLevel)entity.f_19853_;
                }
                if (pLevel == null) {
                    return 0.0f;
                }
                if (pLevel.m_6042_().m_63956_()) {
                    assert (livingEntity != null);
                    height = (entity.m_20186_() + 64.0) / (double)pLevel.m_141928_();
                } else {
                    height = Math.random();
                }
                return (float)height;
            }
        });
        ItemProperties.register((Item)((Item)FirmacivItems.NAV_CLOCK.get()), (ResourceLocation)new ResourceLocation("firmaciv", "pm_time"), (ItemPropertyFunction)new ClampedItemPropertyFunction(){
            private double rotation;
            private double rota;
            private long lastUpdateTick;

            public float m_142187_(ItemStack p_174665_, @Nullable ClientLevel p_174666_, @Nullable LivingEntity livingEntity, int p_174668_) {
                double time;
                LivingEntity entity;
                Object object = entity = livingEntity != null ? livingEntity : p_174665_.m_41609_();
                if (entity == null) {
                    return 0.0f;
                }
                if (p_174666_ == null && entity.f_19853_ instanceof ClientLevel) {
                    p_174666_ = (ClientLevel)entity.f_19853_;
                }
                double longitude = Math.abs(AbstractNavItem.getNavLocation(entity.m_146892_())[AbstractNavItem.NavSelection.LONGITUDE.ordinal()] % 180.0 / 180.0);
                if (p_174666_ == null) {
                    return 0.0f;
                }
                if (p_174666_.m_6042_().m_63956_()) {
                    time = p_174666_.m_46942_(1.0f);
                    time += longitude;
                    time %= 1.0;
                } else {
                    time = Math.random();
                }
                time = this.wobble((Level)p_174666_, time);
                return (float)time;
            }

            private double wobble(Level p_117904_, double p_117905_) {
                if (p_117904_.m_46467_() != this.lastUpdateTick) {
                    this.lastUpdateTick = p_117904_.m_46467_();
                    double d0 = p_117905_ - this.rotation;
                    d0 = Mth.m_14109_((double)(d0 + 0.5), (double)1.0) - 0.5;
                    this.rota += d0 * 0.1;
                    this.rota *= 0.9;
                    this.rotation = Mth.m_14109_((double)(this.rotation + this.rota), (double)1.0);
                }
                return this.rotation;
            }
        });
    }
}

