/*
 * Decompiled with CFR 0.152.
 */
package com.hyperdash.firmaciv.block;

import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SquaredAngleBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.f_61398_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape TOP_AABB = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape BOTTOM_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape OCTET_NNN = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0);
    protected static final VoxelShape OCTET_NNP = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0);
    protected static final VoxelShape OCTET_NPN = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
    protected static final VoxelShape OCTET_NPP = Block.m_49796_((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape OCTET_PNN = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
    protected static final VoxelShape OCTET_PNP = Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape OCTET_PPN = Block.m_49796_((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape OCTET_PPP = Block.m_49796_((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape[] TOP_SHAPES = SquaredAngleBlock.makeShapes(TOP_AABB, OCTET_NNN, OCTET_PNN, OCTET_NNP, OCTET_PNP);
    protected static final VoxelShape[] BOTTOM_SHAPES = SquaredAngleBlock.makeShapes(BOTTOM_AABB, OCTET_NPN, OCTET_PPN, OCTET_NPP, OCTET_PPP);
    private static final int[] SHAPE_BY_STATE = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};
    private final Block base;
    private final BlockState baseState;
    private final Supplier<BlockState> stateSupplier;

    private static VoxelShape[] makeShapes(VoxelShape pSlabShape, VoxelShape pNwCorner, VoxelShape pNeCorner, VoxelShape pSwCorner, VoxelShape pSeCorner) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(p_56945_ -> SquaredAngleBlock.makeStairShape(p_56945_, pSlabShape, pNwCorner, pNeCorner, pSwCorner, pSeCorner)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape makeStairShape(int pBitfield, VoxelShape pSlabShape, VoxelShape pNwCorner, VoxelShape pNeCorner, VoxelShape pSwCorner, VoxelShape pSeCorner) {
        double move = -0.5;
        if (pSlabShape == TOP_AABB) {
            move = 0.5;
        }
        VoxelShape NwCornerOpposite = pNwCorner.m_83216_(0.0, move, 0.0);
        VoxelShape NeCornerOpposite = pNeCorner.m_83216_(0.0, move, 0.0);
        VoxelShape SwCornerOpposite = pSwCorner.m_83216_(0.0, move, 0.0);
        VoxelShape SeCornerOpposite = pSeCorner.m_83216_(0.0, move, 0.0);
        VoxelShape voxelshape = pSlabShape;
        if ((pBitfield & 1) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)pSlabShape, (VoxelShape)pNwCorner);
            voxelshape = Shapes.m_83113_((VoxelShape)voxelshape, (VoxelShape)NwCornerOpposite, (BooleanOp)BooleanOp.f_82685_);
        }
        if ((pBitfield & 2) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)pNeCorner);
            voxelshape = Shapes.m_83113_((VoxelShape)voxelshape, (VoxelShape)NeCornerOpposite, (BooleanOp)BooleanOp.f_82685_);
        }
        if ((pBitfield & 4) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)pSwCorner);
            voxelshape = Shapes.m_83113_((VoxelShape)voxelshape, (VoxelShape)SwCornerOpposite, (BooleanOp)BooleanOp.f_82685_);
        }
        if ((pBitfield & 8) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)pSeCorner);
            voxelshape = Shapes.m_83113_((VoxelShape)voxelshape, (VoxelShape)SeCornerOpposite, (BooleanOp)BooleanOp.f_82685_);
        }
        return voxelshape;
    }

    @Deprecated
    public SquaredAngleBlock(BlockState pBaseState, BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)Half.BOTTOM)).m_61124_(SHAPE, (Comparable)StairsShape.STRAIGHT)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.base = pBaseState.m_60734_();
        this.baseState = pBaseState;
        this.stateSupplier = () -> pBaseState;
    }

    public SquaredAngleBlock(Supplier<BlockState> state, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)Half.BOTTOM)).m_61124_(SHAPE, (Comparable)StairsShape.STRAIGHT)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.base = Blocks.f_50016_;
        this.baseState = Blocks.f_50016_.m_49966_();
        this.stateSupplier = state;
    }

    public boolean m_7923_(BlockState pState) {
        return true;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return (pState.m_61143_(HALF) == Half.TOP ? TOP_SHAPES : BOTTOM_SHAPES)[SHAPE_BY_STATE[this.getShapeIndex(pState)]];
    }

    private int getShapeIndex(BlockState pState) {
        return ((StairsShape)pState.m_61143_(SHAPE)).ordinal() * 4 + ((Direction)pState.m_61143_((Property)FACING)).m_122416_();
    }

    public void m_7100_(BlockState pState, Level pLevel, BlockPos pPos, Random pRand) {
        this.base.m_7100_(pState, pLevel, pPos, pRand);
    }

    public void m_6256_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        this.baseState.m_60686_(pLevel, pPos, pPlayer);
    }

    public void m_6786_(LevelAccessor pLevel, BlockPos pPos, BlockState pState) {
        this.base.m_6786_(pLevel, pPos, pState);
    }

    public float m_7325_() {
        return this.base.m_7325_();
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pState.m_60713_(pState.m_60734_())) {
            this.baseState.m_60690_(pLevel, pPos, Blocks.f_50016_, pPos, false);
            this.base.m_6807_(this.baseState, pLevel, pPos, pOldState, false);
        }
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            this.baseState.m_60753_(pLevel, pPos, pNewState, pIsMoving);
        }
    }

    public void m_141947_(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
        this.base.m_141947_(pLevel, pPos, pState, pEntity);
    }

    public boolean m_6724_(BlockState pState) {
        return this.base.m_6724_(pState);
    }

    public void m_7455_(BlockState pState, ServerLevel pLevel, BlockPos pPos, Random pRandom) {
        this.base.m_7455_(pState, pLevel, pPos, pRandom);
    }

    public void m_7458_(BlockState pState, ServerLevel pLevel, BlockPos pPos, Random pRand) {
        this.base.m_7458_(pState, pLevel, pPos, pRand);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        return this.baseState.m_60664_(pLevel, pPlayer, pHand, pHit);
    }

    public void m_7592_(Level pLevel, BlockPos pPos, Explosion pExplosion) {
        this.base.m_7592_(pLevel, pPos, pExplosion);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        Direction direction = pContext.m_43719_();
        BlockPos blockpos = pContext.m_8083_();
        FluidState fluidstate = pContext.m_43725_().m_6425_(blockpos);
        BlockState blockstate = (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_())).m_61124_(HALF, (Comparable)(!(direction == Direction.DOWN || direction != Direction.UP && pContext.m_43720_().f_82480_ - (double)blockpos.m_123342_() > 0.5) ? Half.BOTTOM : Half.TOP))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        return (BlockState)blockstate.m_61124_(SHAPE, (Comparable)SquaredAngleBlock.getStairsShape(blockstate, (BlockGetter)pContext.m_43725_(), blockpos));
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return pFacing.m_122434_().m_122479_() ? (BlockState)pState.m_61124_(SHAPE, (Comparable)SquaredAngleBlock.getStairsShape(pState, (BlockGetter)pLevel, pCurrentPos)) : super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    private static StairsShape getStairsShape(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        BlockState blockstate = pLevel.m_8055_(pPos.m_142300_(direction));
        if (SquaredAngleBlock.isRoof(blockstate) && pState.m_61143_(HALF) == blockstate.m_61143_(HALF) && (direction1 = (Direction)blockstate.m_61143_((Property)FACING)).m_122434_() != ((Direction)pState.m_61143_((Property)FACING)).m_122434_() && SquaredAngleBlock.canTakeShape(pState, pLevel, pPos, direction1.m_122424_())) {
            if (direction1 == direction.m_122428_()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = pLevel.m_8055_(pPos.m_142300_(direction.m_122424_()));
        if (SquaredAngleBlock.isRoof(blockstate1) && pState.m_61143_(HALF) == blockstate1.m_61143_(HALF) && (direction2 = (Direction)blockstate1.m_61143_((Property)FACING)).m_122434_() != ((Direction)pState.m_61143_((Property)FACING)).m_122434_() && SquaredAngleBlock.canTakeShape(pState, pLevel, pPos, direction2)) {
            if (direction2 == direction.m_122428_()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean canTakeShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, Direction pFace) {
        BlockState blockstate = pLevel.m_8055_(pPos.m_142300_(pFace));
        return !SquaredAngleBlock.isRoof(blockstate) || blockstate.m_61143_((Property)FACING) != pState.m_61143_((Property)FACING) || blockstate.m_61143_(HALF) != pState.m_61143_(HALF);
    }

    public static boolean isRoof(BlockState pState) {
        return pState.m_60734_() instanceof SquaredAngleBlock;
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        StairsShape stairsshape = (StairsShape)pState.m_61143_(SHAPE);
        switch (pMirror) {
            case LEFT_RIGHT: {
                if (direction.m_122434_() != Direction.Axis.Z) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                }
                return pState.m_60717_(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (direction.m_122434_() != Direction.Axis.X) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                    case STRAIGHT: {
                        return pState.m_60717_(Rotation.CLOCKWISE_180);
                    }
                }
            }
        }
        return super.m_6943_(pState, pMirror);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, HALF, SHAPE, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    private Block getModelBlock() {
        return this.getModelState().m_60734_();
    }

    private BlockState getModelState() {
        return this.stateSupplier.get();
    }
}

