/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.surface.builder;

import net.dries007.tfc.world.surface.SurfaceBuilderContext;
import net.dries007.tfc.world.surface.SurfaceState;
import net.dries007.tfc.world.surface.SurfaceStates;
import net.dries007.tfc.world.surface.builder.SurfaceBuilderFactory;
import net.minecraft.world.level.block.state.BlockState;

public enum NormalSurfaceBuilder implements SurfaceBuilderFactory.Invariant
{
    INSTANCE;


    @Override
    public void buildSurface(SurfaceBuilderContext context, int startY, int endY) {
        this.buildSurface(context, startY, endY, SurfaceStates.GRASS, SurfaceStates.DIRT, SurfaceStates.SANDSTONE_OR_GRAVEL);
    }

    public void buildSurface(SurfaceBuilderContext context, int startY, int endY, SurfaceState topState, SurfaceState midState, SurfaceState underState) {
        int surfaceDepth = -1;
        int surfaceY = 0;
        boolean underwaterLayer = false;
        boolean firstLayer = false;
        SurfaceState surfaceState = SurfaceStates.RAW;
        for (int y = startY; y >= endY; --y) {
            BlockState stateAt = context.getBlockState(y);
            if (stateAt.m_60795_()) {
                surfaceDepth = -1;
                continue;
            }
            if (!context.isDefaultBlock(stateAt)) continue;
            if (surfaceDepth == -1) {
                surfaceY = y;
                firstLayer = true;
                if (y < context.getSeaLevel() - 1) {
                    surfaceDepth = context.calculateAltitudeSlopeSurfaceDepth(surfaceY, 2, 0.1, -1);
                    if (surfaceDepth == -1) {
                        surfaceDepth = 0;
                        context.setBlockState(y, SurfaceStates.SANDSTONE_OR_GRAVEL);
                    } else {
                        context.setBlockState(y, SurfaceStates.SAND_OR_GRAVEL);
                    }
                    surfaceState = SurfaceStates.SAND_OR_GRAVEL;
                    underwaterLayer = true;
                    continue;
                }
                surfaceDepth = context.calculateAltitudeSlopeSurfaceDepth(surfaceY, 3, 0.0, -1);
                if (surfaceDepth == -1) {
                    surfaceDepth = 0;
                    context.setBlockState(y, underState);
                } else {
                    context.setBlockState(y, topState);
                }
                surfaceState = midState;
                underwaterLayer = false;
                continue;
            }
            if (surfaceDepth <= 0) continue;
            context.setBlockState(y, surfaceState);
            if (--surfaceDepth != 0 || !firstLayer) continue;
            firstLayer = false;
            if (underwaterLayer) {
                surfaceDepth = context.calculateAltitudeSlopeSurfaceDepth(surfaceY, 4, 0.4, 0);
                surfaceState = SurfaceStates.SANDSTONE_OR_GRAVEL;
                continue;
            }
            surfaceDepth = context.calculateAltitudeSlopeSurfaceDepth(surfaceY, 7, 0.3, 0);
            surfaceState = underState;
        }
    }
}

