/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.surface;

import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.SandstoneBlockType;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.soil.SandBlockType;
import net.dries007.tfc.common.blocks.soil.SoilBlockType;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.world.surface.SoilSurfaceState;
import net.dries007.tfc.world.surface.SurfaceBuilderContext;
import net.dries007.tfc.world.surface.SurfaceState;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;

public final class SurfaceStates {
    public static final SurfaceState RAW = context -> context.getRock().raw().m_49966_();
    public static final SurfaceState COBBLE = context -> context.getRock().cobble().m_49966_();
    public static final SurfaceState GRAVEL = context -> context.getRock().gravel().m_49966_();
    public static final SurfaceState GRASS = SoilSurfaceState.buildType(SoilBlockType.GRASS);
    public static final SurfaceState DIRT = SoilSurfaceState.buildType(SoilBlockType.DIRT);
    public static final SurfaceState MUD = SoilSurfaceState.buildType(SoilBlockType.MUD);
    public static final SurfaceState SAND_OR_GRAVEL = SoilSurfaceState.buildSandOrGravel(false);
    public static final SurfaceState SANDSTONE_OR_GRAVEL = SoilSurfaceState.buildSandOrGravel(true);
    public static final SurfaceState SHORE_SAND = context -> context.getBottomRock().sand().m_49966_();
    public static final SurfaceState SHORE_SANDSTONE = context -> context.getBottomRock().sandstone().m_49966_();
    public static final SurfaceState SHORE_MUD = context -> ((Block)TFCBlocks.SOIL.get((Object)SoilBlockType.MUD).get(SoilBlockType.Variant.SANDY_LOAM).get()).m_49966_();
    public static final SurfaceState RARE_SHORE_SAND = new SurfaceState(){
        private final Supplier<Block> pinkSand = (Supplier)TFCBlocks.SAND.get((Object)SandBlockType.PINK);
        private final Supplier<Block> blackSand = (Supplier)TFCBlocks.SAND.get((Object)SandBlockType.BLACK);

        @Override
        public BlockState getState(SurfaceBuilderContext context) {
            if (context.rainfall() > 300.0f && context.averageTemperature() > 15.0f) {
                return this.pinkSand.get().m_49966_();
            }
            if (context.rainfall() > 300.0f) {
                return this.blackSand.get().m_49966_();
            }
            return context.getBottomRock().sand().m_49966_();
        }
    };
    public static final SurfaceState RARE_SHORE_SANDSTONE = new SurfaceState(){
        private final Supplier<Block> pinkSandstone = (Supplier)TFCBlocks.SANDSTONE.get((Object)SandBlockType.PINK).get((Object)SandstoneBlockType.RAW);
        private final Supplier<Block> blackSandstone = (Supplier)TFCBlocks.SANDSTONE.get((Object)SandBlockType.BLACK).get((Object)SandstoneBlockType.RAW);

        @Override
        public BlockState getState(SurfaceBuilderContext context) {
            if (context.rainfall() > 300.0f && context.averageTemperature() > 15.0f) {
                return this.pinkSandstone.get().m_49966_();
            }
            if (context.rainfall() > 300.0f) {
                return this.blackSandstone.get().m_49966_();
            }
            return context.getBottomRock().sandstone().m_49966_();
        }
    };
    public static final SurfaceState WATER = context -> context.salty() ? TFCFluids.SALT_WATER.createSourceBlock() : Fluids.f_76193_.m_76145_().m_76188_();
}

