/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.noise;

import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.noise.TrilinearInterpolator;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class NoiseSampler {
    public final TrilinearInterpolator.Source noiseCaves;
    public final TrilinearInterpolator.Source noodleToggle;
    public final TrilinearInterpolator.Source noodleThickness;
    public final TrilinearInterpolator.Source noodleRidgeA;
    public final TrilinearInterpolator.Source noodleRidgeB;
    public final NormalNoise barrierNoise;
    public final PositionalRandomFactory positionalRandomFactory;
    private final NoiseSettings noiseSettings;
    private final NormalNoise spaghetti2DNoiseSource;
    private final NormalNoise spaghetti2DElevationModulator;
    private final NormalNoise spaghetti2DRarityModulator;
    private final NormalNoise spaghetti2DThicknessModulator;
    private final NormalNoise spaghetti3DNoiseSource1;
    private final NormalNoise spaghetti3DNoiseSource2;
    private final NormalNoise spaghetti3DRarityModulator;
    private final NormalNoise spaghetti3DThicknessModulator;
    private final NormalNoise spaghettiRoughnessNoise;
    private final NormalNoise spaghettiRoughnessModulator;
    private final NormalNoise bigEntranceNoiseSource;
    private final NormalNoise layerNoiseSource;
    private final NormalNoise cheeseNoiseSource;

    private static double clampToUnit(double value) {
        return Mth.m_14008_((double)value, (double)-1.0, (double)1.0);
    }

    private static double sampleWithRarity(NormalNoise noise, double x, double y, double z, double rarity) {
        return noise.m_75380_(x / rarity, y / rarity, z / rarity);
    }

    private static TrilinearInterpolator.Source clamped(NormalNoise normalNoise, int minY, int maxY, int outOfBoundsValue, double scale) {
        return (x, y, z) -> y <= maxY && y >= minY ? normalNoise.m_75380_((double)x * scale, (double)y * scale, (double)z * scale) : (double)outOfBoundsValue;
    }

    public NoiseSampler(NoiseSettings noiseSettings, long seed, Registry<NormalNoise.NoiseParameters> parameters) {
        this.positionalRandomFactory = new XoroshiroRandomSource(seed).m_183423_();
        this.noiseSettings = noiseSettings;
        this.noiseCaves = this::calculateNoiseCaves;
        this.spaghetti2DNoiseSource = Noises.m_189305_(parameters, (PositionalRandomFactory)this.positionalRandomFactory, (ResourceKey)Noises.f_189294_);
        this.spaghetti2DElevationModulator = Noises.m_189305_(parameters, (PositionalRandomFactory)this.positionalRandomFactory, (ResourceKey)Noises.f_189295_);
        this.spaghetti2DRarityModulator = Noises.m_189305_(parameters, (PositionalRandomFactory)this.positionalRandomFactory, (ResourceKey)Noises.f_189296_);
        this.spaghetti2DThicknessModulator = Noises.m_189305_(parameters, (PositionalRandomFactory)this.positionalRandomFactory, (ResourceKey)Noises.f_189297_);
        this.spaghetti3DNoiseSource1 = Noises.m_189305_(parameters, (PositionalRandomFactory)this.positionalRandomFactory, (ResourceKey)Noises.f_189298_);
        this.spaghetti3DNoiseSource2 = Noises.m_189305_(parameters, (PositionalRandomFactory)this.positionalRandomFactory, (ResourceKey)Noises.f_189299_);
        this.spaghetti3DRarityModulator = Noises.m_189305_(parameters, (PositionalRandomFactory)this.positionalRandomFactory, (ResourceKey)Noises.f_189300_);
        this.spaghetti3DThicknessModulator = Noises.m_189305_(parameters, (PositionalRandomFactory)this.positionalRandomFactory, (ResourceKey)Noises.f_189301_);
        this.spaghettiRoughnessNoise = Noises.m_189305_(parameters, (PositionalRandomFactory)this.positionalRandomFactory, (ResourceKey)Noises.f_189302_);
        this.spaghettiRoughnessModulator = Noises.m_189305_(parameters, (PositionalRandomFactory)this.positionalRandomFactory, (ResourceKey)Noises.f_189243_);
        this.bigEntranceNoiseSource = Noises.m_189305_(parameters, (PositionalRandomFactory)this.positionalRandomFactory, (ResourceKey)Noises.f_189244_);
        this.layerNoiseSource = Noises.m_189305_(parameters, (PositionalRandomFactory)this.positionalRandomFactory, (ResourceKey)Noises.f_189245_);
        this.cheeseNoiseSource = Noises.m_189305_(parameters, (PositionalRandomFactory)this.positionalRandomFactory, (ResourceKey)Noises.f_189246_);
        int minWorldY = noiseSettings.f_158688_();
        int minLimitY = minWorldY + 4;
        int maxLimitY = minWorldY + noiseSettings.f_64508_();
        this.noodleToggle = NoiseSampler.clamped(Noises.m_189305_(parameters, (PositionalRandomFactory)this.positionalRandomFactory, (ResourceKey)Noises.f_189251_), minLimitY, maxLimitY, -1, 1.0);
        this.noodleThickness = NoiseSampler.clamped(Noises.m_189305_(parameters, (PositionalRandomFactory)this.positionalRandomFactory, (ResourceKey)Noises.f_189252_), minLimitY, maxLimitY, 0, 1.0);
        this.noodleRidgeA = NoiseSampler.clamped(Noises.m_189305_(parameters, (PositionalRandomFactory)this.positionalRandomFactory, (ResourceKey)Noises.f_189253_), minLimitY, maxLimitY, 0, 2.6666666666666665);
        this.noodleRidgeB = NoiseSampler.clamped(Noises.m_189305_(parameters, (PositionalRandomFactory)this.positionalRandomFactory, (ResourceKey)Noises.f_189254_), minLimitY, maxLimitY, 0, 2.6666666666666665);
        this.barrierNoise = Noises.m_189305_(parameters, (PositionalRandomFactory)this.positionalRandomFactory, (ResourceKey)Noises.f_189287_);
    }

    private double calculateNoiseCaves(int x, int y, int z) {
        double bigEntrances = this.getBigEntrances(x, y, z);
        double spaghettiRoughness = this.getSpaghettiRoughness(x, y, z);
        double spaghetti2D = this.getSpaghetti2D(x, y, z);
        double spaghetti3D = this.getSpaghetti3D(x, y, z);
        double spaghetti = spaghettiRoughness + Math.min(spaghetti2D, spaghetti3D);
        double cheese = Mth.m_14008_((double)(this.cheeseNoiseSource.m_75380_((double)x, (double)y / 1.5, (double)z) + 0.27), (double)-1.0, (double)1.0);
        double layerizedCaverns = this.getLayerizedCaverns(x, y, z);
        double noise = Math.min(cheese + layerizedCaverns, Math.min(spaghetti, bigEntrances));
        double clamped = Mth.m_14008_((double)noise, (double)-1.0, (double)1.0);
        return this.applySlide(clamped, y);
    }

    protected double applySlide(double noise, int y) {
        if (y >= 20) {
            double slideFactor = Mth.m_184655_((float)y, (float)20.0f, (float)(this.noiseSettings.f_158688_() + this.noiseSettings.f_64508_()));
            return Mth.m_14139_((double)slideFactor, (double)noise, (double)2.5);
        }
        return noise;
    }

    private double getBigEntrances(int x, int y, int z) {
        double d3 = this.bigEntranceNoiseSource.m_75380_((double)x * 0.75, (double)y * 0.5, (double)z * 0.75) + 0.37;
        double d4 = (double)(y + 10) / 40.0;
        return d3 + Mth.m_14085_((double)0.3, (double)0.0, (double)d4);
    }

    private double getLayerizedCaverns(int x, int y, int z) {
        double value = this.layerNoiseSource.m_75380_((double)x, (double)(y * 8), (double)z);
        return Mth.m_144952_((double)value) * 4.0;
    }

    private double getSpaghetti3D(int x, int y, int z) {
        double d0 = this.spaghetti3DRarityModulator.m_75380_((double)(x * 2), (double)y, (double)(z * 2));
        double d1 = this.getDiscreteSpaghettiRarity3D(d0);
        double d4 = Helpers.sampleNoiseAndMapToRange(this.spaghetti3DThicknessModulator, x, y, z, 0.065, 0.088);
        double d5 = NoiseSampler.sampleWithRarity(this.spaghetti3DNoiseSource1, x, y, z, d1);
        double d6 = Math.abs(d1 * d5) - d4;
        double d7 = NoiseSampler.sampleWithRarity(this.spaghetti3DNoiseSource2, x, y, z, d1);
        double d8 = Math.abs(d1 * d7) - d4;
        return NoiseSampler.clampToUnit(Math.max(d6, d8));
    }

    private double getSpaghetti2D(int x, int y, int z) {
        double d0 = this.spaghetti2DRarityModulator.m_75380_((double)(x * 2), (double)y, (double)(z * 2));
        double d1 = this.getDiscreteSpaghettiRarity2D(d0);
        double d4 = Helpers.sampleNoiseAndMapToRange(this.spaghetti2DThicknessModulator, x * 2, y, z * 2, 0.6, 1.3);
        double d5 = NoiseSampler.sampleWithRarity(this.spaghetti2DNoiseSource, x, y, z, d1);
        double d7 = Math.abs(d1 * d5) - 0.083 * d4;
        int i = this.noiseSettings.m_189217_();
        double d8 = Helpers.sampleNoiseAndMapToRange(this.spaghetti2DElevationModulator, x, 0.0, z, i, 8.0);
        double d9 = Math.abs(d8 - (double)y / 8.0) - d4;
        d9 = d9 * d9 * d9;
        return NoiseSampler.clampToUnit(Math.max(d9, d7));
    }

    private double getSpaghettiRoughness(int x, int y, int z) {
        double value = Helpers.sampleNoiseAndMapToRange(this.spaghettiRoughnessModulator, x, y, z, 0.0, 0.1);
        return (0.4 - Math.abs(this.spaghettiRoughnessNoise.m_75380_((double)x, (double)y, (double)z))) * value;
    }

    private double getDiscreteSpaghettiRarity2D(double value) {
        if (value < -0.75) {
            return 0.5;
        }
        if (value < -0.5) {
            return 0.75;
        }
        if (value < 0.5) {
            return 1.0;
        }
        return value < 0.75 ? 2.0 : 3.0;
    }

    private double getDiscreteSpaghettiRarity3D(double value) {
        if (value < -0.5) {
            return 0.75;
        }
        if (value < 0.0) {
            return 1.0;
        }
        return value < 0.5 ? 1.5 : 2.0;
    }
}

