/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.noise;

import net.dries007.tfc.world.noise.FastNoiseLite;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.minecraft.util.Mth;

@FunctionalInterface
public interface Noise2D {
    public float noise(float var1, float var2);

    default public Noise2D octaves(int octaves) {
        float[] frequency = new float[octaves];
        float[] amplitude = new float[octaves];
        for (int i = 0; i < octaves; ++i) {
            frequency[i] = 1 << i;
            amplitude[i] = (float)Math.pow(0.5, octaves - i);
        }
        return (x, y) -> {
            float value = 0.0f;
            for (int i = 0; i < octaves; ++i) {
                value += this.noise(x / frequency[i], y / frequency[i]) * amplitude[i];
            }
            return value;
        };
    }

    default public Noise2D ridged() {
        return (x, y) -> {
            float value = this.noise(x, y);
            value = value < 0.0f ? -value : value;
            return 1.0f - 2.0f * value;
        };
    }

    default public Noise2D abs() {
        return (x, y) -> Math.abs(this.noise(x, y));
    }

    default public Noise2D terraces(int levels) {
        return (x, y) -> {
            float value = 0.5f * this.noise(x, y) + 0.5f;
            float rounded = (int)(value * (float)levels);
            return rounded * 2.0f / (float)levels - 1.0f;
        };
    }

    default public Noise2D spread(float scaleFactor) {
        return (x, y) -> this.noise(x * scaleFactor, y * scaleFactor);
    }

    default public Noise2D scaled(float min, float max) {
        return this.scaled(-1.0f, 1.0f, min, max);
    }

    default public Noise2D scaled(float oldMin, float oldMax, float min, float max) {
        float scale = (max - min) / (oldMax - oldMin);
        float shift = min - oldMin * scale;
        return this.affine(scale, shift);
    }

    default public Noise2D affine(float scale, float shift) {
        return (x, y) -> this.noise(x, y) * scale + shift;
    }

    default public Noise2D warped(OpenSimplex2D warp) {
        warp.fnl.SetDomainWarpType(FastNoiseLite.DomainWarpType.OpenSimplex2);
        warp.fnl.SetFractalType(FastNoiseLite.FractalType.DomainWarpIndependent);
        warp.fnl.SetDomainWarpAmp(warp.getAmplitude() * 2.0f);
        FastNoiseLite.Vector2 cursor = new FastNoiseLite.Vector2(0.0f, 0.0f);
        return (x, z) -> {
            cursor.x = x;
            cursor.y = z;
            warp.fnl.DomainWarp(cursor);
            return this.noise(cursor.x, cursor.y);
        };
    }

    default public Noise2D clamped(float min, float max) {
        return (x, y) -> Mth.m_14036_((float)this.noise(x, y), (float)min, (float)max);
    }

    default public Noise2D add(Noise2D other) {
        return (x, y) -> this.noise(x, y) + other.noise(x, y);
    }

    default public Noise2D lazyProduct(Noise2D other) {
        return (x, y) -> {
            float value = this.noise(x, y);
            return value == 0.0f ? 0.0f : value * other.noise(x, y);
        };
    }

    default public Noise2D map(FloatOperator mappingFunction) {
        return (x, y) -> mappingFunction.applyAsFloat(this.noise(x, y));
    }

    @FunctionalInterface
    public static interface FloatOperator {
        public float applyAsFloat(float var1);
    }
}

