/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.noise;

import net.dries007.tfc.util.Helpers;
import net.minecraft.world.level.levelgen.RandomSource;

public class Metaballs2D {
    private final Ball[] balls;

    public static Metaballs2D simple(RandomSource random, int size) {
        return new Metaballs2D(random, 3, 8, 0.1f * (float)size, 0.3f * (float)size, 0.5f * (float)size);
    }

    public Metaballs2D(RandomSource random, int minBalls, int maxBalls, float minSize, float maxSize, float radius) {
        int ballCount = Helpers.uniform(random, minBalls, maxBalls);
        this.balls = new Ball[ballCount];
        for (int i = 0; i < this.balls.length; ++i) {
            this.balls[i] = new Ball(Helpers.triangle(random, radius), Helpers.triangle(random, radius), Helpers.uniform(random, minSize, maxSize));
        }
    }

    public boolean inside(float x, float z) {
        float f = 0.0f;
        for (Ball ball : this.balls) {
            if (!((f += ball.weight * Math.abs(ball.weight) / ((x - ball.x) * (x - ball.x) + (z - ball.z) * (z - ball.z))) > 1.0f)) continue;
            return true;
        }
        return false;
    }

    record Ball(float x, float z, float weight) {
    }
}

