/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.vein;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.dries007.tfc.world.feature.vein.Indicator;
import net.dries007.tfc.world.feature.vein.Vein;
import net.dries007.tfc.world.feature.vein.VeinConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.jetbrains.annotations.Nullable;

public abstract class VeinFeature<C extends VeinConfig, V extends Vein>
extends Feature<C> {
    public VeinFeature(Codec<C> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<C> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        Random random = context.m_159776_();
        VeinConfig config = (VeinConfig)context.m_159778_();
        WorldGenerationContext generationContext = new WorldGenerationContext(context.m_159775_(), (LevelHeightAccessor)level);
        ChunkPos chunkPos = new ChunkPos(pos);
        List<V> veins = this.getNearbyVeins(level, generationContext, chunkPos, config.getChunkRadius(), config, arg_0 -> ((WorldGenLevel)level).m_204166_(arg_0));
        if (!veins.isEmpty()) {
            for (Vein vein : veins) {
                this.place(level, context.m_159775_(), random, chunkPos.m_45604_(), chunkPos.m_45605_(), vein, config);
            }
            return true;
        }
        return false;
    }

    public final List<V> getNearbyVeins(WorldGenLevel level, WorldGenerationContext context, ChunkPos pos, int radius, C config, Function<BlockPos, Holder<Biome>> biomeQuery) {
        ArrayList veins = new ArrayList();
        Random random = new Random();
        for (int x = pos.f_45578_ - radius; x <= pos.f_45578_ + radius; ++x) {
            for (int z = pos.f_45579_ - radius; z <= pos.f_45579_ + radius; ++z) {
                this.getVeinsAtChunk(level, context, x, z, veins, config, biomeQuery);
            }
        }
        return veins;
    }

    public final void getVeinsAtChunk(WorldGenLevel level, WorldGenerationContext context, int chunkPosX, int chunkPosZ, List<V> veins, C config, Function<BlockPos, Holder<Biome>> biomeQuery) {
        V vein;
        RandomSource forkedRandom = ((VeinConfig)config).random(level.m_7328_(), chunkPosX, chunkPosZ);
        if (((VeinConfig)config).random(level.m_7328_(), chunkPosX, chunkPosZ).nextInt(((VeinConfig)config).getRarity()) == 0 && ((VeinConfig)config).canSpawnInBiome(biomeQuery.apply(((Vein)(vein = this.createVein(context, chunkPosX << 4, chunkPosZ << 4, forkedRandom, config))).getPos()))) {
            veins.add(vein);
        }
    }

    protected void place(WorldGenLevel level, ChunkGenerator generator, Random random, int blockX, int blockZ, V vein, C config) {
        boolean debugIndicatorLocations = false;
        WorldGenerationContext context = new WorldGenerationContext(generator, (LevelHeightAccessor)level);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        BlockPos pos = ((Vein)vein).getPos();
        BoundingBox box = this.getBoundingBox(config, vein).m_71045_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        int minX = Math.max(blockX, box.m_162395_());
        int maxX = Math.min(blockX + 15, box.m_162399_());
        int minY = Math.max(((VeinConfig)config).getMinY(context), box.m_162396_());
        int maxY = Math.min(((VeinConfig)config).getMaxY(context), box.m_162400_());
        int minZ = Math.max(blockZ, box.m_162398_());
        int maxZ = Math.min(blockZ + 15, box.m_162401_());
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                int indicatorZ;
                int indicatorX;
                int indicatorY;
                int maxVeinY = -1;
                for (int y = minY; y <= maxY; ++y) {
                    BlockState stoneState;
                    BlockState oreState;
                    mutablePos.m_122178_(x, y, z);
                    if (!(random.nextFloat() < this.getChanceToGenerate(x - pos.m_123341_(), y - pos.m_123342_(), z - pos.m_123343_(), vein, config)) || (oreState = this.getStateToGenerate(stoneState = level.m_8055_((BlockPos)mutablePos), random, config)) == null) continue;
                    level.m_7731_((BlockPos)mutablePos, oreState, 3);
                    maxVeinY = y;
                }
                Indicator indicator = ((VeinConfig)config).getIndicator();
                if (indicator == null || maxVeinY == -1 || random.nextInt(indicator.rarity()) != 0 || Math.abs((indicatorY = level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, indicatorX = x + random.nextInt(indicator.spread()) - random.nextInt(indicator.spread()), indicatorZ = z + random.nextInt(indicator.spread()) - random.nextInt(indicator.spread()))) - maxVeinY) >= indicator.depth()) continue;
                mutablePos.m_122178_(indicatorX, indicatorY, indicatorZ);
                BlockState stateAt = level.m_8055_((BlockPos)mutablePos);
                BlockState state = FluidHelpers.fillWithFluid(indicator.getStateToGenerate(random), level.m_6425_((BlockPos)mutablePos).m_76152_());
                if (state == null || !EnvironmentHelpers.isWorldgenReplaceable(stateAt) || !state.m_60710_((LevelReader)level, (BlockPos)mutablePos)) continue;
                level.m_7731_((BlockPos)mutablePos, state, 3);
            }
        }
    }

    @Nullable
    protected BlockState getStateToGenerate(BlockState stoneState, Random random, C config) {
        return ((VeinConfig)config).getStateToGenerate(stoneState, random);
    }

    protected final BlockPos defaultPos(WorldGenerationContext context, int chunkX, int chunkZ, RandomSource random, C config) {
        return new BlockPos(chunkX + random.nextInt(16), this.defaultYPos(context, ((VeinConfig)config).getSize(), random, config), chunkZ + random.nextInt(16));
    }

    protected final int defaultYPos(WorldGenerationContext context, int verticalShrinkRange, RandomSource random, C config) {
        int actualRange = ((VeinConfig)config).getMaxY(context) - ((VeinConfig)config).getMinY(context) - 2 * verticalShrinkRange;
        if (actualRange > 0) {
            return ((VeinConfig)config).getMinY(context) + verticalShrinkRange + random.nextInt(actualRange);
        }
        return (((VeinConfig)config).getMinY(context) + ((VeinConfig)config).getMaxY(context)) / 2;
    }

    protected abstract float getChanceToGenerate(int var1, int var2, int var3, V var4, C var5);

    protected abstract V createVein(WorldGenerationContext var1, int var2, int var3, RandomSource var4, C var5);

    protected abstract BoundingBox getBoundingBox(C var1, V var2);
}

