/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.vein;

import com.mojang.serialization.Codec;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.feature.vein.PipeVeinConfig;
import net.dries007.tfc.world.feature.vein.Vein;
import net.dries007.tfc.world.feature.vein.VeinFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class PipeVeinFeature
extends VeinFeature<PipeVeinConfig, PipeVein> {
    public PipeVeinFeature(Codec<PipeVeinConfig> codec) {
        super(codec);
    }

    @Override
    protected float getChanceToGenerate(int x, int y, int z, PipeVein vein, PipeVeinConfig config) {
        double yScaled = (double)y / (double)config.getSize();
        x = (int)((double)x + (double)((float)vein.skew * vein.skewX) * yScaled);
        z = (int)((double)z + (double)((float)vein.skew * vein.skewZ) * yScaled);
        double yFactor = (double)vein.sign * yScaled + 0.5;
        double trueRadius = (double)config.getRadius() * (1.0 - yFactor) + (double)(config.getRadius() - vein.slant) * yFactor;
        if (Math.abs(y) < config.getSize() && (double)(x * x + z * z) < trueRadius * trueRadius) {
            return config.getDensity();
        }
        return 0.0f;
    }

    @Override
    protected PipeVein createVein(WorldGenerationContext context, int chunkX, int chunkZ, RandomSource random, PipeVeinConfig config) {
        return new PipeVein(this.defaultPos(context, chunkX, chunkZ, random, config), random, config);
    }

    @Override
    protected BoundingBox getBoundingBox(PipeVeinConfig config, PipeVein vein) {
        int radius = config.getRadius();
        int skew = vein.skew;
        return new BoundingBox(-radius - skew, -config.getSize(), -radius - skew, radius + skew, config.getSize(), radius + skew);
    }

    static class PipeVein
    extends Vein {
        final int sign;
        final float skewX;
        final float skewZ;
        final int skew;
        final int slant;

        PipeVein(BlockPos pos, RandomSource random, PipeVeinConfig config) {
            super(pos);
            this.sign = config.getSign() < random.nextFloat() ? 1 : -1;
            float angle = random.nextFloat() * (float)Math.PI * 2.0f;
            this.skewX = Mth.m_14089_((float)angle);
            this.skewZ = Mth.m_14031_((float)angle);
            this.skew = Helpers.uniform(random, config.getMinSkew(), 1 + config.getMaxSkew());
            this.slant = Helpers.uniform(random, config.getMinSlant(), 1 + config.getMaxSlant());
        }
    }
}

