/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.tree;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.dries007.tfc.util.collections.IWeighted;
import net.dries007.tfc.world.Codecs;
import net.dries007.tfc.world.chunkdata.ForestType;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public record ForestConfig(HolderSet<ConfiguredFeature<?, ?>> entries, Map<ForestType, Type> typeMap, boolean useWeirdness) implements FeatureConfiguration
{
    public static final Codec<ForestConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.m_203982_((Codec)ConfiguredFeature.f_65375_).fieldOf("entries").forGetter(c -> c.entries), (App)Codec.unboundedMap(ForestType.CODEC, Type.CODEC).fieldOf("types").forGetter(c -> c.typeMap), (App)Codec.BOOL.fieldOf("use_weirdness").orElse((Object)true).forGetter(c -> c.useWeirdness)).apply((Applicative)instance, ForestConfig::new));

    public record Type(IntProvider treeCount, IntProvider groundcoverCount, float perChunkChance, Optional<IntProvider> bushCount, boolean hasSpoilers, boolean allowOldGrowth) {
        public static final Codec<Type> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IntProvider.f_146531_.fieldOf("tree_count").orElse((Object)UniformInt.m_146622_((int)0, (int)0)).forGetter(c -> c.treeCount), (App)IntProvider.f_146531_.fieldOf("groundcover_count").orElse((Object)UniformInt.m_146622_((int)0, (int)0)).forGetter(c -> c.groundcoverCount), (App)Codec.FLOAT.fieldOf("per_chunk_chance").orElse((Object)Float.valueOf(1.0f)).forGetter(c -> Float.valueOf(c.perChunkChance)), (App)IntProvider.f_146531_.optionalFieldOf("bush_count").forGetter(c -> c.bushCount), (App)Codec.BOOL.fieldOf("has_spoiler_old_growth").orElse((Object)false).forGetter(c -> c.hasSpoilers), (App)Codec.BOOL.fieldOf("allows_old_growth").orElse((Object)false).forGetter(c -> c.allowOldGrowth)).apply((Applicative)instance, Type::new));

        public int sampleBushCount(Random random, Optional<IntProvider> count, int treeCount, float density) {
            return count.map(sampler -> sampler.m_142270_(random)).orElse((int)((float)treeCount * density));
        }
    }

    public record Entry(float minRainfall, float maxRainfall, float minAverageTemp, float maxAverageTemp, Optional<BlockState> bushLog, Optional<BlockState> bushLeaves, Optional<BlockState> fallenLog, Optional<IWeighted<BlockState>> groundcover, Holder<ConfiguredFeature<?, ?>> treeFeature, Holder<ConfiguredFeature<?, ?>> deadFeature, Optional<Holder<ConfiguredFeature<?, ?>>> oldGrowthFeature, int oldGrowthChance, int spoilerOldGrowthChance, int fallenChance, int deadChance) implements FeatureConfiguration
    {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("min_rain").forGetter(c -> Float.valueOf(c.minRainfall)), (App)Codec.FLOAT.fieldOf("max_rain").forGetter(c -> Float.valueOf(c.maxRainfall)), (App)Codec.FLOAT.fieldOf("min_temp").forGetter(c -> Float.valueOf(c.minAverageTemp)), (App)Codec.FLOAT.fieldOf("max_temp").forGetter(c -> Float.valueOf(c.maxAverageTemp)), (App)Codecs.BLOCK_STATE.optionalFieldOf("bush_log").forGetter(c -> c.bushLog), (App)Codecs.BLOCK_STATE.optionalFieldOf("bush_leaves").forGetter(c -> c.bushLeaves), (App)Codecs.BLOCK_STATE.optionalFieldOf("fallen_log").forGetter(c -> c.fallenLog), (App)Codecs.weightedCodec(Codecs.BLOCK_STATE, "block").optionalFieldOf("groundcover").forGetter(c -> c.groundcover), (App)ConfiguredFeature.f_65374_.fieldOf("normal_tree").forGetter(c -> c.treeFeature), (App)ConfiguredFeature.f_65374_.fieldOf("dead_tree").forGetter(c -> c.deadFeature), (App)ConfiguredFeature.f_65374_.optionalFieldOf("old_growth_tree").forGetter(c -> c.oldGrowthFeature), (App)Codec.INT.fieldOf("old_growth_chance").orElse((Object)6).forGetter(c -> c.oldGrowthChance), (App)Codec.INT.fieldOf("spoiler_old_growth_chance").orElse((Object)200).forGetter(c -> c.spoilerOldGrowthChance), (App)Codec.INT.fieldOf("fallen_tree_chance").orElse((Object)14).forGetter(c -> c.fallenChance), (App)Codec.INT.fieldOf("dead_chance").orElse((Object)75).forGetter(c -> c.deadChance)).apply((Applicative)instance, Entry::new));

        public boolean isValid(float temperature, float rainfall) {
            return rainfall >= this.minRainfall && rainfall <= this.maxRainfall && temperature >= this.minAverageTemp && temperature <= this.maxAverageTemp;
        }

        public float distanceFromMean(float temperature, float rainfall) {
            return (rainfall + temperature - this.getAverageTemp() - this.getAverageRain()) / 2.0f;
        }

        public float getAverageTemp() {
            return (this.maxAverageTemp - this.minAverageTemp) / 2.0f;
        }

        public float getAverageRain() {
            return (this.maxRainfall - this.minRainfall) / 2.0f;
        }

        public ConfiguredFeature<?, ?> getFeature() {
            return (ConfiguredFeature)this.treeFeature.m_203334_();
        }

        public ConfiguredFeature<?, ?> getDeadFeature() {
            return (ConfiguredFeature)this.deadFeature.m_203334_();
        }

        public ConfiguredFeature<?, ?> getOldGrowthFeature() {
            return (ConfiguredFeature)this.oldGrowthFeature.orElse(this.treeFeature).m_203334_();
        }
    }
}

