/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.cave;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.dries007.tfc.world.feature.cave.CaveSpikesFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class LargeCaveSpikesFeature
extends CaveSpikesFeature {
    public LargeCaveSpikesFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    @Override
    public void place(WorldGenLevel level, BlockPos pos, BlockState spike, BlockState raw, Direction direction, Random random) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int height = 6 + random.nextInt(11);
        int radius = 2 + random.nextInt(1);
        int maxHeightReached = 0;
        for (int y = -3; y <= height; ++y) {
            float radiusSquared = (float)radius * (1.0f - 1.5f * (float)Math.abs(y) / (float)height);
            if (radiusSquared < 0.0f) continue;
            radiusSquared *= radiusSquared;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    mutablePos.m_122190_((Vec3i)pos).m_122184_(x, y * direction.m_122430_(), z);
                    float actualRadius = (float)(x * x + z * z) / radiusSquared;
                    if ((double)actualRadius < 0.7) {
                        this.replaceBlockWithoutFluid(level, (BlockPos)mutablePos, raw);
                        if (x != 0 || z != 0) continue;
                        maxHeightReached = y;
                        continue;
                    }
                    if ((double)actualRadius < 0.85 && random.nextBoolean()) {
                        if (level.m_8055_(mutablePos.m_142082_(0, -direction.m_122430_(), 0)) != raw) continue;
                        this.replaceBlockWithoutFluid(level, (BlockPos)mutablePos, raw);
                        continue;
                    }
                    if (!(actualRadius < 1.0f) || random.nextInt(3) != 0 || y <= 0) continue;
                    this.placeSmallSpike(level, (BlockPos)mutablePos, spike, raw, direction, random);
                }
            }
        }
        mutablePos.m_122190_((Vec3i)pos).m_122175_(direction, maxHeightReached - 1);
        this.placeSmallSpike(level, (BlockPos)mutablePos, spike, raw, direction, random, 1.0f);
    }
}

