/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import net.dries007.tfc.util.Helpers;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.apache.commons.lang3.mutable.MutableInt;

public final class FeatureCycleDetector {
    public static List<BiomeSource.StepFeatureData> buildFeaturesPerStep(List<Holder<Biome>> allBiomes) {
        Reference2IntOpenHashMap featureToIntIdMap = new Reference2IntOpenHashMap();
        Reference2IntOpenHashMap biomeToIntIdMap = new Reference2IntOpenHashMap();
        MutableInt nextFeatureId = new MutableInt(0);
        MutableInt nextBiomeId = new MutableInt(0);
        Comparator<FeatureData> compareByStepThenByIndex = Comparator.comparingInt(FeatureData::step).thenComparingInt(FeatureData::featureId);
        TreeMap<FeatureData, Set<FeatureData>> nodesToChildren = new TreeMap<FeatureData, Set<FeatureData>>(compareByStepThenByIndex);
        int maxSteps = 0;
        HashMap<FeatureData, Map<BiomeData, IntSet>> nodesToTracebacks = new HashMap<FeatureData, Map<BiomeData, IntSet>>();
        for (Holder<Biome> biomeHolder : allBiomes) {
            Biome biome = (Biome)biomeHolder.m_203334_();
            ArrayList<FeatureData> flatDataList = new ArrayList<FeatureData>();
            List<HolderSet<PlacedFeature>> features = Helpers.flattenTopLevelMultipleFeature(biome.m_47536_());
            maxSteps = Math.max(maxSteps, features.size());
            for (int stepIndex = 0; stepIndex < features.size(); ++stepIndex) {
                int biomeIndex = 0;
                for (Holder featureHolder : (HolderSet)features.get(stepIndex)) {
                    PlacedFeature feature = (PlacedFeature)featureHolder.m_203334_();
                    FeatureData featureIdentity = new FeatureData(FeatureCycleDetector.idFor(feature, featureToIntIdMap, nextFeatureId), stepIndex, feature, (Holder<PlacedFeature>)featureHolder);
                    flatDataList.add(featureIdentity);
                    BiomeData biomeIdentity = new BiomeData(FeatureCycleDetector.idFor(biome, biomeToIntIdMap, nextBiomeId), biome, biomeHolder);
                    nodesToTracebacks.computeIfAbsent(featureIdentity, key -> new HashMap(1)).computeIfAbsent(biomeIdentity, key -> new IntOpenHashSet()).add(biomeIndex);
                    ++biomeIndex;
                }
            }
            for (int featureIndex = 0; featureIndex < flatDataList.size(); ++featureIndex) {
                Set children = nodesToChildren.computeIfAbsent((FeatureData)flatDataList.get(featureIndex), key -> new TreeSet(compareByStepThenByIndex));
                if (featureIndex >= flatDataList.size() - 1) continue;
                children.add((FeatureData)flatDataList.get(featureIndex + 1));
            }
        }
        TreeSet<FeatureData> nonCyclicalNodes = new TreeSet<FeatureData>(compareByStepThenByIndex);
        TreeSet<FeatureData> inProgress = new TreeSet<FeatureData>(compareByStepThenByIndex);
        ArrayList sortedFeatureData = new ArrayList();
        List<FeatureData> featureCycle = new ArrayList<FeatureData>();
        for (FeatureData node : nodesToChildren.keySet()) {
            if (!inProgress.isEmpty()) {
                throw new IllegalStateException("You somehow broke the universe; DFS bork (iteration finished with non-empty in-progress vertex set");
            }
            if (nonCyclicalNodes.contains(node)) continue;
            if (!FeatureCycleDetector.depthFirstSearch(nodesToChildren, nonCyclicalNodes, inProgress, sortedFeatureData::add, featureCycle::add, node)) continue;
            if (featureCycle.size() <= 1) {
                throw new IllegalStateException("There was a feature cycle that involved 0 or 1 feature??");
            }
            FeatureData loop = (FeatureData)featureCycle.get(0);
            for (int i = 1; i < featureCycle.size(); ++i) {
                if (!((FeatureData)featureCycle.get(i)).equals(loop)) continue;
                featureCycle = featureCycle.subList(0, i + 1);
                break;
            }
            Collections.reverse(featureCycle);
            throw new FeatureCycleException(nodesToTracebacks, featureCycle);
        }
        Collections.reverse(sortedFeatureData);
        ImmutableList.Builder featuresPerStepData = ImmutableList.builder();
        for (int stepIndex = 0; stepIndex < maxSteps; ++stepIndex) {
            int finalStepIndex = stepIndex;
            List featuresAtStep = sortedFeatureData.stream().filter(arg -> arg.step() == finalStepIndex).map(FeatureData::feature).collect(Collectors.toList());
            int totalIndex = featuresAtStep.size();
            Object2IntOpenCustomHashMap featureToIndexMapping = new Object2IntOpenCustomHashMap(totalIndex, Util.m_137583_());
            for (int index = 0; index < totalIndex; ++index) {
                featureToIndexMapping.put((Object)((PlacedFeature)featuresAtStep.get(index)), index);
            }
            featuresPerStepData.add((Object)new BiomeSource.StepFeatureData(featuresAtStep, (ToIntFunction)featureToIndexMapping));
        }
        return featuresPerStepData.build();
    }

    public static boolean depthFirstSearch(Map<FeatureData, Set<FeatureData>> edges, Set<FeatureData> nonCyclicalNodes, Set<FeatureData> pathSet, Consumer<FeatureData> onNonCyclicalNodeFound, Consumer<FeatureData> onCyclicalNodeFound, FeatureData start) {
        if (nonCyclicalNodes.contains(start)) {
            return false;
        }
        if (pathSet.contains(start)) {
            onCyclicalNodeFound.accept(start);
            return true;
        }
        pathSet.add(start);
        for (FeatureData next : edges.getOrDefault(start, (Set<FeatureData>)ImmutableSet.of())) {
            if (!FeatureCycleDetector.depthFirstSearch(edges, nonCyclicalNodes, pathSet, onNonCyclicalNodeFound, onCyclicalNodeFound, next)) continue;
            onCyclicalNodeFound.accept(start);
            return true;
        }
        pathSet.remove(start);
        nonCyclicalNodes.add(start);
        onNonCyclicalNodeFound.accept(start);
        return false;
    }

    private static <T> int idFor(T object, Reference2IntMap<T> objectToIntIdMap, MutableInt nextId) {
        return objectToIntIdMap.computeIfAbsent(object, key -> nextId.getAndIncrement());
    }

    private static String buildErrorMessage(Map<FeatureData, Map<BiomeData, IntSet>> tracebacks, List<FeatureData> cycle) {
        StringBuilder error = new StringBuilder("A feature cycle was found.\n\nCycle:\n");
        ListIterator<FeatureData> iterator = cycle.listIterator();
        FeatureData start = iterator.next();
        Map<BiomeData, IntSet> prevTracebacks = tracebacks.get(start);
        error.append("At step ").append(start.step).append('\n').append("Feature '").append(start.name()).append("'\n");
        while (iterator.hasNext()) {
            FeatureData current = iterator.next();
            Map<BiomeData, IntSet> currentTracebacks = tracebacks.get(current);
            int found = 0;
            for (BiomeData biome : Sets.intersection(prevTracebacks.keySet(), currentTracebacks.keySet())) {
                int currTb;
                int prevTb = prevTracebacks.get(biome).intStream().min().orElseThrow();
                if (prevTb >= (currTb = currentTracebacks.get(biome).intStream().max().orElseThrow())) continue;
                if (found == 0) {
                    error.append("  must be before '").append(current.name()).append("' (defined in '").append(biome.name()).append("' at index ").append(prevTb).append(", ").append(currTb);
                }
                ++found;
            }
            if (found > 1) {
                error.append(" and ").append(found - 1).append(" others)\n");
            } else if (found > 0) {
                error.append(")\n");
            }
            prevTracebacks = currentTracebacks;
        }
        return error.toString();
    }

    record FeatureData(int featureId, int step, PlacedFeature feature, Holder<PlacedFeature> source) {
        String name() {
            return (String)this.source.m_203439_().map(e -> e.m_135782_().toString(), e -> "[Inline feature: " + this.feature + "]");
        }
    }

    record BiomeData(int biomeId, Biome biome, Holder<Biome> source) {
        String name() {
            return (String)this.source.m_203439_().map(e -> e.m_135782_().toString(), e -> "[Inline biome: " + this.biome + "]");
        }
    }

    static class FeatureCycleException
    extends RuntimeException {
        public FeatureCycleException(Map<FeatureData, Map<BiomeData, IntSet>> tracebacks, List<FeatureData> cycle) {
            super(FeatureCycleDetector.buildErrorMessage(tracebacks, cycle));
        }
    }
}

