/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.loot.TFCLoot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.Nullable;

public class CopyFluidFunction
extends LootItemConditionalFunction {
    public static ItemStack copyToItem(ItemStack stack, @Nullable BlockEntity entity) {
        return CopyFluidFunction.copy(stack, entity, true);
    }

    public static ItemStack copyFromItem(ItemStack stack, @Nullable BlockEntity entity) {
        return CopyFluidFunction.copy(stack, entity, false);
    }

    private static ItemStack copy(ItemStack stack, @Nullable BlockEntity entity, boolean toItem) {
        if (entity != null && !stack.m_41619_()) {
            IFluidHandlerItem itemHandler = Helpers.getCapability((ICapabilityProvider)stack, Capabilities.FLUID_ITEM);
            IFluidHandler blockHandler = Helpers.getCapability((ICapabilityProvider)entity, Capabilities.FLUID);
            if (itemHandler != null && blockHandler != null) {
                IFluidHandler fromHandler = toItem ? blockHandler : itemHandler;
                IFluidHandlerItem toHandler = toItem ? itemHandler : blockHandler;
                toHandler.fill(fromHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                return itemHandler.getContainer();
            }
        }
        return stack;
    }

    public CopyFluidFunction(LootItemCondition[] conditions) {
        super(conditions);
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)TFCLoot.COPY_FLUID.get();
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        if (context.m_78936_(LootContextParams.f_81462_)) {
            return CopyFluidFunction.copyToItem(stack, (BlockEntity)context.m_165124_(LootContextParams.f_81462_));
        }
        return stack;
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<CopyFluidFunction> {
        public CopyFluidFunction deserialize(JsonObject json, JsonDeserializationContext context, LootItemCondition[] conditions) {
            return new CopyFluidFunction(conditions);
        }
    }
}

