/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.climate;

import net.dries007.tfc.util.climate.ClimateModelType;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkAccess;

public interface ClimateModel {
    public static final float MINIMUM_RAINFALL = 0.0f;
    public static final float MAXIMUM_RAINFALL = 500.0f;

    public ClimateModelType type();

    public float getTemperature(LevelReader var1, BlockPos var2, long var3, int var5);

    public float getAverageTemperature(LevelReader var1, BlockPos var2);

    public float getRainfall(LevelReader var1, BlockPos var2);

    default public float getFogginess(LevelReader level, BlockPos pos, long calendarTime) {
        return 0.0f;
    }

    default public float getWaterFogginess(LevelReader level, BlockPos pos, long calendarTime) {
        return 1.0f;
    }

    default public void onChunkLoad(WorldGenLevel level, ChunkAccess chunk, ChunkData chunkData) {
    }

    default public void onWorldLoad(ServerLevel level) {
    }

    default public void onSyncToClient(FriendlyByteBuf buffer) {
    }

    default public void onReceiveOnClient(FriendlyByteBuf buffer) {
    }
}

