/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.climate;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.function.Supplier;
import net.dries007.tfc.mixin.accessor.BiomeAccessor;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.dries007.tfc.util.climate.ClimateModel;
import net.dries007.tfc.util.climate.ClimateModelType;
import net.dries007.tfc.util.climate.ClimateModels;
import net.dries007.tfc.util.climate.WorldGenClimateModel;
import net.dries007.tfc.util.events.SelectClimateModelEvent;
import net.dries007.tfc.util.tracker.WorldTracker;
import net.dries007.tfc.util.tracker.WorldTrackerCapability;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.ChunkDataProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public final class Climate {
    private static final BiMap<ResourceLocation, ClimateModelType> REGISTRY = HashBiMap.create();

    public static synchronized ClimateModelType register(ResourceLocation id, Supplier<ClimateModel> model) {
        ClimateModelType type = new ClimateModelType(model, id);
        REGISTRY.put((Object)id, (Object)type);
        return type;
    }

    public static ClimateModel create(ResourceLocation id) {
        return ((ClimateModelType)REGISTRY.getOrDefault((Object)id, (Object)ClimateModels.BIOME_BASED.get())).create();
    }

    public static ResourceLocation getId(ClimateModel model) {
        return (ResourceLocation)REGISTRY.inverse().getOrDefault((Object)model.type(), (Object)ClimateModels.BIOME_BASED.get().id());
    }

    public static float getTemperature(Level level, BlockPos pos, long calendarTick, int daysInMonth) {
        return Climate.model(level).getTemperature((LevelReader)level, pos, calendarTick, daysInMonth);
    }

    public static float getTemperature(Level level, BlockPos pos, ICalendar calendar, long calendarTick) {
        return Climate.model(level).getTemperature((LevelReader)level, pos, calendarTick, calendar.getCalendarDaysInMonth());
    }

    public static float getTemperature(Level level, BlockPos pos, ICalendar calendar) {
        return Climate.model(level).getTemperature((LevelReader)level, pos, calendar.getCalendarTicks(), calendar.getCalendarDaysInMonth());
    }

    public static float getTemperature(Level level, BlockPos pos) {
        return Climate.getTemperature(level, pos, Calendars.get((LevelReader)level));
    }

    public static float getAverageTemperature(Level level, BlockPos pos) {
        return Climate.model(level).getAverageTemperature((LevelReader)level, pos);
    }

    public static float getRainfall(Level level, BlockPos pos) {
        return Climate.model(level).getRainfall((LevelReader)level, pos);
    }

    public static float getFogginess(Level level, BlockPos pos) {
        return Climate.model(level).getFogginess((LevelReader)level, pos, Calendars.get((LevelReader)level).getTicks());
    }

    public static float getWaterFogginess(Level level, BlockPos pos) {
        return Climate.model(level).getWaterFogginess((LevelReader)level, pos, Calendars.get((LevelReader)level).getTicks());
    }

    public static boolean warmEnoughToRain(Level level, BlockPos pos) {
        return Climate.getVanillaBiomeTemperature(level, pos) >= 0.15f;
    }

    public static boolean warmEnoughToRain(LevelReader level, BlockPos pos, Biome fallback) {
        return Climate.getVanillaBiomeTemperatureSafely(level, pos, fallback) >= 0.15f;
    }

    public static void onChunkLoad(WorldGenLevel level, ChunkAccess chunk, ChunkData chunkData) {
        Climate.model((Level)level.m_6018_()).onChunkLoad(level, chunk, chunkData);
    }

    public static void onWorldLoad(ServerLevel level) {
        SelectClimateModelEvent event = new SelectClimateModelEvent(level);
        MinecraftForge.EVENT_BUS.post((Event)event);
        level.getCapability(WorldTrackerCapability.CAPABILITY).ifPresent(c -> c.setClimateModel(event.getModel()));
        Climate.model((Level)level).onWorldLoad(level);
    }

    public static float toVanillaTemperature(float actualTemperature) {
        return actualTemperature * 0.0217f + 0.15f;
    }

    public static float toActualTemperature(float vanillaTemperature) {
        return (vanillaTemperature - 0.15f) / 0.0217f;
    }

    public static float getVanillaBiomeTemperature(Level level, BlockPos pos) {
        return Climate.toVanillaTemperature(Climate.getTemperature(level, pos, Calendars.get((LevelReader)level)));
    }

    public static float getVanillaBiomeTemperatureSafely(LevelReader maybeLevel, BlockPos pos, Biome fallback) {
        Level unsafeLevel = Helpers.getUnsafeLevel(maybeLevel);
        if (unsafeLevel != null) {
            ICalendar calendar = Calendars.get(maybeLevel);
            ClimateModel model = Climate.model(unsafeLevel);
            if (maybeLevel instanceof WorldGenRegion) {
                WorldGenRegion worldGenLevel = (WorldGenRegion)maybeLevel;
                if (model instanceof WorldGenClimateModel) {
                    WorldGenClimateModel worldGenModel = (WorldGenClimateModel)model;
                    ChunkData data = ChunkDataProvider.get((WorldGenLevel)worldGenLevel).get(worldGenLevel.m_46865_(pos));
                    return Climate.toVanillaTemperature(worldGenModel.getTemperature((LevelReader)worldGenLevel, pos, data, calendar.getCalendarTicks(), calendar.getCalendarDaysInMonth()));
                }
            } else {
                return Climate.toVanillaTemperature(model.getTemperature(maybeLevel, pos, calendar.getCalendarTicks(), calendar.getCalendarDaysInMonth()));
            }
        }
        return ((BiomeAccessor)fallback).invoke$getTemperature(pos);
    }

    public static ClimateModel model(Level level) {
        return level.getCapability(WorldTrackerCapability.CAPABILITY).map(WorldTracker::getClimateModel).orElse(ClimateModels.BIOME_BASED.get().create());
    }
}

