/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class AxeLoggingHelper {
    private static final BooleanProperty NATURAL = TFCBlockStateProperties.NATURAL;

    public static void doLogging(LevelAccessor level, BlockPos pos, Player player, ItemStack axe) {
        boolean inefficient = Helpers.isItem(axe, TFCTags.Items.INEFFICIENT_LOGGING_AXES);
        for (BlockPos log : AxeLoggingHelper.findLogs(level, pos)) {
            level.m_46953_(log, !inefficient || level.m_5822_().nextFloat() < 0.6f, (Entity)player);
            axe.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
            if (!axe.m_41619_()) continue;
            return;
        }
    }

    public static List<BlockPos> findLogs(LevelAccessor level, BlockPos pos) {
        HashSet<BlockPos> seen = new HashSet<BlockPos>(64);
        ArrayList<BlockPos> logs = new ArrayList<BlockPos>(16);
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        logs.add(pos);
        for (int i = 0; i < logs.size(); ++i) {
            BlockPos log = (BlockPos)logs.get(i);
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        cursor.m_122154_((Vec3i)log, dx, dy, dz);
                        if (seen.contains(cursor)) continue;
                        BlockPos cursorPos = cursor.m_7949_();
                        seen.add(cursorPos);
                        if (!AxeLoggingHelper.isLoggingBlock(level.m_8055_(cursorPos))) continue;
                        logs.add(cursorPos);
                    }
                }
            }
        }
        logs.sort(Comparator.comparing(x -> -x.m_123331_((Vec3i)pos)));
        return logs;
    }

    public static boolean isLoggingAxe(ItemStack stack) {
        return Helpers.isItem(stack.m_41720_(), TFCTags.Items.AXES_THAT_LOG);
    }

    public static boolean isLoggingBlock(BlockState state) {
        return Helpers.isBlock(state.m_60734_(), TFCTags.Blocks.LOGS_THAT_LOG) && (!state.m_61138_((Property)NATURAL) || (Boolean)state.m_61143_((Property)NATURAL) != false);
    }
}

