/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.size.ItemSizeManager;
import net.dries007.tfc.network.CalendarUpdatePacket;
import net.dries007.tfc.network.ChunkUnwatchPacket;
import net.dries007.tfc.network.ChunkWatchPacket;
import net.dries007.tfc.network.CycleChiselModePacket;
import net.dries007.tfc.network.DataManagerSyncPacket;
import net.dries007.tfc.network.EffectExpirePacket;
import net.dries007.tfc.network.FoodDataReplacePacket;
import net.dries007.tfc.network.FoodDataUpdatePacket;
import net.dries007.tfc.network.OpenFieldGuidePacket;
import net.dries007.tfc.network.PetCommandPacket;
import net.dries007.tfc.network.PlaceBlockSpecialPacket;
import net.dries007.tfc.network.PlayerDataUpdatePacket;
import net.dries007.tfc.network.PlayerDrinkPacket;
import net.dries007.tfc.network.PourFasterPacket;
import net.dries007.tfc.network.ProspectedPacket;
import net.dries007.tfc.network.RainfallUpdatePacket;
import net.dries007.tfc.network.RequestClimateModelPacket;
import net.dries007.tfc.network.ScreenButtonPacket;
import net.dries007.tfc.network.ScribingTablePacket;
import net.dries007.tfc.network.StackFoodPacket;
import net.dries007.tfc.network.SwitchInventoryTabPacket;
import net.dries007.tfc.network.UpdateClimateModelPacket;
import net.dries007.tfc.util.DataManager;
import net.dries007.tfc.util.Drinkable;
import net.dries007.tfc.util.Fertilizer;
import net.dries007.tfc.util.Fuel;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.ItemDamageResistance;
import net.dries007.tfc.util.LampFuel;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.Pannable;
import net.dries007.tfc.util.Sluiceable;
import net.dries007.tfc.util.Support;
import net.dries007.tfc.util.climate.ClimateRange;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.commons.lang3.mutable.MutableInt;

public final class PacketHandler {
    private static final String VERSION = "2.2.33";
    private static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)Helpers.identifier("network"), () -> "2.2.33", "2.2.33"::equals, "2.2.33"::equals);
    private static final MutableInt ID = new MutableInt(0);

    public static void send(PacketDistributor.PacketTarget target, Object message) {
        CHANNEL.send(target, message);
    }

    public static void init() {
        PacketHandler.register(ChunkWatchPacket.class, ChunkWatchPacket::encode, ChunkWatchPacket::new, ChunkWatchPacket::handle);
        PacketHandler.register(ChunkUnwatchPacket.class, ChunkUnwatchPacket::encode, ChunkUnwatchPacket::new, ChunkUnwatchPacket::handle);
        PacketHandler.register(CalendarUpdatePacket.class, CalendarUpdatePacket::encode, CalendarUpdatePacket::new, CalendarUpdatePacket::handle);
        PacketHandler.register(FoodDataReplacePacket.class, FoodDataReplacePacket::new, FoodDataReplacePacket::handle);
        PacketHandler.register(FoodDataUpdatePacket.class, FoodDataUpdatePacket::encode, FoodDataUpdatePacket::new, FoodDataUpdatePacket::handle);
        PacketHandler.register(PlayerDataUpdatePacket.class, PlayerDataUpdatePacket::encode, PlayerDataUpdatePacket::new, PlayerDataUpdatePacket::handle);
        PacketHandler.register(ProspectedPacket.class, ProspectedPacket::encode, ProspectedPacket::new, ProspectedPacket::handle);
        PacketHandler.register(EffectExpirePacket.class, EffectExpirePacket::encode, EffectExpirePacket::new, EffectExpirePacket::handle);
        PacketHandler.register(UpdateClimateModelPacket.class, UpdateClimateModelPacket::encode, UpdateClimateModelPacket::decode, UpdateClimateModelPacket::handle);
        PacketHandler.register(RainfallUpdatePacket.class, RainfallUpdatePacket::encode, RainfallUpdatePacket::new, RainfallUpdatePacket::handle);
        PacketHandler.registerDataManager(Metal.Packet.class, Metal.MANAGER);
        PacketHandler.registerDataManager(Fuel.Packet.class, Fuel.MANAGER);
        PacketHandler.registerDataManager(Fertilizer.Packet.class, Fertilizer.MANAGER);
        PacketHandler.registerDataManager(ItemDamageResistance.Packet.class, ItemDamageResistance.MANAGER);
        PacketHandler.registerDataManager(FoodCapability.Packet.class, FoodCapability.MANAGER);
        PacketHandler.registerDataManager(HeatCapability.Packet.class, HeatCapability.MANAGER);
        PacketHandler.registerDataManager(ItemSizeManager.Packet.class, ItemSizeManager.MANAGER);
        PacketHandler.registerDataManager(ClimateRange.Packet.class, ClimateRange.MANAGER);
        PacketHandler.registerDataManager(Drinkable.Packet.class, Drinkable.MANAGER);
        PacketHandler.registerDataManager(LampFuel.Packet.class, LampFuel.MANAGER);
        PacketHandler.registerDataManager(Pannable.Packet.class, Pannable.MANAGER);
        PacketHandler.registerDataManager(Sluiceable.Packet.class, Sluiceable.MANAGER);
        PacketHandler.registerDataManager(Support.Packet.class, Support.MANAGER);
        PacketHandler.register(SwitchInventoryTabPacket.class, SwitchInventoryTabPacket::encode, SwitchInventoryTabPacket::new, SwitchInventoryTabPacket::handle);
        PacketHandler.register(PlaceBlockSpecialPacket.class, PlaceBlockSpecialPacket::new, PlaceBlockSpecialPacket::handle);
        PacketHandler.register(CycleChiselModePacket.class, CycleChiselModePacket::new, CycleChiselModePacket::handle);
        PacketHandler.register(ScreenButtonPacket.class, ScreenButtonPacket::encode, ScreenButtonPacket::new, ScreenButtonPacket::handle);
        PacketHandler.register(PlayerDrinkPacket.class, PlayerDrinkPacket::new, PlayerDrinkPacket::handle);
        PacketHandler.register(RequestClimateModelPacket.class, RequestClimateModelPacket::new, RequestClimateModelPacket::handle);
        PacketHandler.register(ScribingTablePacket.class, ScribingTablePacket::encode, ScribingTablePacket::new, ScribingTablePacket::handle);
        PacketHandler.register(StackFoodPacket.class, StackFoodPacket::encode, StackFoodPacket::new, StackFoodPacket::handle);
        PacketHandler.register(OpenFieldGuidePacket.class, OpenFieldGuidePacket::encode, OpenFieldGuidePacket::new, OpenFieldGuidePacket::handle);
        PacketHandler.register(PetCommandPacket.class, PetCommandPacket::encode, PetCommandPacket::new, PetCommandPacket::handle);
        PacketHandler.register(PourFasterPacket.class, PourFasterPacket::encode, PourFasterPacket::new, PourFasterPacket::handle);
    }

    public static <T extends DataManagerSyncPacket<E>, E> void registerDataManager(Class<T> cls, DataManager<E> manager, SimpleChannel channel, int id) {
        channel.registerMessage(id, cls, (packet, buffer) -> packet.encode(manager, (FriendlyByteBuf)buffer), buffer -> {
            DataManagerSyncPacket packet = manager.createEmptyPacket();
            packet.decode(manager, (FriendlyByteBuf)buffer);
            return packet;
        }, (packet, context) -> {
            ((NetworkEvent.Context)context.get()).setPacketHandled(true);
            ((NetworkEvent.Context)context.get()).enqueueWork(() -> PacketHandler.lambda$registerDataManager$3(packet, (Supplier)context, manager));
        });
    }

    private static <T extends DataManagerSyncPacket<E>, E> void registerDataManager(Class<T> cls, DataManager<E> manager) {
        PacketHandler.registerDataManager(cls, manager, CHANNEL, ID.getAndIncrement());
    }

    private static <T> void register(Class<T> cls, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, NetworkEvent.Context> handler) {
        CHANNEL.registerMessage(ID.getAndIncrement(), cls, encoder, decoder, (packet, context) -> {
            ((NetworkEvent.Context)context.get()).setPacketHandled(true);
            handler.accept(packet, (NetworkEvent.Context)context.get());
        });
    }

    private static <T> void register(Class<T> cls, Supplier<T> factory, BiConsumer<T, NetworkEvent.Context> handler) {
        CHANNEL.registerMessage(ID.getAndIncrement(), cls, (packet, buffer) -> {}, buffer -> factory.get(), (packet, context) -> {
            ((NetworkEvent.Context)context.get()).setPacketHandled(true);
            handler.accept(packet, (NetworkEvent.Context)context.get());
        });
    }

    private static /* synthetic */ void lambda$registerDataManager$3(DataManagerSyncPacket packet, Supplier context, DataManager manager) {
        packet.handle((NetworkEvent.Context)context.get(), manager);
    }
}

