/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.patchouli.component;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.recipes.ingredients.FluidStackIngredient;
import net.dries007.tfc.common.recipes.ingredients.ItemStackIngredient;
import net.dries007.tfc.compat.patchouli.PatchouliIntegration;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.dries007.tfc.util.Tooltips;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;
import org.slf4j.Logger;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.page.PageMultiblock;
import vazkii.patchouli.common.multiblock.SerializedMultiblock;

public abstract class CustomComponent
implements ICustomComponent {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new Gson();
    private static final Field MULTIBLOCK_OBJ = (Field)Helpers.uncheck(() -> {
        Field field = PageMultiblock.class.getDeclaredField("multiblockObj");
        field.setAccessible(true);
        return field;
    });
    protected transient int x;
    protected transient int y;

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
    }

    public void build(int componentX, int componentY, int pageNum) {
        this.x = componentX;
        this.y = componentY;
    }

    public abstract void render(PoseStack var1, IComponentRenderContext var2, float var3, int var4, int var5);

    protected void renderSetup(PoseStack poseStack) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)this.x, (double)this.y, 0.0);
        RenderSystem.m_69478_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)PatchouliIntegration.TEXTURE);
    }

    protected void renderItemStacks(IComponentRenderContext context, PoseStack stack, int x, int y, int mouseX, int mouseY, List<ItemStack> stacks) {
        if (stacks.size() > 0) {
            context.renderItemStack(stack, x, y, mouseX, mouseY, stacks.get(context.getTicksInBook() / 20 % stacks.size()));
        }
    }

    protected void renderFluidStacks(IComponentRenderContext context, PoseStack stack, int x, int y, int mouseX, int mouseY, List<FluidStack> fluids) {
        if (fluids.size() > 0) {
            this.renderFluidStack(context, stack, x, y, mouseX, mouseY, fluids.get(context.getTicksInBook() / 20 % fluids.size()));
        }
    }

    protected void renderFluidStack(IComponentRenderContext context, PoseStack stack, int x, int y, int mouseX, int mouseY, FluidStack fluid) {
        if (!fluid.isEmpty()) {
            TextureAtlasSprite sprite = RenderHelpers.getAndBindFluidSprite(fluid);
            GuiComponent.m_93200_((PoseStack)stack, (int)x, (int)y, (int)0, (int)16, (int)16, (TextureAtlasSprite)sprite);
            if (context.isAreaHovered(mouseX, mouseY, x, y, 16, 16)) {
                ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>(1);
                tooltip.add(Tooltips.fluidUnitsOf(fluid));
                context.setHoverTooltipComponents(tooltip);
            }
        }
    }

    protected List<ItemStack> unpackItemStackIngredient(ItemStackIngredient ingredient) {
        return Arrays.stream(ingredient.ingredient().m_43908_()).map(stack -> Helpers.copyWithSize(stack, ingredient.count())).toList();
    }

    protected List<FluidStack> unpackFluidStackIngredient(FluidStackIngredient ingredient) {
        return ingredient.ingredient().getMatchingFluids().stream().map(fluid -> new FluidStack(fluid, ingredient.amount())).toList();
    }

    protected <T extends Recipe<?>> Optional<T> asRecipe(String variable, RecipeType<T> type) {
        return this.asResourceLocation(variable).flatMap(e -> ClientHelpers.getLevelOrThrow().m_7465_().m_44043_(e).flatMap(recipe -> {
            if (recipe.m_6671_() != type) {
                LOGGER.error("The recipe {} of type {} is not of type {}", new Object[]{e, Registry.f_122864_.m_7981_((Object)recipe.m_6671_()), type});
                return Optional.empty();
            }
            return Optional.of(recipe);
        }).or(() -> {
            LOGGER.error("No recipe of type {} named {} ", (Object)Registry.f_122864_.m_7981_((Object)type), e);
            return Optional.empty();
        }));
    }

    protected Optional<ResourceLocation> asResourceLocation(String variable) {
        try {
            return Optional.of(new ResourceLocation(variable));
        }
        catch (ResourceLocationException e) {
            LOGGER.error(e.getMessage());
            return Optional.empty();
        }
    }

    protected Optional<Supplier<IMultiblock>> asMultiblock(IVariable variable) {
        try {
            if (variable.unwrap().isJsonPrimitive()) {
                return this.asResourceLocation(JsonHelpers.m_13805_((JsonElement)variable.unwrap(), (String)"multiblock id")).flatMap(id -> {
                    IMultiblock multiblock = PatchouliAPI.get().getMultiblock(id);
                    if (multiblock != null) {
                        return Optional.of(() -> multiblock);
                    }
                    LOGGER.error("No multiblock by id: {}", id);
                    return Optional.empty();
                });
            }
            SerializedMultiblock serialized = (SerializedMultiblock)GSON.fromJson(variable.unwrap(), SerializedMultiblock.class);
            return Optional.of(() -> ((SerializedMultiblock)serialized).toMultiblock());
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Deserializing multiblock: ", (Throwable)e);
            return Optional.empty();
        }
    }

    protected Optional<MultiblockRenderer> asMultiblockRenderer(Supplier<IMultiblock> resolved) {
        try {
            IMultiblock multiblock = resolved.get();
            MultiblockRenderer stub = new MultiblockRenderer();
            MULTIBLOCK_OBJ.set((Object)stub, multiblock);
            return Optional.of(stub);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            LOGGER.error("Building multiblock: ", (Throwable)e);
            return Optional.empty();
        }
    }

    public static class MultiblockRenderer
    extends PageMultiblock {
        public void render(IComponentRenderContext context, PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
            if (context instanceof GuiBookEntry) {
                GuiBookEntry entry = (GuiBookEntry)context;
                this.mc = context.getGui().getMinecraft();
                this.parent = entry;
                this.book = entry.book;
                this.render(poseStack, mouseX, mouseY, partialTicks);
            }
        }

        public boolean shouldRenderText() {
            return false;
        }
    }
}

