/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.outputs;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.function.Supplier;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.recipes.outputs.CopyInputModifier;
import net.dries007.tfc.common.recipes.outputs.ItemStackModifier;
import net.dries007.tfc.common.recipes.outputs.ItemStackModifiers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.ShapedRecipe;

public record ItemStackProvider(Supplier<ItemStack> stack, ItemStackModifier[] modifiers) {
    private static final ItemStackModifier[] NONE = new ItemStackModifier[0];
    private static final ItemStackProvider EMPTY = new ItemStackProvider(ItemStack.f_41583_, NONE);
    private static final ItemStackProvider COPY_INPUT = new ItemStackProvider(ItemStack.f_41583_, new ItemStackModifier[]{CopyInputModifier.INSTANCE});

    public ItemStackProvider(ItemStack stack, ItemStackModifier[] modifiers) {
        this(FoodCapability.createNonDecayingStack(stack), modifiers);
    }

    public static ItemStackProvider empty() {
        return EMPTY;
    }

    public static ItemStackProvider copyInput() {
        return COPY_INPUT;
    }

    public static ItemStackProvider of(ItemStack stack, ItemStackModifier ... modifiers) {
        return new ItemStackProvider(stack, modifiers);
    }

    public static ItemStackProvider fromJson(JsonObject json) {
        ItemStackModifier[] modifiers;
        ItemStack stack;
        boolean hasStack = json.has("stack");
        boolean hasMods = json.has("modifiers");
        if (hasStack || hasMods) {
            ItemStack itemStack = stack = hasStack ? ShapedRecipe.m_151274_((JsonObject)JsonHelpers.m_13930_((JsonObject)json, (String)"stack")) : ItemStack.f_41583_;
            if (hasMods) {
                JsonArray modifiersJson = JsonHelpers.m_13933_((JsonObject)json, (String)"modifiers");
                modifiers = new ItemStackModifier[modifiersJson.size()];
                for (int i = 0; i < modifiers.length; ++i) {
                    modifiers[i] = ItemStackModifiers.fromJson(modifiersJson.get(i));
                }
            } else {
                modifiers = NONE;
            }
        } else {
            stack = ShapedRecipe.m_151274_((JsonObject)json);
            modifiers = NONE;
        }
        return new ItemStackProvider(stack, modifiers);
    }

    public static ItemStackProvider fromNetwork(FriendlyByteBuf buffer) {
        ItemStack stack = buffer.m_130267_();
        int count = buffer.m_130242_();
        if (count == 0) {
            return new ItemStackProvider(stack, NONE);
        }
        ItemStackModifier[] modifiers = new ItemStackModifier[count];
        for (int i = 0; i < count; ++i) {
            modifiers[i] = ItemStackModifiers.fromNetwork(buffer);
        }
        return new ItemStackProvider(stack, modifiers);
    }

    public ItemStack getSingleStack(ItemStack input) {
        return this.getStack(Helpers.copyWithSize(input, 1));
    }

    public ItemStack getEmptyStack() {
        return this.getStack(ItemStack.f_41583_);
    }

    public ItemStack getStack(ItemStack input) {
        ItemStack output = this.stack.get().m_41777_();
        for (ItemStackModifier modifier : this.modifiers) {
            output = modifier.apply(output, input);
        }
        return output;
    }

    public boolean dependsOnInput() {
        for (ItemStackModifier modifier : this.modifiers) {
            if (!modifier.dependsOnInput()) continue;
            return true;
        }
        return false;
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.stack.get());
        buffer.m_130130_(this.modifiers.length);
        for (ItemStackModifier modifier : this.modifiers) {
            modifier.toNetwork(buffer);
        }
    }
}

