/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.ingredients;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Predicate;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public record ItemStackIngredient(Ingredient ingredient, int count) implements Predicate<ItemStack>
{
    public static final ItemStackIngredient EMPTY = new ItemStackIngredient(Ingredient.f_43901_, 0);

    public static ItemStackIngredient fromJson(JsonObject json) {
        Ingredient ingredient = Ingredient.m_43917_((JsonElement)JsonHelpers.get(json, "ingredient"));
        int count = JsonHelpers.m_13824_((JsonObject)json, (String)"count", (int)1);
        return new ItemStackIngredient(ingredient, count);
    }

    public static ItemStackIngredient fromNetwork(FriendlyByteBuf buffer) {
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        int count = buffer.m_130242_();
        return new ItemStackIngredient(ingredient, count);
    }

    @Override
    public boolean test(ItemStack stack) {
        return this.ingredient.test(stack) && stack.m_41613_() >= this.count;
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        this.ingredient.m_43923_(buffer);
        buffer.m_130130_(this.count);
    }
}

