/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import java.util.function.Supplier;
import net.dries007.tfc.common.entities.TFCMinecartChest;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;

public class TFCMinecartItem
extends Item {
    private final Supplier<? extends EntityType<?>> entityType;
    private final Supplier<? extends Item> containedItem;

    public TFCMinecartItem(Item.Properties properties, Supplier<? extends EntityType<?>> entityType, Supplier<? extends Item> containedItem) {
        super(properties);
        this.entityType = entityType;
        this.containedItem = containedItem;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos;
        Level level = context.m_43725_();
        BlockState state = level.m_8055_(pos = context.m_8083_());
        if (!Helpers.isBlock(state, (TagKey<Block>)BlockTags.f_13034_)) {
            return InteractionResult.FAIL;
        }
        ItemStack held = context.m_43722_();
        if (!level.f_46443_) {
            double z;
            double y;
            double x;
            RailShape railshape = state.m_60734_() instanceof BaseRailBlock ? ((BaseRailBlock)state.m_60734_()).getRailDirection(state, (BlockGetter)level, pos, null) : RailShape.NORTH_SOUTH;
            double offset = 0.0;
            if (railshape.m_61745_()) {
                offset = 0.5;
            }
            if (this.createMinecartEntity(level, held, x = (double)pos.m_123341_() + 0.5, y = (double)pos.m_123342_() + 0.0625 + offset, z = (double)pos.m_123343_() + 0.5)) {
                level.m_142346_((Entity)context.m_43723_(), GameEvent.f_157810_, pos);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public boolean createMinecartEntity(Level level, ItemStack stack, double x, double y, double z) {
        Entity entity = this.entityType.get().m_20615_(level);
        if (entity != null) {
            entity.m_6034_(x, y, z);
            entity.f_19854_ = x;
            entity.f_19855_ = y;
            entity.f_19856_ = z;
            if (stack.m_41788_()) {
                entity.m_6593_(stack.m_41786_());
            }
            this.beforeEntityAdded(level, stack, entity);
            level.m_7967_(entity);
            stack.m_41774_(1);
            return true;
        }
        return false;
    }

    public void beforeEntityAdded(Level level, ItemStack stack, Entity entity) {
        if (entity instanceof TFCMinecartChest) {
            TFCMinecartChest chest = (TFCMinecartChest)entity;
            chest.setPickResult(stack);
            chest.setChestItem(new ItemStack((ItemLike)this.containedItem.get()));
        }
    }
}

