/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.prey;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.dries007.tfc.common.entities.ai.FastGateBehavior;
import net.dries007.tfc.common.entities.ai.prey.AvoidPredatorBehavior;
import net.dries007.tfc.common.entities.prey.Prey;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunSometimes;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public class PreyAi {
    public static final int AVOID_RANGE = 400;
    private static final UniformInt RETREAT_DURATION = TimeUtil.m_145020_((int)7, (int)22);
    public static final ImmutableList<SensorType<? extends Sensor<? super Prey>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26812_, (Object)SensorType.f_26814_);
    public static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26383_, (Object)MemoryModuleType.f_26331_);

    public static Brain<?> makeBrain(Brain<? extends Prey> brain) {
        PreyAi.initCoreActivity(brain);
        PreyAi.initIdleActivity(brain);
        PreyAi.initRetreatActivity(brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    public static void initCoreActivity(Brain<? extends Prey> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new Swim(0.7f), (Object)new AnimalPanic(2.0f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink()));
    }

    public static void initIdleActivity(Brain<? extends Prey> brain) {
        brain.m_21900_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)new RunSometimes((Behavior)new SetEntityLookTarget(EntityType.f_20532_, 6.0f), UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)((Object)new AvoidPredatorBehavior(false))), (Object)Pair.of((Object)2, (Object)new BabyFollowAdult(UniformInt.m_146622_((int)5, (int)16), 1.25f)), (Object)Pair.of((Object)3, PreyAi.createIdleMovementBehaviors())));
    }

    public static void initRetreatActivity(Brain<? extends Prey> brain) {
        brain.m_21895_(Activity.f_37991_, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.m_24019_((MemoryModuleType)MemoryModuleType.f_26383_, (float)1.1f, (int)15, (boolean)false), PreyAi.createIdleMovementBehaviors(), (Object)new RunSometimes((Behavior)new SetEntityLookTarget(8.0f), UniformInt.m_146622_((int)30, (int)60)), (Object)new EraseMemoryIf(PreyAi::wantsToStopFleeing, MemoryModuleType.f_26383_)), MemoryModuleType.f_26383_);
    }

    public static FastGateBehavior<Prey> createIdleMovementBehaviors() {
        return FastGateBehavior.runOne(ImmutableList.of((Object)new RandomStroll(1.0f), (Object)new SetWalkTargetFromLookTarget(1.0f, 3), (Object)new DoNothing(30, 60)));
    }

    public static void updateActivity(Prey prey) {
        prey.m_6274_().m_21926_((List)ImmutableList.of((Object)Activity.f_37991_, (Object)Activity.f_37979_));
    }

    public static Optional<LivingEntity> getAvoidTarget(LivingEntity prey) {
        return prey.m_6274_().m_21874_(MemoryModuleType.f_26383_) ? prey.m_6274_().m_21952_(MemoryModuleType.f_26383_) : Optional.empty();
    }

    public static void wasHurtBy(LivingEntity prey, LivingEntity attacker) {
        Brain brain = prey.m_6274_();
        PreyAi.getAvoidTarget(prey).ifPresent(avoid -> {
            if (avoid.m_6095_() != attacker.m_6095_()) {
                brain.m_21936_(MemoryModuleType.f_26383_);
                brain.m_21882_(MemoryModuleType.f_26383_, (Object)attacker, (long)RETREAT_DURATION.m_142270_(prey.m_21187_()));
                PreyAi.broadcastAvoidTarget(prey, attacker);
            }
        });
    }

    public static void broadcastAvoidTarget(LivingEntity prey, LivingEntity attacker) {
        Brain brain = prey.m_6274_();
        brain.m_21952_(MemoryModuleType.f_148205_).ifPresent(entities -> entities.m_186123_(e -> e.m_6095_() == prey.m_6095_()).forEach(friend -> {
            LivingEntity closest = BehaviorUtils.m_22625_((LivingEntity)friend, (Optional)friend.m_6274_().m_21952_(MemoryModuleType.f_26383_), (LivingEntity)attacker);
            PreyAi.setAvoidTarget(friend, closest);
        }));
    }

    public static void setAvoidTarget(LivingEntity prey, LivingEntity attacker) {
        Brain brain = prey.m_6274_();
        brain.m_21936_(MemoryModuleType.f_26370_);
        brain.m_21936_(MemoryModuleType.f_26371_);
        brain.m_21882_(MemoryModuleType.f_26383_, (Object)attacker, (long)RETREAT_DURATION.m_142270_(prey.m_21187_()));
    }

    public static boolean wantsToStopFleeing(LivingEntity prey) {
        Brain brain = prey.m_6274_();
        return !brain.m_21874_(MemoryModuleType.f_26383_) || ((LivingEntity)brain.m_21952_(MemoryModuleType.f_26383_).get()).m_20280_((Entity)prey) > 400.0;
    }
}

