/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.prey;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.Set;
import net.dries007.tfc.common.entities.ai.TFCBrain;
import net.dries007.tfc.common.entities.ai.prey.AvoidPredatorBehavior;
import net.dries007.tfc.common.entities.ai.prey.PestFeastBehavior;
import net.dries007.tfc.common.entities.ai.prey.PreyAi;
import net.dries007.tfc.common.entities.prey.Pest;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.RunSometimes;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public class PestAi {
    public static final ImmutableList<SensorType<? extends Sensor<? super Pest>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26812_, (Object)SensorType.f_26814_);
    public static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26383_, (Object)MemoryModuleType.f_26331_, (Object)((MemoryModuleType)TFCBrain.SMELLY_POS.get()));

    public static Brain<?> makeBrain(Brain<? extends Pest> brain) {
        PestAi.initCoreActivity(brain);
        PestAi.initIdleActivity(brain);
        PestAi.initRetreatActivity(brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    public static void initCoreActivity(Brain<? extends Pest> brain) {
        PreyAi.initCoreActivity(brain);
    }

    public static void initIdleActivity(Brain<? extends Pest> brain) {
        brain.m_21900_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)new RunSometimes((Behavior)new SetEntityLookTarget(EntityType.f_20532_, 6.0f), UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)((Object)new AvoidPredatorBehavior(false))), (Object)Pair.of((Object)2, (Object)new RunSometimes((Behavior)new PestFeastBehavior((MemoryModuleType)TFCBrain.SMELLY_POS.get(), false), UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)3, (Object)new BabyFollowAdult(UniformInt.m_146622_((int)5, (int)16), 1.25f)), (Object)Pair.of((Object)4, PreyAi.createIdleMovementBehaviors())));
    }

    public static void initRetreatActivity(Brain<? extends Pest> brain) {
        PreyAi.initRetreatActivity(brain);
    }

    public static void setSmelledPos(Pest pest, BlockPos pos) {
        pest.m_6274_().m_21879_((MemoryModuleType)TFCBrain.SMELLY_POS.get(), (Object)GlobalPos.m_122643_((ResourceKey)pest.f_19853_.m_46472_(), (BlockPos)pos));
    }
}

