/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities;

import java.util.function.Consumer;
import net.minecraft.util.Mth;

public class AnimationState {
    private static final long IMMOBILE = Long.MAX_VALUE;
    private long lastTime = Long.MAX_VALUE;
    private long accumulatedTime;

    public void start(int ticks) {
        this.lastTime = (long)ticks * 1000L / 20L;
        this.accumulatedTime = 0L;
    }

    public void startIfStopped(int ticks) {
        if (!this.isStarted()) {
            this.start(ticks);
        }
    }

    public void stop() {
        this.lastTime = Long.MAX_VALUE;
    }

    public void ifStarted(Consumer<AnimationState> consumer) {
        if (this.isStarted()) {
            consumer.accept(this);
        }
    }

    public void updateTime(float gameTime, float speed) {
        if (this.isStarted()) {
            long ticks = Mth.m_14134_((double)(gameTime * 1000.0f / 20.0f));
            this.accumulatedTime += (long)((float)(ticks - this.lastTime) * speed);
            this.lastTime = ticks;
        }
    }

    public long getAccumulatedTime() {
        return this.accumulatedTime;
    }

    public boolean isStarted() {
        return this.lastTime != Long.MAX_VALUE;
    }
}

