/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import net.dries007.tfc.common.capabilities.VesselLike;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTraits;
import net.dries007.tfc.common.container.CallbackSlot;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.common.container.ItemStackContainer;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class SmallVesselInventoryContainer
extends ItemStackContainer {
    @Nullable
    private final VesselLike vessel;

    public static SmallVesselInventoryContainer create(ItemStack stack, InteractionHand hand, int slot, Inventory playerInv, int windowId) {
        return (SmallVesselInventoryContainer)((Object)new SmallVesselInventoryContainer(stack, hand, slot, playerInv, windowId).init(playerInv));
    }

    private SmallVesselInventoryContainer(ItemStack stack, InteractionHand hand, int slot, Inventory playerInv, int windowId) {
        super((MenuType)TFCContainerTypes.SMALL_VESSEL_INVENTORY.get(), windowId, playerInv, stack, hand, slot);
        this.vessel = VesselLike.get(stack);
        this.callback = this.vessel;
    }

    @Override
    public boolean m_6875_(Player player) {
        return this.vessel != null && this.vessel.mode() == VesselLike.Mode.INVENTORY && this.vessel.getTemperature() == 0.0f && super.m_6875_(player);
    }

    @Override
    protected boolean moveStack(ItemStack stack, int slotIndex) {
        return switch (this.typeOf(slotIndex)) {
            default -> throw new IncompatibleClassChangeError();
            case Container.IndexType.MAIN_INVENTORY, Container.IndexType.HOTBAR -> {
                if (!this.m_38903_(stack, 0, 4, false)) {
                    yield true;
                }
                yield false;
            }
            case Container.IndexType.CONTAINER -> {
                boolean result;
                FoodCapability.removeTrait(stack, FoodTraits.PRESERVED);
                boolean v1 = result = !this.m_38903_(stack, this.containerSlots, this.f_38839_.size(), false);
                if (result) {
                    FoodCapability.applyTrait(stack, FoodTraits.PRESERVED);
                }
                yield result;
            }
        };
    }

    @Override
    protected void addContainerSlots() {
        if (this.vessel != null) {
            this.m_38897_((Slot)new CallbackSlot(this.vessel, (IItemHandler)this.vessel, 0, 71, 23));
            this.m_38897_((Slot)new CallbackSlot(this.vessel, (IItemHandler)this.vessel, 1, 89, 23));
            this.m_38897_((Slot)new CallbackSlot(this.vessel, (IItemHandler)this.vessel, 2, 71, 41));
            this.m_38897_((Slot)new CallbackSlot(this.vessel, (IItemHandler)this.vessel, 3, 89, 41));
        }
    }
}

