/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import net.dries007.tfc.common.commands.TFCCommands;
import net.dries007.tfc.common.commands.VeinFeatureArgument;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.biome.BiomeSourceExtension;
import net.dries007.tfc.world.biome.TFCBiomes;
import net.dries007.tfc.world.biome.VolcanoNoise;
import net.dries007.tfc.world.feature.vein.Vein;
import net.dries007.tfc.world.feature.vein.VeinConfig;
import net.dries007.tfc.world.feature.vein.VeinFeature;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import org.jetbrains.annotations.Nullable;

public class LocateCommand {
    private static final DynamicCommandExceptionType ERROR_INVALID_BIOME = new DynamicCommandExceptionType(id -> Helpers.translatable("tfc.commands.locate.invalid_biome", id));
    private static final SimpleCommandExceptionType ERROR_INVALID_BIOME_SOURCE = new SimpleCommandExceptionType((Message)Helpers.translatable("tfc.commands.locate.invalid_biome_source"));
    private static final DynamicCommandExceptionType ERROR_NOT_FOUND = new DynamicCommandExceptionType(id -> Helpers.translatable("tfc.commands.locate.not_found", id));
    private static final SimpleCommandExceptionType ERROR_VOLCANO_NOT_FOUND = new SimpleCommandExceptionType((Message)Helpers.translatable("tfc.commands.locate.volcano_not_found"));
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_VEIN = new DynamicCommandExceptionType(args -> Helpers.translatable("tfc.commands.locate.unknown_vein", args));
    public static final DynamicCommandExceptionType ERROR_VEIN_NOT_FOUND = new DynamicCommandExceptionType(args -> Helpers.translatable("tfc.commands.locate.vein_not_found", args));

    public static LiteralArgumentBuilder<CommandSourceStack> create() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"locate").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"biome").then(Commands.m_82129_((String)"biome", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(TFCCommands.TFC_BIOMES.get()).executes(context -> LocateCommand.locateBiome((CommandSourceStack)context.getSource(), (ResourceLocation)context.getArgument("biome", ResourceLocation.class)))))).then(Commands.m_82127_((String)"volcano").executes(context -> LocateCommand.locateVolcano((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"vein").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"vein", (ArgumentType)new VeinFeatureArgument()).executes(context -> LocateCommand.locateVein((CommandContext<CommandSourceStack>)context, (ResourceLocation)context.getArgument("vein", ResourceLocation.class), Integer.MAX_VALUE))).then(Commands.m_82129_((String)"max_y", (ArgumentType)IntegerArgumentType.integer()).executes(context -> LocateCommand.locateVein((CommandContext<CommandSourceStack>)context, (ResourceLocation)context.getArgument("vein", ResourceLocation.class), IntegerArgumentType.getInteger((CommandContext)context, (String)"max_y"))))));
    }

    private static int locateBiome(CommandSourceStack source, ResourceLocation id) throws CommandSyntaxException {
        BiomeSource biomeSource = source.m_81372_().m_7726_().m_8481_().m_62218_();
        if (!(biomeSource instanceof BiomeSourceExtension)) {
            throw ERROR_INVALID_BIOME_SOURCE.create();
        }
        BiomeSourceExtension biomeSourceExtension = (BiomeSourceExtension)biomeSource;
        BiomeExtension variants = TFCBiomes.getById(id);
        if (variants == null) {
            throw ERROR_INVALID_BIOME.create((Object)id);
        }
        BlockPos center = new BlockPos(source.m_81371_());
        BlockPos result = LocateCommand.radialSearch(QuartPos.m_175400_((int)center.m_123341_()), QuartPos.m_175400_((int)center.m_123343_()), 1024, 16, (x, z) -> {
            BiomeExtension found = biomeSourceExtension.getNoiseBiomeVariants(x, z);
            if (found == variants) {
                return new BlockPos(QuartPos.m_175404_((int)x), 0, QuartPos.m_175404_((int)z));
            }
            return null;
        });
        if (result == null) {
            throw ERROR_NOT_FOUND.create((Object)id);
        }
        return LocateCommand.showLocateResult(source, id.toString(), center, result, "commands.locate.success");
    }

    private static int locateVolcano(CommandSourceStack source) throws CommandSyntaxException {
        BiomeSource biomeSource = source.m_81372_().m_7726_().m_8481_().m_62218_();
        if (!(biomeSource instanceof BiomeSourceExtension)) {
            throw ERROR_INVALID_BIOME_SOURCE.create();
        }
        BiomeSourceExtension biomeSourceExtension = (BiomeSourceExtension)biomeSource;
        VolcanoNoise volcanoNoise = new VolcanoNoise(source.m_81372_().m_7328_());
        BlockPos center = new BlockPos(source.m_81371_());
        BlockPos result = LocateCommand.radialSearch(center.m_123341_(), center.m_123343_(), 1024, 16, (x, z) -> {
            BlockPos volcanoPos = volcanoNoise.calculateCenter(x, 0, z, 1);
            if (volcanoPos != null) {
                BiomeExtension found = biomeSourceExtension.getNoiseBiomeVariants(QuartPos.m_175400_((int)volcanoPos.m_123341_()), QuartPos.m_175400_((int)volcanoPos.m_123343_()));
                BlockPos newFound = volcanoNoise.calculateCenter(x, 0, z, found.getVolcanoRarity());
                if (found.isVolcanic() && newFound != null) {
                    return newFound;
                }
            }
            return null;
        });
        if (result == null) {
            throw ERROR_VOLCANO_NOT_FOUND.create();
        }
        return LocateCommand.showLocateResult(source, "volcano", center, result, "commands.locate.success");
    }

    private static int locateVein(CommandContext<CommandSourceStack> context, ResourceLocation id, int maxY) throws CommandSyntaxException {
        ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
        BlockPos sourcePos = new BlockPos(((CommandSourceStack)context.getSource()).m_81371_());
        ChunkPos pos = new ChunkPos(sourcePos);
        Optional optionalFeature = level.m_5962_().m_175515_(Registry.f_122881_).m_6612_(id);
        if (optionalFeature.isEmpty()) {
            throw ERROR_UNKNOWN_VEIN.create((Object)id);
        }
        Optional<ConfiguredFeature> optionalVeinFeature = optionalFeature.filter(v -> v.f_65377_() instanceof VeinFeature).map(v -> v);
        if (optionalVeinFeature.isEmpty()) {
            throw ERROR_UNKNOWN_VEIN.create((Object)id);
        }
        ConfiguredFeature vein = optionalVeinFeature.get();
        ArrayList veins = new ArrayList();
        BiomeSource source = level.m_7726_().m_8481_().m_62218_();
        Climate.Sampler sampler = level.m_7726_().m_8481_().m_183403_();
        BiomeManager biomeManager = level.m_7062_().m_186687_((x, y, z) -> source.m_203407_(x, y, z, sampler));
        WorldGenerationContext generationContext = new WorldGenerationContext(level.m_7726_().m_8481_(), (LevelHeightAccessor)level);
        Function<BlockPos, Holder> biomeQuery = arg_0 -> ((BiomeManager)biomeManager).m_204214_(arg_0);
        @Nullable BlockPos foundPos = LocateCommand.radialSearch(pos.f_45578_, pos.f_45579_, 16, 1, (x, z) -> {
            ((VeinFeature)vein.f_65377_()).getVeinsAtChunk((WorldGenLevel)level, generationContext, x, z, veins, (VeinConfig)vein.f_65378_(), biomeQuery);
            veins.removeIf(v -> v.getPos().m_123342_() > maxY);
            if (!veins.isEmpty()) {
                return ((Vein)veins.get(0)).getPos();
            }
            return null;
        });
        if (foundPos != null) {
            return LocateCommand.showLocateResultIn3D((CommandSourceStack)context.getSource(), id.toString(), sourcePos, ((Vein)veins.get(0)).getPos(), "commands.locate.success");
        }
        throw ERROR_VEIN_NOT_FOUND.create((Object)id.toString());
    }

    private static int showLocateResult(CommandSourceStack context, String nameOfThing, BlockPos source, BlockPos dest, String translationKey) {
        return LocateCommand.showLocateResult(context, nameOfThing, source, dest, "~", translationKey);
    }

    private static int showLocateResultIn3D(CommandSourceStack context, String nameOfThing, BlockPos source, BlockPos dest, String translationKey) {
        return LocateCommand.showLocateResult(context, nameOfThing, source, dest, String.valueOf(dest.m_123342_()), translationKey);
    }

    private static int showLocateResult(CommandSourceStack context, String nameOfThing, BlockPos source, BlockPos dest, String y, String translationKey) {
        int distance = (int)Math.sqrt(source.m_123331_((Vec3i)dest));
        MutableComponent text = ComponentUtils.m_130748_((Component)Helpers.translatable("chat.coordinates", dest.m_123341_(), y, dest.m_123343_())).m_130938_(styleIn -> styleIn.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + dest.m_123341_() + " " + y + " " + dest.m_123343_())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Helpers.translatable("chat.coordinates.tooltip"))));
        context.m_81354_((Component)Helpers.translatable(translationKey, nameOfThing, text, distance), false);
        return distance;
    }

    @Nullable
    private static BlockPos radialSearch(int x, int z, int radius, int step, SearchFunction function) {
        for (int r = 1; r < radius; ++r) {
            for (int d = 0; d < 2 * r; ++d) {
                BlockPos pos = function.find(x + step * (d - r), z + step * -r);
                if (pos != null) {
                    return pos;
                }
                pos = function.find(x + step * r, z + step * (d - r));
                if (pos != null) {
                    return pos;
                }
                pos = function.find(x + step * -r, z + step * (d + 1 - r));
                if (pos != null) {
                    return pos;
                }
                pos = function.find(x + step * (d + 1 - r), z + step * r);
                if (pos == null) continue;
                return pos;
            }
        }
        return null;
    }

    @FunctionalInterface
    static interface SearchFunction {
        @Nullable
        public BlockPos find(int var1, int var2);
    }
}

