/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities.size;

import com.google.gson.JsonObject;
import net.dries007.tfc.common.capabilities.size.IItemSize;
import net.dries007.tfc.common.capabilities.size.Size;
import net.dries007.tfc.common.capabilities.size.Weight;
import net.dries007.tfc.util.ItemDefinition;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class ItemSizeDefinition
extends ItemDefinition
implements IItemSize {
    private final Size size;
    private final Weight weight;

    public ItemSizeDefinition(ResourceLocation id, JsonObject json) {
        super(id, json);
        this.size = JsonHelpers.getEnum(json, "size", Size.class, Size.NORMAL);
        this.weight = JsonHelpers.getEnum(json, "weight", Weight.class, Weight.MEDIUM);
    }

    public ItemSizeDefinition(ResourceLocation id, FriendlyByteBuf buffer) {
        super(id, Ingredient.m_43940_((FriendlyByteBuf)buffer));
        this.size = Size.valueOf(buffer.readByte());
        this.weight = Weight.valueOf(buffer.readByte());
    }

    public void encode(FriendlyByteBuf buffer) {
        this.ingredient.m_43923_(buffer);
        buffer.writeByte(this.size.ordinal());
        buffer.writeByte(this.weight.ordinal());
    }

    @Override
    public Size getSize(ItemStack stack) {
        return this.size;
    }

    @Override
    public Weight getWeight(ItemStack stack) {
        return this.weight;
    }
}

