/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities.heat;

import java.util.List;
import net.dries007.tfc.common.capabilities.heat.INetworkHeat;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.config.HeatTooltipStyle;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public interface IHeat
extends INetworkHeat {
    public float getTemperature();

    public void setTemperature(float var1);

    default public void setTemperatureIfWarmer(float temperature) {
        float current = this.getTemperature();
        if (temperature > current) {
            this.setTemperature(temperature);
        }
    }

    default public void addTemperatureFromSourceWithHeatCapacity(float temperature, float heatCapacity) {
        float currentTemperature = this.getTemperature();
        float currentHeatCapacity = this.getHeatCapacity();
        float totalHeatCapacity = currentHeatCapacity + heatCapacity;
        this.setTemperature(currentTemperature * currentHeatCapacity / totalHeatCapacity + temperature * heatCapacity / totalHeatCapacity);
    }

    public float getHeatCapacity();

    default public float getWorkingTemperature() {
        return 0.0f;
    }

    default public float getWeldingTemperature() {
        return 0.0f;
    }

    default public void addTooltipInfo(ItemStack stack, List<Component> text) {
        float temperature = this.getTemperature();
        MutableComponent tooltip = ((HeatTooltipStyle)((Object)TFCConfig.CLIENT.heatTooltipStyle.get())).formatColored(temperature);
        if (tooltip != null) {
            float weldingTemperature = this.getWeldingTemperature();
            float forgingTemperature = this.getWorkingTemperature();
            if (weldingTemperature > 0.0f && weldingTemperature <= temperature) {
                tooltip.m_7220_((Component)Helpers.translatable("tfc.tooltip.welding"));
            } else if (forgingTemperature > 0.0f && forgingTemperature <= temperature) {
                tooltip.m_7220_((Component)Helpers.translatable("tfc.tooltip.forging"));
            }
            ItemStackInventory wrapper = new ItemStackInventory(stack);
            HeatingRecipe recipe = HeatingRecipe.getRecipe(wrapper);
            if (recipe != null && (double)temperature > 0.9 * (double)recipe.getTemperature() && recipe.assemble(wrapper).m_41619_()) {
                tooltip.m_7220_((Component)Helpers.translatable("tfc.tooltip.danger"));
            }
            text.add((Component)tooltip);
        }
    }
}

