/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.wood;

import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.BarrelBlockEntity;
import net.dries007.tfc.common.blockentities.LoomBlockEntity;
import net.dries007.tfc.common.blockentities.SluiceBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.GroundcoverBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.TFCMaterials;
import net.dries007.tfc.common.blocks.devices.BarrelBlock;
import net.dries007.tfc.common.blocks.devices.SluiceBlock;
import net.dries007.tfc.common.blocks.wood.BookshelfBlock;
import net.dries007.tfc.common.blocks.wood.FallenLeavesBlock;
import net.dries007.tfc.common.blocks.wood.HorizontalSupportBlock;
import net.dries007.tfc.common.blocks.wood.LogBlock;
import net.dries007.tfc.common.blocks.wood.ScribingTableBlock;
import net.dries007.tfc.common.blocks.wood.TFCChestBlock;
import net.dries007.tfc.common.blocks.wood.TFCCraftingTableBlock;
import net.dries007.tfc.common.blocks.wood.TFCDoorBlock;
import net.dries007.tfc.common.blocks.wood.TFCFenceBlock;
import net.dries007.tfc.common.blocks.wood.TFCFenceGateBlock;
import net.dries007.tfc.common.blocks.wood.TFCLeavesBlock;
import net.dries007.tfc.common.blocks.wood.TFCLecternBlock;
import net.dries007.tfc.common.blocks.wood.TFCLoomBlock;
import net.dries007.tfc.common.blocks.wood.TFCPressurePlateBlock;
import net.dries007.tfc.common.blocks.wood.TFCSaplingBlock;
import net.dries007.tfc.common.blocks.wood.TFCSlabBlock;
import net.dries007.tfc.common.blocks.wood.TFCStairBlock;
import net.dries007.tfc.common.blocks.wood.TFCStandingSignBlock;
import net.dries007.tfc.common.blocks.wood.TFCTrapDoorBlock;
import net.dries007.tfc.common.blocks.wood.TFCTrappedChestBlock;
import net.dries007.tfc.common.blocks.wood.TFCWallSignBlock;
import net.dries007.tfc.common.blocks.wood.TFCWoodButtonBlock;
import net.dries007.tfc.common.blocks.wood.ToolRackBlock;
import net.dries007.tfc.common.blocks.wood.VerticalSupportBlock;
import net.dries007.tfc.common.items.BarrelBlockItem;
import net.dries007.tfc.common.items.ChestBlockItem;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryWood;
import net.dries007.tfc.world.feature.tree.TFCTreeGrower;
import net.minecraft.core.Direction;
import net.minecraft.util.ToFloatFunction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import org.jetbrains.annotations.Nullable;

public enum Wood implements RegistryWood
{
    ACACIA(false, MaterialColor.f_76373_, MaterialColor.f_76380_, 7, 11),
    ASH(false, MaterialColor.f_76378_, MaterialColor.f_76373_, 8, 7),
    ASPEN(false, MaterialColor.f_76385_, MaterialColor.f_76372_, 7, 8),
    BIRCH(false, MaterialColor.f_76362_, MaterialColor.f_76372_, 7, 7),
    BLACKWOOD(false, MaterialColor.f_76365_, MaterialColor.f_76362_, 7, 8),
    CHESTNUT(false, MaterialColor.f_76386_, MaterialColor.f_76417_, 8, 7),
    DOUGLAS_FIR(true, MaterialColor.f_76376_, MaterialColor.f_76384_, 7, 7),
    HICKORY(false, MaterialColor.f_76384_, MaterialColor.f_76419_, 7, 10),
    KAPOK(true, MaterialColor.f_76418_, MaterialColor.f_76362_, 8, 7),
    MAPLE(false, MaterialColor.f_76413_, MaterialColor.f_76379_, 8, 7),
    OAK(false, MaterialColor.f_76411_, MaterialColor.f_76362_, 8, 10),
    PALM(true, MaterialColor.f_76413_, MaterialColor.f_76362_, 7, 7),
    PINE(true, MaterialColor.f_76379_, MaterialColor.f_76419_, 7, 7),
    ROSEWOOD(false, MaterialColor.f_76364_, MaterialColor.f_76380_, 9, 8),
    SEQUOIA(true, MaterialColor.f_76386_, MaterialColor.f_76386_, 7, 18),
    SPRUCE(true, MaterialColor.f_76378_, MaterialColor.f_76388_, 7, 7),
    SYCAMORE(false, MaterialColor.f_76416_, MaterialColor.f_76377_, 7, 8),
    WHITE_CEDAR(true, MaterialColor.f_76372_, MaterialColor.f_76380_, 7, 7),
    WILLOW(false, MaterialColor.f_76363_, MaterialColor.f_76384_, 7, 11);

    public static final Wood[] VALUES;
    private final String serializedName = this.name().toLowerCase(Locale.ROOT);
    private final boolean conifer;
    private final MaterialColor woodColor;
    private final MaterialColor barkColor;
    private final TFCTreeGrower tree;
    private final int maxDecayDistance;
    private final int daysToGrow;

    private Wood(boolean conifer, MaterialColor woodColor, MaterialColor barkColor, int maxDecayDistance, int daysToGrow) {
        this.conifer = conifer;
        this.woodColor = woodColor;
        this.barkColor = barkColor;
        this.tree = new TFCTreeGrower(Helpers.identifier("tree/" + this.serializedName), Helpers.identifier("tree/" + this.serializedName + "_large"));
        this.maxDecayDistance = maxDecayDistance;
        this.daysToGrow = daysToGrow;
    }

    public String m_7912_() {
        return this.serializedName;
    }

    public boolean isConifer() {
        return this.conifer;
    }

    @Override
    public MaterialColor woodColor() {
        return this.woodColor;
    }

    @Override
    public MaterialColor barkColor() {
        return this.barkColor;
    }

    @Override
    public TFCTreeGrower tree() {
        return this.tree;
    }

    @Override
    public int maxDecayDistance() {
        return this.maxDecayDistance;
    }

    @Override
    public int daysToGrow() {
        return (Integer)TFCConfig.SERVER.saplingGrowthDays.get(this).get();
    }

    public int defaultDaysToGrow() {
        return this.daysToGrow;
    }

    @Override
    public Supplier<Block> getBlock(BlockType type) {
        return (Supplier)TFCBlocks.WOODS.get(this).get((Object)type);
    }

    static {
        VALUES = Wood.values();
    }

    public static enum BlockType {
        LOG((self, wood) -> new LogBlock(ExtendedProperties.of(Material.f_76320_, state -> state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? wood.woodColor() : wood.barkColor()).strength(8.0f).sound(SoundType.f_56736_).requiresCorrectToolForDrops().flammableLikeLogs(), wood.getBlock(self.stripped())), false),
        STRIPPED_LOG(wood -> new LogBlock(ExtendedProperties.of(Material.f_76320_, state -> state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? wood.woodColor() : wood.barkColor()).strength(7.5f).sound(SoundType.f_56736_).requiresCorrectToolForDrops().flammableLikeLogs(), null), false),
        WOOD((self, wood) -> new LogBlock(BlockType.properties(wood).strength(8.0f).requiresCorrectToolForDrops().flammableLikeLogs(), wood.getBlock(self.stripped())), false),
        STRIPPED_WOOD(wood -> new LogBlock(BlockType.properties(wood).strength(7.5f).requiresCorrectToolForDrops().flammableLikeLogs(), null), false),
        LEAVES((self, wood) -> TFCLeavesBlock.create(ExtendedProperties.of(Material.f_76274_, wood.woodColor()).strength(0.5f).sound(SoundType.f_56740_).randomTicks().noOcclusion().isViewBlocking(TFCBlocks::never).flammableLikeLeaves(), wood.maxDecayDistance(), wood.getBlock(self.fallenLeaves()), wood.getBlock(self.twig())), false),
        PLANKS(wood -> new ExtendedBlock(BlockType.properties(wood).strength(1.5f, 3.0f).flammableLikePlanks()), false),
        SAPLING(wood -> new TFCSaplingBlock(wood.tree(), ExtendedProperties.of(Material.f_76300_, MaterialColor.f_76405_).noCollission().randomTicks().strength(0.0f).sound(SoundType.f_56740_).flammableLikeLeaves().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.TICK_COUNTER), wood::daysToGrow), false),
        POTTED_SAPLING(wood -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, wood.getBlock(SAPLING), BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60966_().m_60955_()), false),
        BOOKSHELF(wood -> new BookshelfBlock(BlockType.properties(wood).strength(2.0f, 3.0f).flammable(20, 30).enchantmentPower((ToFloatFunction<BlockState>)((ToFloatFunction)s -> (float)((Integer)s.m_61143_((Property)BookshelfBlock.BOOKS_STORED)).intValue() / 2.0f)).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.BOOKSHELF)), true),
        DOOR(wood -> new TFCDoorBlock(BlockType.properties(wood).strength(3.0f).noOcclusion().flammableLikePlanks()), true),
        TRAPDOOR(wood -> new TFCTrapDoorBlock(BlockType.properties(wood).strength(3.0f).noOcclusion().flammableLikePlanks()), true),
        FENCE(wood -> new TFCFenceBlock(BlockType.properties(wood).strength(2.0f, 3.0f).flammableLikePlanks()), true),
        LOG_FENCE(wood -> new TFCFenceBlock(BlockType.properties(wood).strength(2.0f, 3.0f).flammableLikeLogs()), true),
        FENCE_GATE(wood -> new TFCFenceGateBlock(BlockType.properties(wood).strength(2.0f, 3.0f).flammableLikePlanks()), true),
        BUTTON(wood -> new TFCWoodButtonBlock(ExtendedProperties.of(Material.f_76310_).noCollission().strength(0.5f).sound(SoundType.f_56736_).flammableLikePlanks()), true),
        PRESSURE_PLATE(wood -> new TFCPressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockType.properties(wood).noCollission().strength(0.5f).sound(SoundType.f_56736_).flammableLikePlanks()), true),
        SLAB(wood -> new TFCSlabBlock(BlockType.properties(wood).strength(1.5f, 3.0f).flammableLikePlanks()), true),
        STAIRS(wood -> new TFCStairBlock(() -> wood.getBlock(PLANKS).get().m_49966_(), BlockType.properties(wood).strength(1.5f, 3.0f).sound(SoundType.f_56736_).flammableLikePlanks()), true),
        TOOL_RACK(wood -> new ToolRackBlock(BlockType.properties(wood).strength(2.0f).noOcclusion().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.TOOL_RACK)), true),
        TWIG(wood -> GroundcoverBlock.twig(ExtendedProperties.of(TFCMaterials.GROUNDCOVER).strength(0.05f, 0.0f).sound(SoundType.f_56736_).noCollission().flammableLikeWool()), false),
        FALLEN_LEAVES(wood -> new FallenLeavesBlock(ExtendedProperties.of(TFCMaterials.GROUNDCOVER).noCollission().strength(0.05f, 0.0f).noOcclusion().sound(SoundType.f_56758_).flammableLikeWool()), false),
        VERTICAL_SUPPORT(wood -> new VerticalSupportBlock(BlockType.properties(wood).strength(1.0f).noOcclusion().flammableLikeLogs()), false),
        HORIZONTAL_SUPPORT(wood -> new HorizontalSupportBlock(BlockType.properties(wood).strength(1.0f).noOcclusion().flammableLikeLogs()), false),
        WORKBENCH(wood -> new TFCCraftingTableBlock(BlockType.properties(wood).strength(2.5f).flammableLikeLogs()), true),
        TRAPPED_CHEST((self, wood) -> new TFCTrappedChestBlock(BlockType.properties(wood).strength(2.5f).flammableLikeLogs().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.TRAPPED_CHEST).clientTicks(ChestBlockEntity::m_155343_), wood.m_7912_()), false, ChestBlockItem::new),
        CHEST((self, wood) -> new TFCChestBlock(BlockType.properties(wood).strength(2.5f).flammableLikeLogs().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.CHEST).clientTicks(ChestBlockEntity::m_155343_), wood.m_7912_()), false, ChestBlockItem::new),
        LOOM(wood -> new TFCLoomBlock(BlockType.properties(wood).strength(2.5f).noOcclusion().flammableLikePlanks().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.LOOM).ticks(LoomBlockEntity::tick), Helpers.identifier("block/wood/planks/" + wood.m_7912_())), true),
        SLUICE(wood -> new SluiceBlock(BlockType.properties(wood).strength(3.0f).noOcclusion().flammableLikeLogs().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.SLUICE).serverTicks(SluiceBlockEntity::serverTick)), false),
        SIGN(wood -> new TFCStandingSignBlock(BlockType.properties(wood).noCollission().strength(1.0f).flammableLikePlanks().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.SIGN)), true),
        WALL_SIGN(wood -> new TFCWallSignBlock(BlockType.properties(wood).noCollission().strength(1.0f).dropsLike(wood.getBlock(SIGN)).flammableLikePlanks().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.SIGN)), true),
        BARREL((self, wood) -> new BarrelBlock(BlockType.properties(wood).strength(2.5f).flammableLikePlanks().noOcclusion().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.BARREL).serverTicks(BarrelBlockEntity::serverTick)), false, BarrelBlockItem::new),
        LECTERN(wood -> new TFCLecternBlock(BlockType.properties(wood).noCollission().strength(2.5f).flammableLikePlanks().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.LECTERN)), false),
        SCRIBING_TABLE(wood -> new ScribingTableBlock(BlockType.properties(wood).noOcclusion().strength(2.5f).flammable(20, 30)), false);

        private final BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory;
        private final boolean isPlanksVariant;
        private final BiFunction<BlockType, RegistryWood, Block> blockFactory;

        private static ExtendedProperties properties(RegistryWood wood) {
            return ExtendedProperties.of(Material.f_76320_, wood.woodColor()).sound(SoundType.f_56736_);
        }

        private BlockType(Function<RegistryWood, Block> blockFactory, boolean isPlanksVariant) {
            this((BlockType self, RegistryWood wood) -> (Block)blockFactory.apply((RegistryWood)wood), isPlanksVariant);
        }

        private BlockType(BiFunction<BlockType, RegistryWood, Block> blockFactory, boolean isPlanksVariant) {
            this(blockFactory, isPlanksVariant, BlockItem::new);
        }

        private BlockType(BiFunction<BlockType, RegistryWood, Block> blockFactory, boolean isPlanksVariant, BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory) {
            this.blockFactory = blockFactory;
            this.isPlanksVariant = isPlanksVariant;
            this.blockItemFactory = blockItemFactory;
        }

        @Nullable
        public Function<Block, BlockItem> createBlockItem(Item.Properties properties) {
            return this.needsItem() ? block -> this.blockItemFactory.apply((Block)block, properties) : null;
        }

        public String nameFor(RegistryWood wood) {
            return (this.isPlanksVariant ? "wood/planks/" + wood.m_7912_() + "_" + this.name() : "wood/" + this.name() + "/" + wood.m_7912_()).toLowerCase(Locale.ROOT);
        }

        public boolean needsItem() {
            return this != VERTICAL_SUPPORT && this != HORIZONTAL_SUPPORT && this != SIGN && this != WALL_SIGN && this != POTTED_SAPLING;
        }

        private BlockType stripped() {
            return switch (this) {
                case LOG -> STRIPPED_LOG;
                case WOOD -> STRIPPED_WOOD;
                default -> throw new IllegalStateException("Block type " + this.name() + " does not have a stripped variant");
            };
        }

        private BlockType twig() {
            return TWIG;
        }

        private BlockType fallenLeaves() {
            return FALLEN_LEAVES;
        }

        public Supplier<Block> create(RegistryWood wood) {
            return () -> this.blockFactory.apply(this, wood);
        }
    }
}

