/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.fruit;

import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.plant.fruit.IBushBlock;
import net.dries007.tfc.common.blocks.plant.fruit.Lifecycle;
import net.dries007.tfc.common.blocks.plant.fruit.SpreadingCaneBlock;
import net.dries007.tfc.common.blocks.plant.fruit.StationaryBerryBushBlock;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.ClimateRange;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SpreadingBushBlock
extends StationaryBerryBushBlock
implements IForgeBlockExtension,
IBushBlock,
HoeOverlayBlock {
    protected final Supplier<? extends Block> companion;
    protected final int maxHeight;

    public SpreadingBushBlock(ExtendedProperties properties, Supplier<? extends Item> productItem, Lifecycle[] stages, Supplier<? extends Block> companion, int maxHeight, Supplier<ClimateRange> climateRange) {
        super(properties, productItem, stages, climateRange);
        this.companion = companion;
        this.maxHeight = maxHeight;
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public Block getCane() {
        return this.companion.get();
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Integer)state.m_61143_((Property)STAGE) == 2 ? Shapes.m_83144_() : PLANT_SHAPE;
    }

    @Override
    protected BlockState getDeadState(BlockState state) {
        return (BlockState)((Block)TFCBlocks.DEAD_BERRY_BUSH.get()).m_49966_().m_61124_((Property)STAGE, (Comparable)((Integer)state.m_61143_((Property)STAGE)));
    }

    @Override
    protected BlockState growAndPropagate(Level level, BlockPos pos, Random random, BlockState state) {
        if (!((Lifecycle)((Object)state.m_61143_((Property)LIFECYCLE))).active()) {
            return state;
        }
        int originalStage = (Integer)state.m_61143_((Property)STAGE);
        if (originalStage == 0) {
            return (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(1));
        }
        if (originalStage == 1) {
            Direction offset;
            BlockPos offsetPos;
            BlockPos abovePos = pos.m_7494_();
            if (level.m_46859_(abovePos) && SpreadingBushBlock.distanceToGround(level, pos, this.maxHeight) < this.maxHeight) {
                level.m_46597_(abovePos, (BlockState)((BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(1))).m_61124_((Property)LIFECYCLE, (Comparable)((Object)((Lifecycle)((Object)state.m_61143_((Property)LIFECYCLE))))));
                return state;
            }
            if (random.nextBoolean() && level.m_46859_(offsetPos = pos.m_142300_(offset = Direction.Plane.HORIZONTAL.m_122560_(random)))) {
                level.m_46597_(offsetPos, (BlockState)((BlockState)this.companion.get().m_49966_().m_61124_((Property)SpreadingCaneBlock.FACING, (Comparable)offset)).m_61124_((Property)LIFECYCLE, (Comparable)((Object)((Lifecycle)((Object)state.m_61143_((Property)LIFECYCLE))))));
            }
            return (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(2));
        }
        return state;
    }

    @Override
    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState state, List<Component> text, boolean isDebug) {
        BlockPos sourcePos = pos.m_7495_();
        ClimateRange range = (ClimateRange)this.climateRange.get();
        text.add(FarmlandBlock.getHydrationTooltip((LevelAccessor)level, sourcePos, range, false));
        text.add(FarmlandBlock.getTemperatureTooltip(level, sourcePos, range, false));
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos belowPos = pos.m_7495_();
        BlockState belowState = level.m_8055_(belowPos);
        return Helpers.isBlock(belowState, (Block)this) || this.m_6266_(level.m_8055_(belowPos), (BlockGetter)level, belowPos);
    }
}

