/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import java.util.List;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.ThatchBedBlockEntity;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.items.HideItemType;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ThatchBedBlock
extends BedBlock
implements EntityBlockExtension,
IForgeBlockExtension {
    private static final VoxelShape BED_SHAPE = ThatchBedBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    private final ExtendedProperties properties;

    public ThatchBedBlock(ExtendedProperties properties) {
        super(DyeColor.YELLOW, properties.properties());
        this.properties = properties;
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return state.m_61143_((Property)f_49440_) == BedPart.HEAD ? this.getExtendedProperties().newBlockEntity(pos, state) : null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (state.m_61143_((Property)f_49440_) != BedPart.HEAD && !Helpers.isBlock(state = level.m_8055_(pos = pos.m_142300_((Direction)state.m_61143_((Property)f_54117_))), (Block)this)) {
            return InteractionResult.CONSUME;
        }
        if (!ThatchBedBlock.m_49488_((Level)level)) {
            level.m_7471_(pos, false);
            BlockPos blockpos = pos.m_142300_(((Direction)state.m_61143_((Property)f_54117_)).m_122424_());
            if (Helpers.isBlock(level.m_8055_(blockpos), (Block)this)) {
                level.m_7471_(blockpos, false);
            }
            level.m_7703_(null, DamageSource.m_19334_(), null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 7.0f, true, Explosion.BlockInteraction.DESTROY);
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.m_61143_((Property)f_49441_)).booleanValue()) {
            if (!this.kickVillagerOutOfBed(level, pos)) {
                player.m_5661_((Component)Helpers.translatable("block.minecraft.bed.occupied"), true);
            }
            return InteractionResult.SUCCESS;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (level.m_46470_() && ((Boolean)TFCConfig.SERVER.thatchBedNoSleepInThunderstorms.get()).booleanValue()) {
                player.m_5661_((Component)Helpers.translatable("tfc.thatch_bed.thundering"), true);
                return InteractionResult.SUCCESS;
            }
            boolean willSleep = (Boolean)TFCConfig.SERVER.enableThatchBedSleeping.get();
            boolean spawnPoint = (Boolean)TFCConfig.SERVER.enableThatchBedSpawnSetting.get();
            if (!willSleep) {
                if (spawnPoint) {
                    player.m_5661_((Component)Helpers.translatable("tfc.thatch_bed.use_no_sleep_spawn"), true);
                    serverPlayer.m_9158_(level.m_46472_(), pos, 0.0f, false, false);
                    return InteractionResult.SUCCESS;
                }
                player.m_5661_((Component)Helpers.translatable("tfc.thatch_bed.use_no_sleep_no_spawn"), true);
                return InteractionResult.SUCCESS;
            }
            BlockPos lastRespawnPos = serverPlayer.m_8961_();
            ResourceKey lastRespawnDimension = serverPlayer.m_8963_();
            float lastRespawnAngle = serverPlayer.m_8962_();
            player.m_7720_(pos).ifLeft(problem -> {
                if (problem.m_36423_() != null) {
                    player.m_5661_(problem.m_36423_(), true);
                }
            }).ifRight(unit -> {
                if (spawnPoint) {
                    player.m_5661_((Component)Helpers.translatable("tfc.thatch_bed.use_sleep_spawn"), true);
                } else {
                    serverPlayer.m_9158_(lastRespawnDimension, lastRespawnPos, lastRespawnAngle, false, false);
                    player.m_5661_((Component)Helpers.translatable("tfc.thatch_bed.use_sleep_no_spawn"), true);
                }
            });
        }
        return InteractionResult.SUCCESS;
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        level.m_8767_((ParticleOptions)((SimpleParticleType)TFCParticles.FEATHER.get()), entity.m_20185_(), Math.max(entity.m_20186_() + (double)0.1f, (double)((float)pos.m_123342_() + 0.6f)), entity.m_20189_(), numberOfParticles, 0.0, 0.0, 0.0, (double)0.15f);
        return super.addLandingEffects(state1, level, pos, state2, entity, numberOfParticles);
    }

    private boolean kickVillagerOutOfBed(Level level, BlockPos pos) {
        List list = level.m_6443_(Villager.class, new AABB(pos), LivingEntity::m_5803_);
        if (list.isEmpty()) {
            return false;
        }
        ((Villager)list.get(0)).m_5796_();
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return BED_SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        if (state.m_61143_((Property)f_49440_) == BedPart.FOOT) {
            pos = pos.m_142300_((Direction)state.m_61143_((Property)f_54117_));
        }
        return level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.THATCH_BED.get()).map(bed -> bed.getCapability(Capabilities.ITEM).map(inv -> inv.getStackInSlot(0).m_41777_()).orElse(ItemStack.f_41583_)).orElse(ItemStack.f_41583_);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.m_6402_(level, pos, state, entity, stack);
        level.m_141902_(pos.m_142300_((Direction)state.m_61143_((Property)f_54117_)), (BlockEntityType)TFCBlockEntities.THATCH_BED.get()).ifPresent(bed -> {
            BlockState thatch = ((Block)TFCBlocks.THATCH.get()).m_49966_();
            bed.setBed(thatch, thatch, ((Item)TFCItems.HIDES.get((Object)HideItemType.RAW).get((Object)HideItemType.Size.LARGE).get()).m_7968_());
        });
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_61143_((Property)f_49440_) == BedPart.HEAD && !Helpers.isBlock(state, newState.m_60734_())) {
            level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.THATCH_BED.get()).ifPresent(ThatchBedBlockEntity::destroyBed);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }
}

