/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.dries007.tfc.common.blockentities.AnvilBlockEntity;
import net.dries007.tfc.common.blockentities.BarrelBlockEntity;
import net.dries007.tfc.common.blockentities.BellowsBlockEntity;
import net.dries007.tfc.common.blockentities.BerryBushBlockEntity;
import net.dries007.tfc.common.blockentities.BlastFurnaceBlockEntity;
import net.dries007.tfc.common.blockentities.BloomBlockEntity;
import net.dries007.tfc.common.blockentities.BloomeryBlockEntity;
import net.dries007.tfc.common.blockentities.BookshelfBlockEntity;
import net.dries007.tfc.common.blockentities.BurningLogPileBlockEntity;
import net.dries007.tfc.common.blockentities.CharcoalForgeBlockEntity;
import net.dries007.tfc.common.blockentities.ComposterBlockEntity;
import net.dries007.tfc.common.blockentities.CropBlockEntity;
import net.dries007.tfc.common.blockentities.CrucibleBlockEntity;
import net.dries007.tfc.common.blockentities.DecayingBlockEntity;
import net.dries007.tfc.common.blockentities.FarmlandBlockEntity;
import net.dries007.tfc.common.blockentities.FirepitBlockEntity;
import net.dries007.tfc.common.blockentities.GrillBlockEntity;
import net.dries007.tfc.common.blockentities.IngotPileBlockEntity;
import net.dries007.tfc.common.blockentities.LampBlockEntity;
import net.dries007.tfc.common.blockentities.LargeVesselBlockEntity;
import net.dries007.tfc.common.blockentities.LogPileBlockEntity;
import net.dries007.tfc.common.blockentities.LoomBlockEntity;
import net.dries007.tfc.common.blockentities.NestBoxBlockEntity;
import net.dries007.tfc.common.blockentities.PileBlockEntity;
import net.dries007.tfc.common.blockentities.PitKilnBlockEntity;
import net.dries007.tfc.common.blockentities.PlacedItemBlockEntity;
import net.dries007.tfc.common.blockentities.PotBlockEntity;
import net.dries007.tfc.common.blockentities.PowderkegBlockEntity;
import net.dries007.tfc.common.blockentities.QuernBlockEntity;
import net.dries007.tfc.common.blockentities.ScrapingBlockEntity;
import net.dries007.tfc.common.blockentities.SheetPileBlockEntity;
import net.dries007.tfc.common.blockentities.SluiceBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBellBlockEntity;
import net.dries007.tfc.common.blockentities.TFCChestBlockEntity;
import net.dries007.tfc.common.blockentities.TFCLecternBlockEntity;
import net.dries007.tfc.common.blockentities.TFCSignBlockEntity;
import net.dries007.tfc.common.blockentities.TFCTrappedChestBlockEntity;
import net.dries007.tfc.common.blockentities.ThatchBedBlockEntity;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.common.blockentities.ToolRackBlockEntity;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.soil.SoilBlockType;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.registry.RegistrationHelpers;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class TFCBlockEntities {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)"tfc");
    public static final RegistryObject<BlockEntityType<FarmlandBlockEntity>> FARMLAND = TFCBlockEntities.register("farmland", FarmlandBlockEntity::new, TFCBlocks.SOIL.get((Object)SoilBlockType.FARMLAND).values().stream());
    public static final RegistryObject<BlockEntityType<PileBlockEntity>> PILE = TFCBlockEntities.register("pile", PileBlockEntity::new, Stream.of(TFCBlocks.ICE_PILE, TFCBlocks.SNOW_PILE));
    public static final RegistryObject<BlockEntityType<FirepitBlockEntity>> FIREPIT = TFCBlockEntities.register("firepit", FirepitBlockEntity::new, TFCBlocks.FIREPIT);
    public static final RegistryObject<BlockEntityType<GrillBlockEntity>> GRILL = TFCBlockEntities.register("grill", GrillBlockEntity::new, TFCBlocks.GRILL);
    public static final RegistryObject<BlockEntityType<PotBlockEntity>> POT = TFCBlockEntities.register("pot", PotBlockEntity::new, TFCBlocks.POT);
    public static final RegistryObject<BlockEntityType<TickCounterBlockEntity>> TICK_COUNTER = TFCBlockEntities.register("tick_counter", TickCounterBlockEntity::new, Stream.of(TFCBlocks.WOODS.values().stream().map(map -> (RegistryObject)map.get((Object)Wood.BlockType.SAPLING)), TFCBlocks.FRUIT_TREE_SAPLINGS.values(), TFCBlocks.FRUIT_TREE_GROWING_BRANCHES.values(), TFCBlocks.TORCH, TFCBlocks.WALL_TORCH, TFCBlocks.DEAD_BERRY_BUSH, TFCBlocks.DEAD_CANE, TFCBlocks.BANANA_SAPLING, TFCBlocks.DEAD_BANANA_PLANT, TFCBlocks.JACK_O_LANTERN, TFCBlocks.CANDLE, TFCBlocks.DYED_CANDLE.values(), TFCBlocks.DYED_CANDLE_CAKES.values(), TFCBlocks.SOIL.get((Object)SoilBlockType.DRYING_BRICKS).values()).flatMap(Helpers::flatten));
    public static final RegistryObject<BlockEntityType<LogPileBlockEntity>> LOG_PILE = TFCBlockEntities.register("log_pile", LogPileBlockEntity::new, TFCBlocks.LOG_PILE);
    public static final RegistryObject<BlockEntityType<BurningLogPileBlockEntity>> BURNING_LOG_PILE = TFCBlockEntities.register("burning_log_pile", BurningLogPileBlockEntity::new, TFCBlocks.BURNING_LOG_PILE);
    public static final RegistryObject<BlockEntityType<PlacedItemBlockEntity>> PLACED_ITEM = TFCBlockEntities.register("placed_item", PlacedItemBlockEntity::new, TFCBlocks.PLACED_ITEM);
    public static final RegistryObject<BlockEntityType<PitKilnBlockEntity>> PIT_KILN = TFCBlockEntities.register("pit_kiln", PitKilnBlockEntity::new, TFCBlocks.PIT_KILN);
    public static final RegistryObject<BlockEntityType<CharcoalForgeBlockEntity>> CHARCOAL_FORGE = TFCBlockEntities.register("charcoal_forge", CharcoalForgeBlockEntity::new, TFCBlocks.CHARCOAL_FORGE);
    public static final RegistryObject<BlockEntityType<QuernBlockEntity>> QUERN = TFCBlockEntities.register("quern", QuernBlockEntity::new, TFCBlocks.QUERN);
    public static final RegistryObject<BlockEntityType<ScrapingBlockEntity>> SCRAPING = TFCBlockEntities.register("scraping", ScrapingBlockEntity::new, TFCBlocks.SCRAPING);
    public static final RegistryObject<BlockEntityType<CrucibleBlockEntity>> CRUCIBLE = TFCBlockEntities.register("crucible", CrucibleBlockEntity::new, TFCBlocks.CRUCIBLE);
    public static final RegistryObject<BlockEntityType<BellowsBlockEntity>> BELLOWS = TFCBlockEntities.register("bellows", BellowsBlockEntity::new, TFCBlocks.BELLOWS);
    public static final RegistryObject<BlockEntityType<ComposterBlockEntity>> COMPOSTER = TFCBlockEntities.register("composter", ComposterBlockEntity::new, TFCBlocks.COMPOSTER);
    public static final RegistryObject<BlockEntityType<BloomeryBlockEntity>> BLOOMERY = TFCBlockEntities.register("bloomery", BloomeryBlockEntity::new, TFCBlocks.BLOOMERY);
    public static final RegistryObject<BlockEntityType<BloomBlockEntity>> BLOOM = TFCBlockEntities.register("bloom", BloomBlockEntity::new, TFCBlocks.BLOOM);
    public static final RegistryObject<BlockEntityType<PowderkegBlockEntity>> POWDERKEG = TFCBlockEntities.register("powderkeg", PowderkegBlockEntity::new, TFCBlocks.POWDERKEG);
    public static final RegistryObject<BlockEntityType<TFCChestBlockEntity>> CHEST = TFCBlockEntities.register("chest", TFCChestBlockEntity::new, TFCBlocks.WOODS.values().stream().map(map -> (RegistryObject)map.get((Object)Wood.BlockType.CHEST)));
    public static final RegistryObject<BlockEntityType<TFCTrappedChestBlockEntity>> TRAPPED_CHEST = TFCBlockEntities.register("trapped_chest", TFCTrappedChestBlockEntity::new, TFCBlocks.WOODS.values().stream().map(map -> (RegistryObject)map.get((Object)Wood.BlockType.TRAPPED_CHEST)));
    public static final RegistryObject<BlockEntityType<BarrelBlockEntity>> BARREL = TFCBlockEntities.register("barrel", BarrelBlockEntity::new, TFCBlocks.WOODS.values().stream().map(map -> (RegistryObject)map.get((Object)Wood.BlockType.BARREL)));
    public static final RegistryObject<BlockEntityType<LoomBlockEntity>> LOOM = TFCBlockEntities.register("loom", LoomBlockEntity::new, TFCBlocks.WOODS.values().stream().map(map -> (RegistryObject)map.get((Object)Wood.BlockType.LOOM)));
    public static final RegistryObject<BlockEntityType<SluiceBlockEntity>> SLUICE = TFCBlockEntities.register("sluice", SluiceBlockEntity::new, TFCBlocks.WOODS.values().stream().map(map -> (RegistryObject)map.get((Object)Wood.BlockType.SLUICE)));
    public static final RegistryObject<BlockEntityType<ToolRackBlockEntity>> TOOL_RACK = TFCBlockEntities.register("tool_rack", ToolRackBlockEntity::new, TFCBlocks.WOODS.values().stream().map(map -> (RegistryObject)map.get((Object)Wood.BlockType.TOOL_RACK)));
    public static final RegistryObject<BlockEntityType<BookshelfBlockEntity>> BOOKSHELF = TFCBlockEntities.register("bookshelf", BookshelfBlockEntity::new, TFCBlocks.WOODS.values().stream().map(map -> (RegistryObject)map.get((Object)Wood.BlockType.BOOKSHELF)));
    public static final RegistryObject<BlockEntityType<TFCSignBlockEntity>> SIGN = TFCBlockEntities.register("sign", TFCSignBlockEntity::new, TFCBlocks.WOODS.values().stream().flatMap(map -> Stream.of(Wood.BlockType.SIGN, Wood.BlockType.WALL_SIGN).map(map::get)));
    public static final RegistryObject<BlockEntityType<LampBlockEntity>> LAMP = TFCBlockEntities.register("lamp", LampBlockEntity::new, TFCBlocks.METALS.values().stream().filter(map -> map.get((Object)Metal.BlockType.LAMP) != null).map(map -> (RegistryObject)map.get((Object)Metal.BlockType.LAMP)));
    public static final RegistryObject<BlockEntityType<ThatchBedBlockEntity>> THATCH_BED = TFCBlockEntities.register("thatch_bed", ThatchBedBlockEntity::new, TFCBlocks.THATCH_BED);
    public static final RegistryObject<BlockEntityType<BerryBushBlockEntity>> BERRY_BUSH = TFCBlockEntities.register("berry_bush", BerryBushBlockEntity::new, Stream.of(TFCBlocks.BANANA_PLANT, TFCBlocks.CRANBERRY_BUSH, TFCBlocks.SPREADING_BUSHES.values(), TFCBlocks.SPREADING_CANES.values(), TFCBlocks.STATIONARY_BUSHES.values(), TFCBlocks.FRUIT_TREE_LEAVES.values()).flatMap(Helpers::flatten));
    public static final RegistryObject<BlockEntityType<CropBlockEntity>> CROP = TFCBlockEntities.register("crop", CropBlockEntity::new, TFCBlocks.CROPS.values().stream());
    public static final RegistryObject<BlockEntityType<DecayingBlockEntity>> DECAYING = TFCBlockEntities.register("decaying", DecayingBlockEntity::new, Stream.of(TFCBlocks.MELON, TFCBlocks.PUMPKIN));
    public static final RegistryObject<BlockEntityType<NestBoxBlockEntity>> NEST_BOX = TFCBlockEntities.register("nest_box", NestBoxBlockEntity::new, TFCBlocks.NEST_BOX);
    public static final RegistryObject<BlockEntityType<LargeVesselBlockEntity>> LARGE_VESSEL = TFCBlockEntities.register("large_vessel", LargeVesselBlockEntity::new, Stream.of(TFCBlocks.LARGE_VESSEL, TFCBlocks.GLAZED_LARGE_VESSELS.values()).flatMap(Helpers::flatten));
    public static final RegistryObject<BlockEntityType<LecternBlockEntity>> LECTERN = TFCBlockEntities.register("lectern", TFCLecternBlockEntity::new, TFCBlocks.WOODS.values().stream().map(map -> (RegistryObject)map.get((Object)Wood.BlockType.LECTERN)));
    public static final RegistryObject<BlockEntityType<AnvilBlockEntity>> ANVIL = TFCBlockEntities.register("anvil", AnvilBlockEntity::new, Stream.concat(TFCBlocks.ROCK_ANVILS.values().stream(), TFCBlocks.METALS.values().stream().map(m -> (RegistryObject)m.get((Object)Metal.BlockType.ANVIL)).filter(Objects::nonNull)));
    public static final RegistryObject<BlockEntityType<SheetPileBlockEntity>> SHEET_PILE = TFCBlockEntities.register("sheet_pile", SheetPileBlockEntity::new, TFCBlocks.SHEET_PILE);
    public static final RegistryObject<BlockEntityType<IngotPileBlockEntity>> INGOT_PILE = TFCBlockEntities.register("ingot_pile", IngotPileBlockEntity::new, TFCBlocks.INGOT_PILE);
    public static final RegistryObject<BlockEntityType<BlastFurnaceBlockEntity>> BLAST_FURNACE = TFCBlockEntities.register("blast_furnace", BlastFurnaceBlockEntity::new, TFCBlocks.BLAST_FURNACE);
    public static final RegistryObject<BlockEntityType<TFCBellBlockEntity>> BELL = TFCBlockEntities.register("bell", TFCBellBlockEntity::new, Stream.of(TFCBlocks.BRONZE_BELL, TFCBlocks.BRASS_BELL));

    private static <T extends BlockEntity> RegistryObject<BlockEntityType<T>> register(String name, BlockEntityType.BlockEntitySupplier<T> factory, Supplier<? extends Block> block) {
        return RegistrationHelpers.register(BLOCK_ENTITIES, name, factory, block);
    }

    private static <T extends BlockEntity> RegistryObject<BlockEntityType<T>> register(String name, BlockEntityType.BlockEntitySupplier<T> factory, Stream<? extends Supplier<? extends Block>> blocks) {
        return RegistrationHelpers.register(BLOCK_ENTITIES, name, factory, blocks);
    }
}

