/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.List;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.blockentities.FarmlandBlockEntity;
import net.dries007.tfc.util.Fertilizer;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;

public interface IFarmland {
    public static void addNutrientParticles(ServerLevel level, BlockPos pos, Fertilizer fertilizer) {
        int i;
        float n = fertilizer.getNitrogen();
        float p = fertilizer.getPhosphorus();
        float k = fertilizer.getPotassium();
        for (i = 0; i < (int)(n > 0.0f ? Mth.m_14036_((float)(n * 10.0f), (float)1.0f, (float)5.0f) : 0.0f); ++i) {
            level.m_8767_((ParticleOptions)((SimpleParticleType)TFCParticles.NITROGEN.get()), (double)((float)pos.m_123341_() + level.f_46441_.nextFloat()), (double)pos.m_123342_() + (double)level.f_46441_.nextFloat() / 5.0, (double)((float)pos.m_123343_() + level.f_46441_.nextFloat()), 0, 0.0, 0.0, 0.0, 1.0);
        }
        for (i = 0; i < (int)(p > 0.0f ? Mth.m_14036_((float)(p * 10.0f), (float)1.0f, (float)5.0f) : 0.0f); ++i) {
            level.m_8767_((ParticleOptions)((SimpleParticleType)TFCParticles.PHOSPHORUS.get()), (double)((float)pos.m_123341_() + level.f_46441_.nextFloat()), (double)pos.m_123342_() + (double)level.f_46441_.nextFloat() / 5.0, (double)((float)pos.m_123343_() + level.f_46441_.nextFloat()), 0, 0.0, 0.0, 0.0, 1.0);
        }
        for (i = 0; i < (int)(k > 0.0f ? Mth.m_14036_((float)(k * 10.0f), (float)1.0f, (float)5.0f) : 0.0f); ++i) {
            level.m_8767_((ParticleOptions)((SimpleParticleType)TFCParticles.POTASSIUM.get()), (double)((float)pos.m_123341_() + level.f_46441_.nextFloat()), (double)pos.m_123342_() + (double)level.f_46441_.nextFloat() / 5.0, (double)((float)pos.m_123343_() + level.f_46441_.nextFloat()), 0, 0.0, 0.0, 0.0, 1.0);
        }
    }

    public float getNutrient(FarmlandBlockEntity.NutrientType var1);

    public void setNutrient(FarmlandBlockEntity.NutrientType var1, float var2);

    default public void addNutrient(FarmlandBlockEntity.NutrientType type, float value) {
        this.setNutrient(type, this.getNutrient(type) + value);
    }

    default public void addNutrients(Fertilizer fertilizer) {
        this.addNutrients(fertilizer, 1.0f);
    }

    default public void addNutrients(Fertilizer fertilizer, float multiplier) {
        this.addNutrient(FarmlandBlockEntity.NutrientType.NITROGEN, fertilizer.getNitrogen() * multiplier);
        this.addNutrient(FarmlandBlockEntity.NutrientType.PHOSPHOROUS, fertilizer.getPhosphorus() * multiplier);
        this.addNutrient(FarmlandBlockEntity.NutrientType.POTASSIUM, fertilizer.getPotassium() * multiplier);
    }

    @Deprecated
    default public float resupplyFraction() {
        return 0.16666667f;
    }

    default public float consumeNutrientAndResupplyOthers(FarmlandBlockEntity.NutrientType type, float amount) {
        float startValue = this.getNutrient(type);
        float consumed = Math.min(startValue, amount);
        this.setNutrient(type, startValue - consumed);
        for (FarmlandBlockEntity.NutrientType other : FarmlandBlockEntity.NutrientType.VALUES) {
            if (other == type) continue;
            this.addNutrient(other, consumed * 1.0f / 6.0f);
        }
        return consumed;
    }

    default public boolean isMaxedOut() {
        return this.getNutrient(FarmlandBlockEntity.NutrientType.NITROGEN) == 1.0f && this.getNutrient(FarmlandBlockEntity.NutrientType.PHOSPHOROUS) == 1.0f && this.getNutrient(FarmlandBlockEntity.NutrientType.POTASSIUM) == 1.0f;
    }

    default public void saveNutrients(CompoundTag nbt) {
        nbt.m_128350_("n", this.getNutrient(FarmlandBlockEntity.NutrientType.NITROGEN));
        nbt.m_128350_("p", this.getNutrient(FarmlandBlockEntity.NutrientType.PHOSPHOROUS));
        nbt.m_128350_("k", this.getNutrient(FarmlandBlockEntity.NutrientType.POTASSIUM));
    }

    default public void loadNutrients(CompoundTag nbt) {
        this.setNutrient(FarmlandBlockEntity.NutrientType.NITROGEN, nbt.m_128457_("n"));
        this.setNutrient(FarmlandBlockEntity.NutrientType.PHOSPHOROUS, nbt.m_128457_("p"));
        this.setNutrient(FarmlandBlockEntity.NutrientType.POTASSIUM, nbt.m_128457_("k"));
    }

    default public void addTooltipInfo(List<Component> text) {
        text.add((Component)Helpers.translatable("tfc.tooltip.farmland.nutrients", this.format(this.getNutrient(FarmlandBlockEntity.NutrientType.NITROGEN)), this.format(this.getNutrient(FarmlandBlockEntity.NutrientType.PHOSPHOROUS)), this.format(this.getNutrient(FarmlandBlockEntity.NutrientType.POTASSIUM))));
    }

    private String format(float value) {
        return String.format("%.2f", Float.valueOf(value * 100.0f));
    }
}

